/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.variants.koi;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.emilsg.clutterbestiary.entity.variants.BestiaryBasicVariant;
import net.minecraft.ChatFormatting;
import net.minecraft.resources.ResourceLocation;

public enum KoiPrimaryPatternColorVariant implements BestiaryBasicVariant
{
    ORANGE("orange", ChatFormatting.GOLD, 16737302),
    YELLOW("yellow", ChatFormatting.YELLOW, 15718512),
    BLACK("black", ChatFormatting.DARK_GRAY, 4080969),
    RED("red", ChatFormatting.RED, 16721458),
    WHITE("white", ChatFormatting.WHITE, 0xEAEAFF);

    private static final Map<ResourceLocation, KoiPrimaryPatternColorVariant> BY_ID;
    public static final Codec<KoiPrimaryPatternColorVariant> CODEC;
    private final String name;
    private final ChatFormatting colorFormatting;
    private final int colorHex;

    private KoiPrimaryPatternColorVariant(String name, ChatFormatting colorFormatting, int colorHex) {
        this.name = name;
        this.colorFormatting = colorFormatting;
        this.colorHex = colorHex;
    }

    public static KoiPrimaryPatternColorVariant fromId(String id) {
        return Arrays.stream(KoiPrimaryPatternColorVariant.values()).filter(v -> v.getID().equals(id)).findFirst().orElse(ORANGE);
    }

    public static KoiPrimaryPatternColorVariant getRandom() {
        List<KoiPrimaryPatternColorVariant> variants = Arrays.stream(KoiPrimaryPatternColorVariant.values()).toList();
        return variants.get(new Random().nextInt(variants.size()));
    }

    @Override
    public String getID() {
        return "clutterbestiary:" + this.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ChatFormatting getFormatting() {
        return this.colorFormatting;
    }

    public int getColorHex() {
        return this.colorHex;
    }

    static {
        BY_ID = Arrays.stream(KoiPrimaryPatternColorVariant.values()).collect(Collectors.toMap(v -> ResourceLocation.fromNamespaceAndPath((String)"clutterbestiary", (String)v.getName()), v -> v));
        CODEC = ResourceLocation.CODEC.comapFlatMap(id -> {
            KoiPrimaryPatternColorVariant v = BY_ID.get(id);
            return v != null ? DataResult.success((Object)v) : DataResult.error(() -> "Unknown koi primary pattern color variant: " + String.valueOf(id));
        }, v -> ResourceLocation.fromNamespaceAndPath((String)"clutterbestiary", (String)v.getName()));
    }
}

