/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.neoforge.util;

import java.util.Optional;
import net.emilsg.clutterbestiary.entity.variants.ButterflyVariant;
import net.emilsg.clutterbestiary.entity.variants.SeahorseVariant;
import net.emilsg.clutterbestiary.entity.variants.koi.KoiBaseColorVariant;
import net.emilsg.clutterbestiary.item.custom.BestiaryElytraItem;
import net.emilsg.clutterbestiary.item.custom.ButterflyBottleItem;
import net.emilsg.clutterbestiary.item.custom.KoiBucketItem;
import net.emilsg.clutterbestiary.item.custom.SeahorseBucketItem;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.component.CustomData;

public class ModModelPredicateProvider {
    public static void register() {
        for (Item item : BuiltInRegistries.ITEM) {
            if (item instanceof BestiaryElytraItem) {
                ModModelPredicateProvider.registerElytra(item);
            }
            if (item instanceof ButterflyBottleItem) {
                ModModelPredicateProvider.registerButterflyInABottle(item);
            }
            if (item instanceof SeahorseBucketItem) {
                ModModelPredicateProvider.registerSeahorseBucket(item);
            }
            if (!(item instanceof KoiBucketItem)) continue;
            ModModelPredicateProvider.registerKoiBucket(item);
        }
    }

    private static void registerElytra(Item elytra) {
        ItemProperties.register((Item)elytra, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"broken"), (stack, world, entity, seed) -> {
            Item patt0$temp = stack.getItem();
            if (!(patt0$temp instanceof BestiaryElytraItem)) {
                return 0.0f;
            }
            BestiaryElytraItem bestiaryElytraItem = (BestiaryElytraItem)patt0$temp;
            return bestiaryElytraItem.isBroken(stack) ? 1.0f : 0.0f;
        });
    }

    private static void registerButterflyInABottle(Item bottle) {
        ItemProperties.register((Item)bottle, (ResourceLocation)ResourceLocation.parse((String)"type"), (stack, world, entity, seed) -> {
            if (!(stack.getItem() instanceof ButterflyBottleItem)) {
                return 0.0f;
            }
            CustomData nbtComponent = (CustomData)stack.getOrDefault(DataComponents.BUCKET_ENTITY_DATA, (Object)CustomData.EMPTY);
            Optional optional = nbtComponent.read(ButterflyBottleItem.BUTTERFLY_VARIANT_MAP_CODEC).result();
            if (optional.isEmpty()) {
                return 0.0f;
            }
            int id = ((ButterflyVariant)((Object)((Object)optional.get()))).getOrderedID();
            return (float)id / 100.0f;
        });
    }

    private static void registerSeahorseBucket(Item bucket) {
        ItemProperties.register((Item)bucket, (ResourceLocation)ResourceLocation.parse((String)"type"), (stack, world, entity, seed) -> {
            if (!(stack.getItem() instanceof SeahorseBucketItem)) {
                return 0.0f;
            }
            CustomData nbtComponent = (CustomData)stack.getOrDefault(DataComponents.BUCKET_ENTITY_DATA, (Object)CustomData.EMPTY);
            Optional optional = nbtComponent.read(SeahorseBucketItem.SEAHORSE_VARIANT_MAP_CODEC).result();
            if (optional.isEmpty()) {
                return 0.0f;
            }
            SeahorseVariant seahorseVariant = (SeahorseVariant)((Object)((Object)optional.get()));
            float type = switch (seahorseVariant) {
                case SeahorseVariant.LIGHT_BLUE -> 0.1f;
                case SeahorseVariant.RED -> 0.2f;
                case SeahorseVariant.PURPLE -> 0.3f;
                default -> 0.0f;
            };
            return type;
        });
    }

    private static void registerKoiBucket(Item bucket) {
        ItemProperties.register((Item)bucket, (ResourceLocation)ResourceLocation.parse((String)"type"), (stack, world, entity, seed) -> {
            if (!(stack.getItem() instanceof KoiBucketItem)) {
                return 0.0f;
            }
            CustomData cmp = (CustomData)stack.getOrDefault(DataComponents.BUCKET_ENTITY_DATA, (Object)CustomData.EMPTY);
            Optional base = cmp.read(KoiBucketItem.BASE_COLOR_CODEC).result();
            if (base.isEmpty()) {
                return 0.0f;
            }
            return switch ((KoiBaseColorVariant)base.get()) {
                case KoiBaseColorVariant.ORANGE -> 0.1f;
                case KoiBaseColorVariant.YELLOW -> 0.2f;
                case KoiBaseColorVariant.BLACK -> 0.3f;
                case KoiBaseColorVariant.PEARL -> 0.4f;
                default -> 0.0f;
            };
        });
    }
}

