/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.block.custom;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class HatchingEggBlock
extends Block {
    public static final IntegerProperty HATCH = BlockStateProperties.HATCH;
    private final Supplier<? extends EntityType<?>> type;
    private final float averageHatchTimeInMinutes;
    private final TagKey<Block> hatchBoostTag;
    private final double height;
    private final double width;

    public HatchingEggBlock(BlockBehaviour.Properties settings, Supplier<? extends EntityType<?>> type, float averageHatchTimeInMinutes, @Nullable TagKey<Block> hatchBoostTag, double height, double width) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HATCH, (Comparable)Integer.valueOf(0)));
        this.type = type;
        this.averageHatchTimeInMinutes = averageHatchTimeInMinutes;
        this.hatchBoostTag = hatchBoostTag;
        this.height = height;
        this.width = width;
    }

    public int getHatchStage(BlockState state) {
        return (Integer)state.getValue((Property)HATCH);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (this.width <= 0.0 || this.height <= 0.0) {
            return Shapes.block();
        }
        return Block.box((double)(8.0 - this.width / 2.0), (double)0.0, (double)(8.0 - this.width / 2.0), (double)(8.0 + this.width / 2.0), (double)this.height, (double)(8.0 + this.width / 2.0));
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean isRandomlyTicking(BlockState state) {
        return true;
    }

    public boolean isAboveHatchBooster(BlockGetter world, BlockPos pos) {
        if (this.hatchBoostTag == null) {
            return false;
        }
        return world.getBlockState(pos.below()).is(this.hatchBoostTag);
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        boolean aboveHatchBooster = this.isAboveHatchBooster((BlockGetter)world, pos);
        if (!world.isClientSide() && aboveHatchBooster) {
            world.levelEvent(3009, pos, 0);
        }
        float hatchTime = aboveHatchBooster ? this.averageHatchTimeInMinutes * 600.0f : this.averageHatchTimeInMinutes * 1200.0f;
        int hatchEventTime = (int)hatchTime / 3;
        world.gameEvent((Holder)GameEvent.BLOCK_PLACE, pos, GameEvent.Context.of((BlockState)state));
        world.scheduleTick(pos, (Block)this, hatchEventTime + world.random.nextInt(300));
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!this.isReadyToHatch(state)) {
            world.playSound(null, pos, SoundEvents.SNIFFER_EGG_CRACK, SoundSource.BLOCKS, 0.7f, 0.9f + random.nextFloat() * 0.2f);
            world.setBlock(pos, (BlockState)state.setValue((Property)HATCH, (Comparable)Integer.valueOf(this.getHatchStage(state) + 1)), 2);
        } else {
            world.playSound(null, pos, SoundEvents.SNIFFER_EGG_HATCH, SoundSource.BLOCKS, 0.7f, 0.9f + random.nextFloat() * 0.2f);
            world.destroyBlock(pos, false);
            Animal animalEntity = (Animal)this.type.get().create((Level)world);
            if (animalEntity != null) {
                Vec3 vec3d = pos.getCenter();
                animalEntity.setBaby(true);
                animalEntity.moveTo(vec3d.x(), vec3d.y(), vec3d.z(), Mth.wrapDegrees((float)(world.random.nextFloat() * 360.0f)), 0.0f);
                world.addFreshEntity((Entity)animalEntity);
            }
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HATCH});
    }

    private boolean isReadyToHatch(BlockState state) {
        return this.getHatchStage(state) == 2;
    }
}

