/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.emilsg.clutterbestiary.entity.client.animation.BoopletEntityAnimations;
import net.emilsg.clutterbestiary.entity.client.model.parent.BestiaryModel;
import net.emilsg.clutterbestiary.entity.custom.BoopletEntity;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class BoopletModel<T extends BoopletEntity>
extends BestiaryModel<T> {
    private final ModelPart root;
    private final ModelPart all;
    private final ModelPart body;
    private final ModelPart main;
    private final ModelPart fluff;

    public BoopletModel(ModelPart root) {
        this.root = root;
        this.all = root.getChild("all");
        this.body = this.all.getChild("body");
        this.main = this.body.getChild("main");
        this.fluff = this.main.getChild("fluff");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition all = modelPartData.addOrReplaceChild("all", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = all.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-5.0f, (float)0.0f));
        PartDefinition main = body.addOrReplaceChild("main", CubeListBuilder.create().texOffs(31, 47).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.125f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftEar = main.addOrReplaceChild("leftEar", CubeListBuilder.create().texOffs(0, 32).addBox(0.0f, 0.0f, -1.0f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)-2.0f, (float)0.0f));
        PartDefinition rightEar = main.addOrReplaceChild("rightEar", CubeListBuilder.create().texOffs(8, 32).mirror().addBox(-1.0f, 0.0f, -1.0f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-4.0f, (float)-2.0f, (float)0.0f));
        PartDefinition tail = main.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(34, 12).addBox(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(34, 28).addBox(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.125f)), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)3.5f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition fluff = main.addOrReplaceChild("fluff", CubeListBuilder.create().texOffs(0, 16).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.25f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition eyes = main.addOrReplaceChild("eyes", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)5.0f, (float)0.0f));
        PartDefinition leftEye = eyes.addOrReplaceChild("leftEye", CubeListBuilder.create().texOffs(57, 48).addBox(-1.0f, -1.0f, 0.2667f, 2.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(58, 47).addBox(1.0f, -1.0f, -0.7333f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(54, 48).addBox(-1.0f, -1.0f, -0.7333f, 2.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(58, 47).addBox(-1.0f, -1.0f, -0.7333f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(56, 48).addBox(-1.0f, 1.0f, -0.7333f, 2.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(57, 51).addBox(-0.5f, -0.5f, 0.1667f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)-5.0f, (float)-3.2667f));
        PartDefinition rightEye = eyes.addOrReplaceChild("rightEye", CubeListBuilder.create().texOffs(57, 48).addBox(-1.0f, -1.0f, 0.2667f, 2.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(58, 47).addBox(-1.0f, -1.0f, -0.7333f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(56, 48).addBox(-1.0f, 1.0f, -0.7333f, 2.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(54, 48).addBox(-1.0f, -1.0f, -0.7333f, 2.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(58, 47).addBox(1.0f, -1.0f, -0.7333f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(57, 51).addBox(-0.5f, -0.5f, 0.1667f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)-5.0f, (float)-3.2667f));
        PartDefinition leftHorn = body.addOrReplaceChild("leftHorn", CubeListBuilder.create().texOffs(19, 38).addBox(-1.0f, -1.5f, -3.0f, 2.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)-3.5f, (float)-2.0f));
        PartDefinition rightHorn = body.addOrReplaceChild("rightHorn", CubeListBuilder.create().texOffs(33, 38).mirror().addBox(-1.0f, -1.5f, -3.0f, 2.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-4.0f, (float)-3.5f, (float)-2.0f));
        PartDefinition frontRightLeg = all.addOrReplaceChild("frontRightLeg", CubeListBuilder.create().texOffs(10, 42).addBox(-1.0f, -0.5f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)-2.5f, (float)-2.0f));
        PartDefinition frontLeftLeg = all.addOrReplaceChild("frontLeftLeg", CubeListBuilder.create().texOffs(0, 42).addBox(-1.0f, -0.5f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)-2.5f, (float)-2.0f));
        PartDefinition backRightLeg = all.addOrReplaceChild("backRightLeg", CubeListBuilder.create().texOffs(10, 49).addBox(-1.0f, -0.5f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)-2.5f, (float)2.0f));
        PartDefinition backLeftLeg = all.addOrReplaceChild("backLeftLeg", CubeListBuilder.create().texOffs(0, 49).addBox(-1.0f, -0.5f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)-2.5f, (float)2.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)64, (int)64);
    }

    public ModelPart root() {
        return this.root;
    }

    public void renderToBuffer(PoseStack matrices, VertexConsumer vertices, int light, int overlay, int color) {
        this.root().render(matrices, vertices, light, overlay, color);
    }

    @Override
    public void setAngles(BoopletEntity boopletEntity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        if (!boopletEntity.isInWater()) {
            this.animateWalk(boopletEntity.isFleeing() ? BoopletEntityAnimations.BOOPLET_RUN : BoopletEntityAnimations.BOOPLET_WALK, limbSwing, limbSwingAmount, 1.5f, 2.0f);
        }
        this.animate(boopletEntity.swimAnimationState, BoopletEntityAnimations.BOOPLET_SWIM, ageInTicks, 1.0f);
        this.animate(boopletEntity.boopAnimationState, BoopletEntityAnimations.BOOPLET_BOOP, ageInTicks, 1.0f);
        this.animate(boopletEntity.happyAnimationState, BoopletEntityAnimations.BOOPLET_HAPPY, ageInTicks, 1.0f);
        this.fluff.visible = boopletEntity.isFluffy();
    }

    @Override
    protected ModelPart getHeadPart() {
        return null;
    }
}

