/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.emilsg.clutterbestiary.entity.custom.KoiEggsEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class KoiEggsModel<T extends KoiEggsEntity>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart all;
    private final ModelPart egg;
    private final ModelPart eggTwo;
    private final ModelPart eggThree;
    private final ModelPart eggFour;
    private final ModelPart eggFive;
    private final ModelPart eggSix;
    private final ModelPart eggSeven;
    private final ModelPart eggEight;

    public KoiEggsModel(ModelPart root) {
        this.root = root;
        this.all = root.getChild("all");
        this.egg = this.all.getChild("egg");
        this.eggTwo = this.all.getChild("eggTwo");
        this.eggThree = this.all.getChild("eggThree");
        this.eggFour = this.all.getChild("eggFour");
        this.eggFive = this.all.getChild("eggFive");
        this.eggSix = this.all.getChild("eggSix");
        this.eggSeven = this.all.getChild("eggSeven");
        this.eggEight = this.all.getChild("eggEight");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition all = modelPartData.addOrReplaceChild("all", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)21.0f, (float)0.0f));
        PartDefinition egg = all.addOrReplaceChild("egg", CubeListBuilder.create().texOffs(1, 1).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(7, 1).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)2.0f, (float)-4.0f));
        PartDefinition eggTwo = all.addOrReplaceChild("eggTwo", CubeListBuilder.create().texOffs(1, 1).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(7, 1).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.0f, (float)4.0f));
        PartDefinition eggThree = all.addOrReplaceChild("eggThree", CubeListBuilder.create().texOffs(1, 1).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(7, 1).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)-2.0f, (float)1.0f));
        PartDefinition eggFour = all.addOrReplaceChild("eggFour", CubeListBuilder.create().texOffs(11, 13).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(1, 11).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)0.0f, (float)-2.0f));
        PartDefinition eggFive = all.addOrReplaceChild("eggFive", CubeListBuilder.create().texOffs(11, 13).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(1, 11).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)3.0f, (float)0.0f));
        PartDefinition eggSix = all.addOrReplaceChild("eggSix", CubeListBuilder.create().texOffs(11, 13).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(1, 11).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)-1.0f, (float)-3.0f));
        PartDefinition eggSeven = all.addOrReplaceChild("eggSeven", CubeListBuilder.create().texOffs(1, 1).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(7, 1).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.0f, (float)-4.0f, (float)1.0f));
        PartDefinition eggEight = all.addOrReplaceChild("eggEight", CubeListBuilder.create().texOffs(11, 13).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(1, 11).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)4.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)16, (int)16);
    }

    public void renderToBuffer(PoseStack matrices, VertexConsumer vertices, int light, int overlay, int color) {
        this.root().render(matrices, vertices, light, overlay, color);
    }

    public void setAngles(T entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.applyBob(this.egg, animationProgress, 0.012f, 0.5f, 0.0f);
        this.applyBob(this.eggTwo, animationProgress, 0.01f, 0.4f, 0.5f);
        this.applyBob(this.eggThree, animationProgress, 0.008f, 0.35f, 1.0f);
        this.applyBob(this.eggFour, animationProgress, 0.014f, 0.45f, 1.5f);
        this.applyBob(this.eggFive, animationProgress, 0.011f, 0.3f, 0.25f);
        this.applyBob(this.eggSix, animationProgress, 0.009f, 0.5f, 0.75f);
        this.applyBob(this.eggSeven, animationProgress, 0.013f, 0.35f, 1.25f);
        this.applyBob(this.eggEight, animationProgress, 0.01f, 0.4f, 1.75f);
    }

    private void applyBob(ModelPart part, float time, float speed, float amplitude, float offset) {
        part.y += (float)(Math.sin((double)((time + offset) * speed) * Math.PI * 2.0) * (double)amplitude);
    }

    public ModelPart root() {
        return this.root;
    }
}

