/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.emilsg.clutterbestiary.entity.client.layer.ModModelLayers;
import net.emilsg.clutterbestiary.entity.client.model.BabyEmperorPenguinModel;
import net.emilsg.clutterbestiary.entity.client.model.EmperorPenguinModel;
import net.emilsg.clutterbestiary.entity.client.model.parent.BestiaryModel;
import net.emilsg.clutterbestiary.entity.custom.EmperorPenguinEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class EmperorPenguinRenderer
extends MobRenderer<EmperorPenguinEntity, BestiaryModel<EmperorPenguinEntity>> {
    public static final ResourceLocation ADULT_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"clutterbestiary", (String)"textures/entity/emperor_penguin/adult_emperor_penguin.png");
    public static final ResourceLocation BABY_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"clutterbestiary", (String)"textures/entity/emperor_penguin/baby_emperor_penguin.png");
    private final BabyEmperorPenguinModel<EmperorPenguinEntity> babyModel;
    private final EmperorPenguinModel<EmperorPenguinEntity> adultModel;

    public EmperorPenguinRenderer(EntityRendererProvider.Context ctx) {
        super(ctx, new EmperorPenguinModel(ctx.bakeLayer(ModModelLayers.EMPEROR_PENGUIN)), 0.3f);
        this.adultModel = new EmperorPenguinModel(ctx.bakeLayer(ModModelLayers.EMPEROR_PENGUIN));
        this.babyModel = new BabyEmperorPenguinModel(ctx.bakeLayer(ModModelLayers.BABY_EMPEROR_PENGUIN));
    }

    public ResourceLocation getTexture(EmperorPenguinEntity emperorPenguinEntity) {
        return emperorPenguinEntity.isBaby() ? BABY_TEXTURE : ADULT_TEXTURE;
    }

    public void render(EmperorPenguinEntity emperorPenguinEntity, float f, float g, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i) {
        this.model = emperorPenguinEntity.isBaby() ? this.babyModel : this.adultModel;
        super.render((LivingEntity)emperorPenguinEntity, f, g, matrixStack, vertexConsumerProvider, i);
    }
}

