/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.emilsg.clutterbestiary.entity.client.layer.ModModelLayers;
import net.emilsg.clutterbestiary.entity.client.model.MossbloomModel;
import net.emilsg.clutterbestiary.entity.client.render.feature.EmissiveRenderer;
import net.emilsg.clutterbestiary.entity.custom.MossbloomEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class MossbloomRenderer
extends MobRenderer<MossbloomEntity, MossbloomModel<MossbloomEntity>> {
    public MossbloomRenderer(EntityRendererProvider.Context ctx) {
        super(ctx, new MossbloomModel(ctx.bakeLayer(ModModelLayers.MOSSBLOOM)), 0.5f);
        this.addLayer(new EmissiveRenderer(this, MossbloomRenderer::getEmissiveTexture));
    }

    private static ResourceLocation getEmissiveTexture(MossbloomEntity mossbloomEntity) {
        return !mossbloomEntity.isBaby() ? mossbloomEntity.getVariant().getEmissiveTextureLocation() : null;
    }

    public ResourceLocation getTexture(MossbloomEntity mossbloomEntity) {
        return mossbloomEntity.getVariant().getTextureLocation();
    }

    public void render(MossbloomEntity mossbloomEntity, float f, float g, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i) {
        this.shadowRadius = 0.5f;
        super.render((LivingEntity)mossbloomEntity, f, g, matrixStack, vertexConsumerProvider, i);
    }
}

