/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.custom;

import java.util.ArrayList;
import java.util.function.Predicate;
import net.emilsg.clutterbestiary.entity.ModEntityTypes;
import net.emilsg.clutterbestiary.entity.custom.goal.BeaverStripBottomLogGoal;
import net.emilsg.clutterbestiary.entity.custom.goal.HighWanderAroundFarGoal;
import net.emilsg.clutterbestiary.entity.custom.parent.ParentAnimalEntity;
import net.emilsg.clutterbestiary.util.ModBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BeaverEntity
extends ParentAnimalEntity {
    private static final EntityDataAccessor<BlockPos> HOME_POS = SynchedEntityData.defineId(BeaverEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    private static final Ingredient BREEDING_INGREDIENT = BeaverEntity.getIngredientWithName("sapling");
    public final AnimationState waterAnimationState = new AnimationState();
    public final AnimationState idleAnimationState = new AnimationState();
    protected final WaterBoundPathNavigation waterNavigation;
    protected final GroundPathNavigation landNavigation;
    private int waterAnimationTimeout = 0;
    private int idleAnimationTimeout = 0;

    public BeaverEntity(EntityType<? extends ParentAnimalEntity> entityType, Level world) {
        super(entityType, world);
        this.setPathfindingMalus(PathType.DANGER_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.COCOA, -1.0f);
        this.moveControl = new BeaverMoveControl(this);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.waterNavigation = new WaterBoundPathNavigation((Mob)this, world);
        this.landNavigation = new GroundPathNavigation((Mob)this, world);
    }

    private static Ingredient getIngredientWithName(String name) {
        ArrayList items = new ArrayList();
        BuiltInRegistries.ITEM.forEach(item -> {
            ResourceLocation id = BuiltInRegistries.ITEM.getKey(item);
            if (id.getPath().contains(name)) {
                items.add(item);
            }
        });
        return Ingredient.of((ItemLike[])((ItemLike[])items.toArray(new Item[0])));
    }

    public float maxUpStep() {
        return 1.0f;
    }

    public static AttributeSupplier.Builder setAttributes() {
        return ParentAnimalEntity.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, (double)0.15f).add(Attributes.ATTACK_SPEED, 0.5).add(Attributes.ATTACK_KNOCKBACK, (double)0.1f).add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.FOLLOW_RANGE, 16.0);
    }

    public static boolean isValidNaturalSpawn(EntityType<? extends Animal> type, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return world.getBlockState(pos.below()).is(ModBlockTags.BEAVERS_SPAWN_ON);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        this.setHomePos(this.blockPosition());
        return super.finalizeSpawn(world, difficulty, spawnReason, entityData);
    }

    @Override
    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob entity) {
        return (AgeableMob)((EntityType)ModEntityTypes.BEAVER.get()).create((Level)world);
    }

    public void dropLeash(boolean sendPacket, boolean dropItem) {
        this.setHomePos(this.blockPosition());
        super.dropLeash(sendPacket, dropItem);
    }

    public float getAgeScale() {
        return this.isBaby() ? 0.6f : 1.0f;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        String path;
        String strippedPath;
        ItemStack stackInHand = player.getItemInHand(hand);
        String itemID = BuiltInRegistries.ITEM.getKey((Object)stackInHand.getItem()).toString();
        Block heldBlock = Block.byItem((Item)stackInHand.getItem());
        if (itemID.contains("planks")) {
            ItemStack sticksWithCount = new ItemStack((ItemLike)Items.STICK);
            sticksWithCount.setCount(this.random.nextIntBetweenInclusive(2, 3));
            this.spawnAtLocation(sticksWithCount);
            this.level().addDestroyBlockEffect(this.blockPosition(), heldBlock.defaultBlockState());
            if (!player.getAbilities().instabuild) {
                stackInHand.shrink(1);
            }
            this.playSound(SoundEvents.WOOD_BREAK, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        String[] parts = itemID.split(":", 2);
        String namespace = parts[0];
        ResourceLocation strippedID = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)(strippedPath = "stripped_" + (path = parts[1])));
        if (BuiltInRegistries.ITEM.containsKey(strippedID)) {
            this.spawnAtLocation(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(strippedID)));
            this.level().addDestroyBlockEffect(this.blockPosition(), heldBlock.defaultBlockState());
            if (!player.getAbilities().instabuild) {
                stackInHand.shrink(1);
            }
            this.playSound(SoundEvents.WOOD_BREAK, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected int decreaseAirSupply(int air) {
        return air;
    }

    @Override
    public boolean isFood(ItemStack stack) {
        return BREEDING_INGREDIENT.test(stack);
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        int i = nbt.getInt("HomePosX");
        int j = nbt.getInt("HomePosY");
        int k = nbt.getInt("HomePosZ");
        this.setHomePos(new BlockPos(i, j, k));
    }

    public void tick() {
        super.tick();
        Level world = this.level();
        if (world.isClientSide) {
            this.setupAnimationStates();
        }
    }

    public void travel(Vec3 movementInput) {
        if (this.isControlledByLocalInstance() && this.isInWater()) {
            this.moveRelative(0.1f, movementInput);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
            if (this.getTarget() == null) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.005, 0.0));
            }
        } else {
            super.travel(movementInput);
        }
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putInt("HomePosX", this.getHomePos().getX());
        nbt.putInt("HomePosY", this.getHomePos().getY());
        nbt.putInt("HomePosZ", this.getHomePos().getZ());
    }

    BlockPos getHomePos() {
        return (BlockPos)this.entityData.get(HOME_POS);
    }

    public void setHomePos(BlockPos pos) {
        this.entityData.set(HOME_POS, (Object)pos);
    }

    protected PathNavigation createNavigation(Level world) {
        return new BeaverSwimNavigation(this, world);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HOME_POS, (Object)BlockPos.ZERO);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(1, (Goal)new BeaverTemptGoal((PathfinderMob)this, 1.1f, BREEDING_INGREDIENT, false));
        this.goalSelector.addGoal(2, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, (double)1.2f, true));
        this.goalSelector.addGoal(4, (Goal)new BeaverStripBottomLogGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new HighWanderAroundFarGoal((PathfinderMob)this, 1.0, 0.001f));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    protected void updateWalkAnimation(float v) {
        float f = this.getPose() == Pose.STANDING ? Math.min(v * 6.0f, 1.0f) : 0.0f;
        this.walkAnimation.update(f, 0.5f);
    }

    private void setupAnimationStates() {
        if (this.waterAnimationTimeout <= 0) {
            this.waterAnimationTimeout = 20;
            this.waterAnimationState.startIfStopped(this.tickCount);
        } else {
            --this.waterAnimationTimeout;
        }
        if (this.idleAnimationTimeout <= 0 && !this.isMoving() && this.getNavigation().isDone()) {
            this.idleAnimationTimeout = 40;
            this.idleAnimationState.startIfStopped(this.tickCount);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    private static class BeaverMoveControl
    extends MoveControl {
        private final BeaverEntity beaver;

        public BeaverMoveControl(BeaverEntity beaver) {
            super((Mob)beaver);
            this.beaver = beaver;
        }

        public void tick() {
            if (this.beaver.isInWater()) {
                this.beaver.setDeltaMovement(this.beaver.getDeltaMovement().add(0.0, 0.005, 0.0));
                if (this.operation != MoveControl.Operation.MOVE_TO || this.beaver.getNavigation().isDone()) {
                    this.beaver.setSpeed(0.0f);
                    return;
                }
                double d = this.wantedX - this.beaver.getX();
                double e = this.wantedY - this.beaver.getY();
                double f = this.wantedZ - this.beaver.getZ();
                double g = Math.sqrt(d * d + e * e + f * f);
                e /= g;
                float h = (float)(Mth.atan2((double)f, (double)d) * 57.2957763671875) - 90.0f;
                this.beaver.setYRot(this.rotlerp(this.beaver.getYRot(), h, 90.0f));
                this.beaver.yBodyRot = this.beaver.getYRot();
                float i = (float)(this.speedModifier * this.beaver.getAttributeValue(Attributes.MOVEMENT_SPEED));
                float j = Mth.lerp((float)0.125f, (float)this.beaver.getSpeed(), (float)i);
                this.beaver.setSpeed(j);
                this.beaver.setDeltaMovement(this.beaver.getDeltaMovement().add(0.0, (double)this.beaver.getSpeed() * e * 0.1, 0.0));
            } else {
                this.beaver.setDeltaMovement(this.beaver.getDeltaMovement().add(0.0, 0.0, 0.0));
                super.tick();
            }
        }
    }

    private static class BeaverSwimNavigation
    extends AmphibiousPathNavigation {
        BeaverSwimNavigation(BeaverEntity owner, Level world) {
            super((Mob)owner, world);
        }

        public boolean isStableDestination(BlockPos pos) {
            if (this.mob instanceof BeaverEntity) {
                return this.level.getBlockState(pos).is(Blocks.WATER) || this.level.getBlockState(pos).canBeReplaced() && this.level.getBlockState(pos.below()).isRedstoneConductor((BlockGetter)this.level, pos.below());
            }
            return !this.level.getBlockState(pos.below()).isAir();
        }
    }

    private static class BeaverTemptGoal
    extends TemptGoal {
        private final BeaverEntity beaver;

        public BeaverTemptGoal(PathfinderMob entity, double speed, Ingredient food, boolean canBeScared) {
            super(entity, speed, (Predicate)food, canBeScared);
            this.beaver = (BeaverEntity)entity;
        }

        public void stop() {
            super.stop();
            this.beaver.setHomePos(this.beaver.blockPosition());
        }
    }
}

