/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.custom;

import java.util.List;
import java.util.function.Predicate;
import net.emilsg.clutterbestiary.entity.custom.goal.JellyfishAvoidSurfaceGoal;
import net.emilsg.clutterbestiary.entity.variants.JellyfishVariant;
import net.emilsg.clutterbestiary.util.ModBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class JellyfishEntity
extends WaterAnimal {
    private static final EntityDataAccessor<String> VARIANT = SynchedEntityData.defineId(JellyfishEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final Predicate<LivingEntity> TARGET_FILTER = entity -> {
        if (entity instanceof Player && ((Player)entity).isCreative()) {
            return false;
        }
        return !entity.getType().is(EntityTypeTags.AQUATIC);
    };
    private static final TargetingConditions TARGET_PREDICATE = TargetingConditions.forNonCombat().ignoreInvisibilityTesting().ignoreLineOfSight().selector(TARGET_FILTER);
    public final AnimationState swimmingAnimationState = new AnimationState();
    public float tiltAngle;
    public float prevTiltAngle;
    public float rollAngle;
    public float prevRollAngle;
    public float thrustTimer;
    public float prevThrustTimer;
    private float swimVelocityScale;
    private float thrustTimerSpeed;
    private float turningSpeed;
    private float swimX;
    private float swimY;
    private float swimZ;
    private int animationTimeout = 0;

    public JellyfishEntity(EntityType<? extends WaterAnimal> entityType, Level world) {
        super(entityType, world);
        this.random.setSeed((long)this.getId());
        this.thrustTimerSpeed = 0.25f / (this.random.nextFloat() + 1.0f) * 0.2f;
    }

    public static AttributeSupplier.Builder setAttributes() {
        return WaterAnimal.createMobAttributes().add(Attributes.MAX_HEALTH, 4.0);
    }

    public static boolean isValidNaturalSpawn(EntityType<? extends WaterAnimal> type, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return world.getBlockState(pos).is(ModBlockTags.JELLYFISHES_SPAWN_ON);
    }

    public boolean hurt(DamageSource source, float amount) {
        LivingEntity attacker;
        Entity entity = source.getEntity();
        if (entity instanceof LivingEntity && (attacker = (LivingEntity)entity).level() instanceof ServerLevel && !attacker.getType().is(EntityTypeTags.AQUATIC) && this.random.nextInt(3) == 0) {
            attacker.addEffect(new MobEffectInstance(MobEffects.POISON, 100, 1), (Entity)this);
        }
        return super.hurt(source, amount);
    }

    public String getTypeVariant() {
        return (String)this.entityData.get(VARIANT);
    }

    public JellyfishVariant getVariant() {
        return JellyfishVariant.fromId(this.getTypeVariant());
    }

    public void setVariant(JellyfishVariant variant) {
        this.entityData.set(VARIANT, (Object)variant.getId());
    }

    public boolean hasSwimmingVector() {
        return this.swimX != 0.0f || this.swimY != 0.0f || this.swimZ != 0.0f;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        this.setVariant(JellyfishVariant.getRandom());
        return super.finalizeSpawn(world, difficulty, spawnReason, entityData);
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.entityData.set(VARIANT, (Object)nbt.getString("Variant"));
    }

    public void setSwimmingVector(float x, float y, float z) {
        this.swimX = x;
        this.swimY = y;
        this.swimZ = z;
    }

    public void tick() {
        super.tick();
        Level world = this.level();
        if (world.isClientSide) {
            this.setupAnimationStates();
        }
    }

    public float getSwimX() {
        return this.swimX;
    }

    public void setSwimX(float swimX) {
        this.swimX = swimX;
    }

    public void travel(Vec3 movementInput) {
        this.move(MoverType.SELF, this.getDeltaMovement());
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putString("Variant", this.getTypeVariant());
    }

    protected float getSoundVolume() {
        return 0.4f;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)JellyfishVariant.GREEN.getId());
    }

    public float getSwimY() {
        return this.swimY;
    }

    public void setSwimY(float swimY) {
        this.swimY = swimY;
    }

    private void sting(LivingEntity mob) {
        if (mob.hurt(this.damageSources().mobAttack((LivingEntity)this), 2.0f)) {
            mob.addEffect(new MobEffectInstance(MobEffects.POISON, 120, 1), (Entity)this);
            this.playSound(SoundEvents.SLIME_ATTACK, 1.0f, 1.0f);
        }
    }

    public float getSwimZ() {
        return this.swimZ;
    }

    public void setSwimZ(float swimZ) {
        this.swimZ = swimZ;
    }

    public void aiStep() {
        super.aiStep();
        if (this.isAlive()) {
            List list = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(0.3), entity -> TARGET_PREDICATE.test((LivingEntity)this, entity));
            for (LivingEntity mobEntity : list) {
                if (!mobEntity.isAlive()) continue;
                this.sting(mobEntity);
            }
        }
        this.prevTiltAngle = this.tiltAngle;
        this.prevRollAngle = this.rollAngle;
        this.prevThrustTimer = this.thrustTimer;
        this.thrustTimer += this.thrustTimerSpeed;
        if ((double)this.thrustTimer > Math.PI * 2) {
            if (this.level().isClientSide) {
                this.thrustTimer = (float)Math.PI * 2;
            } else {
                this.thrustTimer -= (float)Math.PI * 2;
                if (this.random.nextInt(10) == 0) {
                    this.thrustTimerSpeed = 0.25f / (this.random.nextFloat() + 1.0f) * 0.1f;
                }
            }
        }
        if (this.isInWaterOrBubble()) {
            if (this.thrustTimer < (float)Math.PI) {
                float f = this.thrustTimer / (float)Math.PI;
                if ((double)f > 0.75) {
                    this.swimVelocityScale = 1.0f;
                    this.turningSpeed = 1.0f;
                } else {
                    this.turningSpeed *= 0.8f;
                }
            } else {
                this.swimVelocityScale *= 0.9f;
                this.turningSpeed *= 0.99f;
            }
            if (!this.level().isClientSide) {
                this.setDeltaMovement(this.swimX * this.swimVelocityScale * 0.3f, this.swimY * this.swimVelocityScale * 0.3f, this.swimZ * this.swimVelocityScale * 0.3f);
            }
            Vec3 vec3d = this.getDeltaMovement();
            double d = vec3d.horizontalDistance();
            float targetYaw = (float)(-Mth.atan2((double)vec3d.x, (double)vec3d.z) * 57.2957763671875);
            float deltaYaw = Mth.wrapDegrees((float)(targetYaw - this.getYRot()));
            this.setYRot(this.getYRot() + deltaYaw * 0.1f);
            float targetPitch = (float)(-Math.toDegrees(Mth.atan2((double)vec3d.y, (double)vec3d.horizontalDistance())));
            float deltaPitch = Mth.wrapDegrees((float)(targetPitch - this.getXRot()));
            this.setXRot(this.getXRot() + deltaPitch * 0.1f);
            this.rollAngle += (float)Math.PI * this.turningSpeed * 1.5f;
            this.tiltAngle += (-((float)Mth.atan2((double)d, (double)vec3d.y)) * 57.295776f - this.tiltAngle) * 0.05f;
            if (Math.abs(this.tiltAngle) > 30.0f) {
                this.tiltAngle *= 0.9f;
            }
        } else {
            if (!this.level().isClientSide) {
                double e = this.getDeltaMovement().y;
                if (this.hasEffect(MobEffects.LEVITATION)) {
                    e = 0.05 * (double)(this.getEffect(MobEffects.LEVITATION).getAmplifier() + 1);
                } else if (!this.isNoGravity()) {
                    e -= 0.08;
                }
                this.setDeltaMovement(0.0, e * (double)0.49f, 0.0);
            }
            this.tiltAngle += (-90.0f - this.tiltAngle) * 0.02f;
        }
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.SLIME_HURT;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new SwimGoal(this));
        this.goalSelector.addGoal(1, (Goal)new JellyfishAvoidSurfaceGoal(this));
    }

    protected void updateWalkAnimation(float v) {
        float f = this.getPose() == Pose.STANDING ? Math.min(v * 6.0f, 1.0f) : 0.0f;
        this.walkAnimation.update(f * 1.25f, 0.5f);
    }

    private void setupAnimationStates() {
        if (this.animationTimeout <= 0) {
            this.animationTimeout = 80;
            this.swimmingAnimationState.start(this.tickCount);
        } else {
            --this.animationTimeout;
        }
    }

    static class SwimGoal
    extends Goal {
        private final JellyfishEntity jellyfish;

        public SwimGoal(JellyfishEntity jellyfish) {
            this.jellyfish = jellyfish;
        }

        public boolean canUse() {
            return this.jellyfish.isInWaterOrBubble();
        }

        public void tick() {
            int i = this.jellyfish.getNoActionTime();
            if (i > 100) {
                this.jellyfish.setSwimmingVector(0.0f, 0.0f, 0.0f);
            } else if (this.jellyfish.getRandom().nextInt(SwimGoal.reducedTickDelay((int)50)) == 0 || !this.jellyfish.isInWater() || !this.jellyfish.hasSwimmingVector()) {
                float f = this.jellyfish.getRandom().nextFloat() * ((float)Math.PI * 2);
                float g = Mth.cos((float)f) * 0.2f;
                float h = -0.1f + this.jellyfish.getRandom().nextFloat() * 0.2f;
                float j = Mth.sin((float)f) * 0.2f;
                this.jellyfish.setSwimmingVector(g, h, j);
            }
        }
    }
}

