/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.custom;

import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.emilsg.clutterbestiary.entity.ModEntityTypes;
import net.emilsg.clutterbestiary.entity.custom.KoiEggsEntity;
import net.emilsg.clutterbestiary.entity.custom.goal.KoiMateGoal;
import net.emilsg.clutterbestiary.entity.custom.parent.ParentFishEntity;
import net.emilsg.clutterbestiary.entity.variants.koi.KoiBaseColorVariant;
import net.emilsg.clutterbestiary.entity.variants.koi.KoiPrimaryPatternColorVariant;
import net.emilsg.clutterbestiary.entity.variants.koi.KoiPrimaryPatternTypeVariant;
import net.emilsg.clutterbestiary.entity.variants.koi.KoiSecondaryPatternColorVariant;
import net.emilsg.clutterbestiary.entity.variants.koi.KoiSecondaryPatternTypeVariant;
import net.emilsg.clutterbestiary.entity.variants.koi.KoiVariantCompatibility;
import net.emilsg.clutterbestiary.item.ModItems;
import net.emilsg.clutterbestiary.util.ModBlockTags;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class KoiEntity
extends ParentFishEntity {
    private static final EntityDataAccessor<String> BASE_COLOR = SynchedEntityData.defineId(KoiEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<String> PRIMARY_PATTERN_COLOR = SynchedEntityData.defineId(KoiEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<String> PRIMARY_PATTERN_TYPE = SynchedEntityData.defineId(KoiEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<String> SECONDARY_PATTERN_COLOR = SynchedEntityData.defineId(KoiEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<String> SECONDARY_PATTERN_TYPE = SynchedEntityData.defineId(KoiEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Boolean> CHILD = SynchedEntityData.defineId(KoiEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected int breedingAge;
    protected int forcedAge;
    protected int happyTicksRemaining;
    private int loveTicks;
    private final Item breedingItem = Items.KELP;
    @Nullable
    private UUID lovingPlayer;
    public final AnimationState swimmingAnimationState = new AnimationState();
    private int swimmingAnimationTimeout = 0;

    public KoiEntity(EntityType<? extends AbstractFish> entityType, Level world) {
        super(entityType, world);
    }

    public void loadFromBucketTag(CompoundTag nbt) {
        super.loadFromBucketTag(nbt);
        if (nbt.contains("BaseColor", 8)) {
            this.setBaseColorVariant(KoiBaseColorVariant.fromId(nbt.getString("BaseColor")));
        }
        if (nbt.contains("PrimaryPatternColor", 8)) {
            this.setPrimaryPatternColorVariant(KoiPrimaryPatternColorVariant.fromId(nbt.getString("PrimaryPatternColor")));
        }
        if (nbt.contains("PrimaryPatternType", 8)) {
            this.setPrimaryPatternTypeVariant(KoiPrimaryPatternTypeVariant.fromId(nbt.getString("PrimaryPatternType")));
        }
        if (nbt.contains("SecondaryPatternColor", 8)) {
            this.setSecondaryPatternColorVariant(KoiSecondaryPatternColorVariant.fromId(nbt.getString("SecondaryPatternColor")));
        }
        if (nbt.contains("SecondaryPatternType", 8)) {
            this.setSecondaryPatternTypeVariant(KoiSecondaryPatternTypeVariant.fromId(nbt.getString("SecondaryPatternType")));
        }
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new KoiMateGoal(this, 1.0, KoiEntity.class));
        this.goalSelector.addGoal(2, (Goal)new TemptGoal((PathfinderMob)this, 1.25, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.KELP}), false));
    }

    public void tick() {
        super.tick();
        Level world = this.level();
        if (world.isClientSide) {
            this.setupAnimationStates();
        }
    }

    private void setupAnimationStates() {
        if (this.swimmingAnimationTimeout <= 0) {
            this.swimmingAnimationTimeout = 20;
            this.swimmingAnimationState.start(this.tickCount);
        } else {
            --this.swimmingAnimationTimeout;
        }
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putString("BaseColor", this.getBaseColorVariant().getID());
        nbt.putString("PrimaryPatternColor", this.getPrimaryPatternColorVariant().getID());
        nbt.putString("PrimaryPatternType", this.getPrimaryPatternTypeVariant().getID());
        nbt.putString("SecondaryPatternColor", this.getSecondaryPatternColorVariant().getID());
        nbt.putString("SecondaryPatternType", this.getSecondaryPatternTypeVariant().getID());
        nbt.putInt("InLove", this.loveTicks);
        if (this.lovingPlayer != null) {
            nbt.putUUID("LoveCause", this.lovingPlayer);
        }
        nbt.putInt("Age", this.getBreedingAge());
        nbt.putInt("ForcedAge", this.forcedAge);
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.setBaseColorVariant(KoiBaseColorVariant.fromId(nbt.getString("BaseColor")));
        this.setPrimaryPatternColorVariant(KoiPrimaryPatternColorVariant.fromId(nbt.getString("PrimaryPatternColor")));
        this.setPrimaryPatternTypeVariant(KoiPrimaryPatternTypeVariant.fromId(nbt.getString("PrimaryPatternType")));
        this.setSecondaryPatternColorVariant(KoiSecondaryPatternColorVariant.fromId(nbt.getString("SecondaryPatternColor")));
        this.setSecondaryPatternTypeVariant(KoiSecondaryPatternTypeVariant.fromId(nbt.getString("SecondaryPatternType")));
        this.loveTicks = nbt.getInt("InLove");
        this.lovingPlayer = nbt.hasUUID("LoveCause") ? nbt.getUUID("LoveCause") : null;
        this.setBreedingAge(nbt.getInt("Age"));
        this.forcedAge = nbt.getInt("ForcedAge");
    }

    public void saveToBucketTag(ItemStack stack) {
        super.saveToBucketTag(stack);
        CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)stack, nbt -> {
            nbt.putString("BaseColor", this.getBaseColorVariant().getID());
            nbt.putString("PrimaryPatternType", this.getPrimaryPatternTypeVariant().getID());
            nbt.putString("PrimaryPatternColor", this.getPrimaryPatternColorVariant().getID());
            nbt.putString("SecondaryPatternType", this.getSecondaryPatternTypeVariant().getID());
            nbt.putString("SecondaryPatternColor", this.getSecondaryPatternColorVariant().getID());
        });
    }

    public KoiBaseColorVariant getBaseColorVariant() {
        return KoiBaseColorVariant.fromId((String)this.entityData.get(BASE_COLOR));
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.SALMON_DEATH;
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.SALMON_HURT;
    }

    public void setBaseColorVariant(KoiBaseColorVariant baseColorVariant) {
        this.entityData.set(BASE_COLOR, (Object)baseColorVariant.getID());
    }

    public KoiPrimaryPatternColorVariant getPrimaryPatternColorVariant() {
        return KoiPrimaryPatternColorVariant.fromId((String)this.entityData.get(PRIMARY_PATTERN_COLOR));
    }

    public void setPrimaryPatternColorVariant(KoiPrimaryPatternColorVariant primaryPatternColorVariant) {
        this.entityData.set(PRIMARY_PATTERN_COLOR, (Object)primaryPatternColorVariant.getID());
    }

    public KoiPrimaryPatternTypeVariant getPrimaryPatternTypeVariant() {
        return KoiPrimaryPatternTypeVariant.fromId((String)this.entityData.get(PRIMARY_PATTERN_TYPE));
    }

    public void setPrimaryPatternTypeVariant(KoiPrimaryPatternTypeVariant primaryPatternTypeVariant) {
        this.entityData.set(PRIMARY_PATTERN_TYPE, (Object)primaryPatternTypeVariant.getID());
    }

    public KoiSecondaryPatternColorVariant getSecondaryPatternColorVariant() {
        return KoiSecondaryPatternColorVariant.fromId((String)this.entityData.get(SECONDARY_PATTERN_COLOR));
    }

    public void setSecondaryPatternColorVariant(KoiSecondaryPatternColorVariant secondaryPatternColorVariant) {
        this.entityData.set(SECONDARY_PATTERN_COLOR, (Object)secondaryPatternColorVariant.getID());
    }

    public KoiSecondaryPatternTypeVariant getSecondaryPatternTypeVariant() {
        return KoiSecondaryPatternTypeVariant.fromId((String)this.entityData.get(SECONDARY_PATTERN_TYPE));
    }

    public void setSecondaryPatternTypeVariant(KoiSecondaryPatternTypeVariant secondaryPatternTypeVariant) {
        this.entityData.set(SECONDARY_PATTERN_TYPE, (Object)secondaryPatternTypeVariant.getID());
    }

    public static AttributeSupplier.Builder setAttributes() {
        return ParentFishEntity.createMobAttributes().add(Attributes.MAX_HEALTH, 6.0);
    }

    @Override
    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)ModItems.KOI_BUCKET.get());
    }

    @Override
    protected SoundEvent getFlopSound() {
        return SoundEvents.TROPICAL_FISH_FLOP;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        KoiSecondaryPatternTypeVariant secondaryType;
        KoiSecondaryPatternColorVariant secondaryColor;
        KoiPrimaryPatternTypeVariant primaryType;
        KoiPrimaryPatternColorVariant primaryColor;
        KoiBaseColorVariant base;
        AgeableMob.AgeableMobGroupData passiveData;
        if (entityData == null) {
            entityData = new AgeableMob.AgeableMobGroupData(true);
        }
        if ((passiveData = (AgeableMob.AgeableMobGroupData)entityData).isShouldSpawnBaby() && passiveData.getGroupSize() > 0 && world.getRandom().nextFloat() <= passiveData.getBabySpawnChance()) {
            this.setBreedingAge(-24000);
        }
        passiveData.increaseGroupSizeByOne();
        while (!KoiVariantCompatibility.isValid(base = KoiBaseColorVariant.getRandom(), primaryColor = KoiPrimaryPatternColorVariant.getRandom(), primaryType = KoiPrimaryPatternTypeVariant.getRandom(), secondaryColor = KoiSecondaryPatternColorVariant.getRandom(), secondaryType = KoiSecondaryPatternTypeVariant.getRandom())) {
        }
        this.setBaseColorVariant(base);
        this.setPrimaryPatternColorVariant(primaryColor);
        this.setPrimaryPatternTypeVariant(primaryType);
        this.setSecondaryPatternColorVariant(secondaryColor);
        this.setSecondaryPatternTypeVariant(secondaryType);
        if (base.hasSeparateTexture()) {
            this.setPrimaryPatternTypeVariant(KoiPrimaryPatternTypeVariant.NONE);
            this.setSecondaryPatternTypeVariant(KoiSecondaryPatternTypeVariant.NONE);
        }
        return super.finalizeSpawn(world, difficulty, spawnReason, entityData);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(BASE_COLOR, (Object)KoiBaseColorVariant.ORANGE.getID());
        builder.define(PRIMARY_PATTERN_COLOR, (Object)KoiPrimaryPatternColorVariant.WHITE.getID());
        builder.define(PRIMARY_PATTERN_TYPE, (Object)KoiPrimaryPatternTypeVariant.SPOTTED.getID());
        builder.define(SECONDARY_PATTERN_COLOR, (Object)KoiSecondaryPatternColorVariant.BLACK.getID());
        builder.define(SECONDARY_PATTERN_TYPE, (Object)KoiSecondaryPatternTypeVariant.SMALL_SPOTS.getID());
        builder.define(CHILD, (Object)false);
    }

    private InteractionResult tryBucket(Player player, InteractionHand hand, KoiEntity koiEntity) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.getItem() == Items.WATER_BUCKET && koiEntity.isAlive()) {
            koiEntity.playSound(koiEntity.getPickupSound(), 1.0f, 1.0f);
            ItemStack filledBucketItem = koiEntity.getBucketItemStack();
            koiEntity.saveToBucketTag(filledBucketItem);
            ItemStack itemStack3 = ItemUtils.createFilledResult((ItemStack)itemStack, (Player)player, (ItemStack)filledBucketItem, (boolean)false);
            player.setItemInHand(hand, itemStack3);
            Level world = koiEntity.level();
            if (!world.isClientSide) {
                CriteriaTriggers.FILLED_BUCKET.trigger((ServerPlayer)player, filledBucketItem);
            }
            koiEntity.discard();
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return InteractionResult.PASS;
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (this.isBreedingItem(itemStack)) {
            int i = this.getBreedingAge();
            if (!this.level().isClientSide && i == 0 && this.canEat()) {
                this.eat(player, hand, itemStack);
                this.lovePlayer(player);
                return InteractionResult.SUCCESS;
            }
            if (this.isBaby()) {
                this.eat(player, hand, itemStack);
                this.growUp(KoiEntity.toGrowUpAge(-i), true);
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            if (this.level().isClientSide) {
                return InteractionResult.CONSUME;
            }
        } else if (itemStack.is(Items.BUCKET)) {
            return this.tryBucket(player, hand, this);
        }
        return super.mobInteract(player, hand);
    }

    public static boolean isValidNaturalSpawn(EntityType<? extends WaterAnimal> type, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return world.getBlockState(pos).is(ModBlockTags.KOI_SPAWN_ON);
    }

    public static int toGrowUpAge(int breedingAge) {
        return (int)((float)(breedingAge / 20) * 0.1f);
    }

    public void breed(ServerLevel world, KoiEntity other) {
        this.breed(world, other, null);
    }

    public void breed(ServerLevel world, KoiEntity other, @Nullable KoiEntity baby) {
        KoiSecondaryPatternTypeVariant secondaryType;
        KoiSecondaryPatternColorVariant secondaryColor;
        KoiPrimaryPatternTypeVariant primaryType;
        KoiPrimaryPatternColorVariant primaryColor;
        KoiBaseColorVariant base;
        this.setBreedingAge(6000);
        other.setBreedingAge(6000);
        KoiEggsEntity koiEggs = (KoiEggsEntity)((EntityType)ModEntityTypes.KOI_EGGS.get()).create((Level)world);
        if (koiEggs == null) {
            return;
        }
        while (!KoiVariantCompatibility.isValid(base = this.getWeightedVariant(this, other, 40, 40, 20, KoiEntity::getBaseColorVariant, KoiBaseColorVariant::getRandom), primaryColor = this.getWeightedVariant(this, other, 40, 40, 20, KoiEntity::getPrimaryPatternColorVariant, KoiPrimaryPatternColorVariant::getRandom), primaryType = this.getWeightedVariant(this, other, 40, 40, 20, KoiEntity::getPrimaryPatternTypeVariant, KoiPrimaryPatternTypeVariant::getRandom), secondaryColor = this.getWeightedVariant(this, other, 40, 40, 20, KoiEntity::getSecondaryPatternColorVariant, KoiSecondaryPatternColorVariant::getRandom), secondaryType = this.getWeightedVariant(this, other, 40, 40, 20, KoiEntity::getSecondaryPatternTypeVariant, KoiSecondaryPatternTypeVariant::getRandom))) {
        }
        koiEggs.setBaseColorVariant(base);
        koiEggs.setPrimaryPatternColorVariant(primaryColor);
        koiEggs.setPrimaryPatternTypeVariant(primaryType);
        koiEggs.setSecondaryPatternColorVariant(secondaryColor);
        koiEggs.setSecondaryPatternTypeVariant(secondaryType);
        koiEggs.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), this.getXRot());
        world.addFreshEntity((Entity)koiEggs);
        this.resetLoveTicks();
        other.resetLoveTicks();
        world.broadcastEntityEvent((Entity)this, (byte)18);
        if (world.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
            int xp = this.getRandom().nextInt(7) + 1;
            world.addFreshEntity((Entity)new ExperienceOrb((Level)world, this.getX(), this.getY(), this.getZ(), xp));
        }
    }

    public <T> T getWeightedVariant(KoiEntity parent1, KoiEntity parent2, int parent1Weight, int parent2Weight, int randomWeight, Function<KoiEntity, T> getter, Supplier<T> randomSupplier) {
        int total = parent1Weight + parent2Weight + randomWeight;
        int decider = parent1.getRandom().nextInt(total);
        if (decider < parent1Weight) {
            return getter.apply(parent1);
        }
        if (decider < parent1Weight + parent2Weight) {
            return getter.apply(parent2);
        }
        return randomSupplier.get();
    }

    public boolean canBreedWith(KoiEntity other) {
        if (other == this) {
            return false;
        }
        if (((Object)((Object)other)).getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        return this.isInLove() && other.isInLove();
    }

    public boolean canEat() {
        return this.loveTicks <= 0;
    }

    @Nullable
    public KoiEntity createChild(ServerLevel world, KoiEntity entity) {
        return (KoiEntity)((EntityType)ModEntityTypes.KOI.get()).create((Level)world);
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        this.loveTicks = 0;
        return super.hurt(source, amount);
    }

    public int getBreedingAge() {
        if (this.level().isClientSide) {
            return (Boolean)this.entityData.get(CHILD) != false ? -1 : 1;
        }
        return this.breedingAge;
    }

    public void setBreedingAge(int age) {
        int i = this.getBreedingAge();
        this.breedingAge = age;
        if (i < 0 && age >= 0 || i >= 0 && age < 0) {
            this.entityData.set(CHILD, (Object)(age < 0 ? 1 : 0));
            this.onGrowUp();
        }
    }

    public int getLoveTicks() {
        return this.loveTicks;
    }

    public void setLoveTicks(int loveTicks) {
        this.loveTicks = loveTicks;
    }

    @Nullable
    public ServerPlayer getLovingPlayer() {
        if (this.lovingPlayer == null) {
            return null;
        }
        Player playerEntity = this.level().getPlayerByUUID(this.lovingPlayer);
        return playerEntity instanceof ServerPlayer ? (ServerPlayer)playerEntity : null;
    }

    public void growUp(int age, boolean overGrow) {
        int i;
        int j = i = this.getBreedingAge();
        if ((i += age * 20) > 0) {
            i = 0;
        }
        int k = i - j;
        this.setBreedingAge(i);
        if (overGrow) {
            this.forcedAge += k;
            if (this.happyTicksRemaining == 0) {
                this.happyTicksRemaining = 40;
            }
        }
        if (this.getBreedingAge() == 0) {
            this.setBreedingAge(this.forcedAge);
        }
    }

    public void growUp(int age) {
        this.growUp(age, false);
    }

    public void handleEntityEvent(byte status) {
        if (status == 18) {
            for (int i = 0; i < 7; ++i) {
                double d = this.random.nextGaussian() * 0.02;
                double e = this.random.nextGaussian() * 0.02;
                double f = this.random.nextGaussian() * 0.02;
                this.level().addParticle((ParticleOptions)ParticleTypes.HEART, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), d, e, f);
            }
        } else {
            super.handleEntityEvent(status);
        }
    }

    public boolean isBaby() {
        return this.getBreedingAge() < 0;
    }

    public void setBaby(boolean baby) {
        this.setBreedingAge(baby ? -24000 : 0);
    }

    public boolean isBreedingItem(ItemStack stack) {
        return stack.is(this.breedingItem);
    }

    public boolean isInLove() {
        return this.getLoveTicks() > 0;
    }

    public boolean isReadyToBreed() {
        return false;
    }

    public void lovePlayer(@Nullable Player player) {
        this.loveTicks = 600;
        if (player != null) {
            this.lovingPlayer = player.getUUID();
        }
        this.level().broadcastEntityEvent((Entity)this, (byte)18);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> data) {
        if (CHILD.equals(data)) {
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(data);
    }

    public void resetLoveTicks() {
        this.setLoveTicks(0);
    }

    @Override
    public void aiStep() {
        if (!this.isInWater() && this.onGround() && this.verticalCollision) {
            this.setDeltaMovement(this.getDeltaMovement().add((double)((this.random.nextFloat() * 2.0f - 1.0f) * 0.05f), (double)0.4f, (double)((this.random.nextFloat() * 2.0f - 1.0f) * 0.05f)));
            this.setOnGround(false);
            this.hasImpulse = true;
            this.playSound(this.getFlopSound(), this.getSoundVolume(), this.getVoicePitch());
        }
        if (this.getBreedingAge() != 0) {
            this.loveTicks = 0;
        }
        if (this.loveTicks > 0) {
            --this.loveTicks;
            if (this.loveTicks % 10 == 0) {
                double d = this.random.nextGaussian() * 0.02;
                double e = this.random.nextGaussian() * 0.02;
                double f = this.random.nextGaussian() * 0.02;
                this.level().addParticle((ParticleOptions)ParticleTypes.HEART, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), d, e, f);
            }
        }
        if (this.level().isClientSide) {
            if (this.happyTicksRemaining > 0) {
                if (this.happyTicksRemaining % 4 == 0) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), 0.0, 0.0, 0.0);
                }
                --this.happyTicksRemaining;
            }
        } else if (this.isAlive()) {
            int i = this.getBreedingAge();
            if (i < 0) {
                this.setBreedingAge(++i);
            } else if (i > 0) {
                this.setBreedingAge(--i);
            }
        }
        super.aiStep();
    }

    protected void eat(Player player, InteractionHand hand, ItemStack stack) {
        if (!player.getAbilities().instabuild) {
            stack.shrink(1);
        }
    }

    protected void customServerAiStep() {
        if (this.getBreedingAge() != 0) {
            this.loveTicks = 0;
        }
        super.customServerAiStep();
    }

    protected void onGrowUp() {
        Boat boatEntity;
        Entity var2;
        if (!this.isBaby() && this.isPassenger() && (var2 = this.getVehicle()) instanceof Boat && !(boatEntity = (Boat)var2).hasEnoughSpaceFor((Entity)this)) {
            this.stopRiding();
        }
    }
}

