/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.custom;

import java.util.EnumSet;
import java.util.List;
import net.emilsg.clutterbestiary.entity.ModEntityTypes;
import net.emilsg.clutterbestiary.entity.custom.PotionSacEntity;
import net.emilsg.clutterbestiary.entity.custom.parent.ParentAnimalEntity;
import net.emilsg.clutterbestiary.entity.variants.PotionWaspVariant;
import net.emilsg.clutterbestiary.util.ModBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class PotionWaspEntity
extends ParentAnimalEntity {
    private static final EntityDataAccessor<String> VARIANT = SynchedEntityData.defineId(PotionWaspEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Boolean> HAS_POTION_SAC = SynchedEntityData.defineId(PotionWaspEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public final AnimationState flyingAnimState = new AnimationState();
    private int animationTimeout = 0;

    public PotionWaspEntity(EntityType<? extends Animal> entityType, Level world) {
        super(entityType, world);
        this.moveControl = new FlyingMoveControl((Mob)this, 20, true);
        this.lookControl = new PotionWaspLookControl((Mob)this);
    }

    public boolean canBeAffected(MobEffectInstance effectInstance) {
        List<Holder<MobEffect>> potionEffects = PotionWaspVariant.getAllStatusEffects();
        for (Holder<MobEffect> effect : potionEffects) {
            if (effectInstance.getEffect() != effect) continue;
            return false;
        }
        return true;
    }

    public static AttributeSupplier.Builder setAttributes() {
        return ParentAnimalEntity.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.FLYING_SPEED, 0.5).add(Attributes.MOVEMENT_SPEED, (double)0.1f).add(Attributes.FOLLOW_RANGE, 16.0);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        PotionWaspVariant variant = PotionWaspVariant.getRandom();
        this.setVariant(variant);
        this.setHasPotionSac(true);
        return super.finalizeSpawn(world, difficulty, spawnReason, entityData);
    }

    public boolean hurt(DamageSource source, float amount) {
        Level level;
        if (this.hasPotionSac() && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            PotionSacEntity potionSacEntity = (PotionSacEntity)((EntityType)ModEntityTypes.POTION_SAC.get()).create((Level)serverWorld);
            if (potionSacEntity == null) {
                return super.hurt(source, amount);
            }
            potionSacEntity.setVariant(this.getVariant());
            potionSacEntity.setPos(this.position().add(0.0, -0.25, 0.0));
            potionSacEntity.setOnGround(false);
            serverWorld.addFreshEntity((Entity)potionSacEntity);
            this.setHasPotionSac(false);
        }
        return super.hurt(source, amount);
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader world) {
        return world.getBlockState(pos).isAir() ? 10.0f : 0.0f;
    }

    public String getTypeVariant() {
        return (String)this.entityData.get(VARIANT);
    }

    public PotionWaspVariant getVariant() {
        return PotionWaspVariant.fromId(this.getTypeVariant());
    }

    public void setVariant(PotionWaspVariant variant) {
        this.entityData.set(VARIANT, (Object)variant.getId());
    }

    public boolean causeFallDamage(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    public boolean hasPotionSac() {
        return (Boolean)this.entityData.get(HAS_POTION_SAC);
    }

    @Override
    public boolean isFood(ItemStack stack) {
        return false;
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.entityData.set(VARIANT, (Object)nbt.getString("Variant"));
        this.entityData.set(HAS_POTION_SAC, (Object)nbt.getBoolean("HasPotionSac"));
    }

    public void setHasPotionSac(boolean hasPotionSac) {
        this.entityData.set(HAS_POTION_SAC, (Object)hasPotionSac);
    }

    public void knockback(double strength, double x, double z) {
        super.knockback(this.hasPotionSac() ? 0.0 : strength, x, z);
    }

    public void tick() {
        super.tick();
        Level world = this.level();
        if (world.isClientSide) {
            this.setupAnimationStates();
        }
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putString("Variant", this.getTypeVariant());
        nbt.putBoolean("HasPotionSac", this.hasPotionSac());
    }

    public static boolean isValidNaturalSpawn(EntityType<? extends Animal> type, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return world.getBlockState(pos.below()).is(ModBlockTags.POTION_WASPS_SPAWN_ON);
    }

    protected PathNavigation createNavigation(Level world) {
        FlyingPathNavigation birdNavigation = new FlyingPathNavigation(this, (Mob)this, world){

            public boolean isStableDestination(BlockPos pos) {
                return !this.level.getBlockState(pos.below()).isAir();
            }
        };
        birdNavigation.setCanOpenDoors(false);
        birdNavigation.setCanFloat(false);
        birdNavigation.setCanPassDoors(true);
        return birdNavigation;
    }

    protected void checkFallDamage(double heightDifference, boolean onGround, BlockState state, BlockPos landedPosition) {
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return null;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)PotionWaspVariant.REGENERATION.getId());
        builder.define(HAS_POTION_SAC, (Object)true);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new PotionWaspWanderAroundGoal(this));
    }

    private void setupAnimationStates() {
        if (this.animationTimeout <= 0) {
            this.animationTimeout = 40;
            this.flyingAnimState.start(this.tickCount);
        } else {
            --this.animationTimeout;
        }
    }

    static class PotionWaspLookControl
    extends LookControl {
        PotionWaspLookControl(Mob entity) {
            super(entity);
        }

        public void tick() {
            super.tick();
        }

        protected boolean resetXRotOnTick() {
            return true;
        }
    }

    class PotionWaspWanderAroundGoal
    extends Goal {
        PotionWaspWanderAroundGoal(PotionWaspEntity potionWasp) {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            return PotionWaspEntity.this.navigation.isDone() && PotionWaspEntity.this.random.nextInt(4) == 0;
        }

        public boolean canContinueToUse() {
            return PotionWaspEntity.this.navigation.isInProgress();
        }

        public void start() {
            Vec3 vec3d = this.getRandomLocation();
            if (vec3d != null) {
                PotionWaspEntity.this.navigation.moveTo(PotionWaspEntity.this.navigation.createPath(BlockPos.containing((Position)vec3d), 1), 1.0);
            }
        }

        @Nullable
        private Vec3 getRandomLocation() {
            Vec3 vec3d2 = PotionWaspEntity.this.getViewVector(0.0f);
            Vec3 vec3d3 = HoverRandomPos.getPos((PathfinderMob)PotionWaspEntity.this, (int)8, (int)7, (double)vec3d2.x, (double)vec3d2.z, (float)1.5707964f, (int)3, (int)1);
            return vec3d3 != null ? vec3d3 : AirAndWaterRandomPos.getPos((PathfinderMob)PotionWaspEntity.this, (int)8, (int)4, (int)-2, (double)vec3d2.x, (double)vec3d2.z, (double)1.5707963705062866);
        }
    }
}

