/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.custom.goal;

import net.emilsg.clutterbestiary.util.ModBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BeaverStripBottomLogGoal
extends MoveToBlockGoal {
    private Block targetBlock;
    private Block strippedTargetBlock;
    private BlockState strippedTargetState;

    public BeaverStripBottomLogGoal(PathfinderMob mob, double speed) {
        super(mob, speed, 8);
    }

    public boolean canUse() {
        return super.canUse() && this.mob.getRandom().nextInt(100) == 0;
    }

    public double acceptedDistance() {
        return 2.0;
    }

    public void tick() {
        super.tick();
        if (this.isReachedTarget()) {
            Level world = this.mob.level();
            if (this.targetBlock != null && this.strippedTargetBlock != null && this.strippedTargetState != null) {
                this.mob.playSound(SoundEvents.WOOD_BREAK, 1.0f, this.mob.getVoicePitch());
                if (world instanceof ServerLevel) {
                    world.setBlock(this.blockPos, this.strippedTargetState, 3);
                }
                this.stop();
            }
        }
    }

    protected boolean isValidTarget(LevelReader world, BlockPos pos) {
        String path;
        String strippedPath;
        boolean isStrippableBlock;
        BlockState state = world.getBlockState(pos);
        boolean bl = isStrippableBlock = !String.valueOf(state.getBlock()).contains("stripped") && !state.is(ModBlockTags.STRIPPED_LOGS) && !state.is(ModBlockTags.STRIPPED_WOODS) && (state.is(BlockTags.LOGS) || state.is(ModBlockTags.WOODS));
        if (world.getBlockState(pos.below()).is(BlockTags.LOGS) || !isStrippableBlock) {
            return false;
        }
        Block block = state.getBlock();
        if (block == null) {
            return false;
        }
        this.targetBlock = state.getBlock();
        String raw = String.valueOf(block).replace("Block{", "").replace("}", "");
        ResourceLocation blockID = ResourceLocation.tryParse((String)raw);
        if (blockID == null) {
            return false;
        }
        String[] parts = raw.split(":", 2);
        String namespace = parts[0];
        ResourceLocation strippedID = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)(strippedPath = "stripped_" + (path = parts[1])));
        if (!BuiltInRegistries.BLOCK.containsKey(strippedID)) {
            return false;
        }
        this.targetBlock = state.getBlock();
        this.strippedTargetBlock = (Block)BuiltInRegistries.BLOCK.get(strippedID);
        this.strippedTargetState = this.strippedTargetBlock.defaultBlockState();
        if (this.targetBlock instanceof RotatedPillarBlock) {
            this.strippedTargetState = (BlockState)this.strippedTargetState.setValue((Property)RotatedPillarBlock.AXIS, (Comparable)((Direction.Axis)state.getValue((Property)RotatedPillarBlock.AXIS)));
        }
        return world.getBlockState(pos).is(BlockTags.LOGS);
    }
}

