/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.custom.goal;

import java.util.EnumSet;
import net.emilsg.clutterbestiary.entity.custom.ButterflyEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ButterflyWanderOverworldGoal
extends Goal {
    ButterflyEntity butterfly;

    public ButterflyWanderOverworldGoal(ButterflyEntity butterfly) {
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        this.butterfly = butterfly;
    }

    public boolean canUse() {
        return this.butterfly.level().dimensionTypeRegistration().is(BuiltinDimensionTypes.OVERWORLD) && this.butterfly.getNavigation().isDone() && this.butterfly.getRandom().nextInt(10) == 0;
    }

    public boolean canContinueToUse() {
        return this.butterfly.getNavigation().isInProgress();
    }

    public void start() {
        Vec3 vec3d = this.getRandomLocation();
        if (vec3d != null) {
            this.butterfly.getNavigation().moveTo(this.butterfly.getNavigation().createPath(BlockPos.containing((Position)vec3d), 1), 1.0);
        }
    }

    @Nullable
    private Vec3 getRandomLocation() {
        Vec3 vec3d2 = this.butterfly.getViewVector(0.0f);
        int i = 8;
        Vec3 vec3d3 = HoverRandomPos.getPos((PathfinderMob)this.butterfly, (int)8, (int)7, (double)vec3d2.x, (double)vec3d2.z, (float)1.5707964f, (int)4, (int)2);
        if (vec3d3 != null) {
            return vec3d3;
        }
        return AirAndWaterRandomPos.getPos((PathfinderMob)this.butterfly, (int)8, (int)4, (int)-2, (double)vec3d2.x, (double)vec3d2.z, (double)1.5707963705062866);
    }
}

