/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.custom.goal;

import java.util.EnumSet;
import net.emilsg.clutterbestiary.entity.custom.EchofinEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.phys.Vec3;

public class EchofinWanderAroundGoal
extends Goal {
    EchofinEntity echofinEntity;
    private BlockPos homePos;

    public EchofinWanderAroundGoal(EchofinEntity echofinEntity) {
        this.echofinEntity = echofinEntity;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        return this.echofinEntity.getNavigation().isDone();
    }

    public boolean canContinueToUse() {
        return this.echofinEntity.getNavigation().isInProgress();
    }

    public void start() {
        Vec3 vec3d = this.getRandomLocation();
        if (vec3d != null) {
            this.echofinEntity.getNavigation().moveTo(this.echofinEntity.getNavigation().createPath(BlockPos.containing((Position)vec3d), 1), 1.0);
        }
    }

    private Vec3 getRandomLocation() {
        if (this.homePos == null) {
            this.homePos = this.echofinEntity.getHomePos();
        }
        Vec3 vec3d2 = this.echofinEntity.getViewVector(0.0f);
        Vec3 vec3d3 = HoverRandomPos.getPos((PathfinderMob)this.echofinEntity, (int)24, (int)7, (double)vec3d2.x, (double)vec3d2.z, (float)1.5707964f, (int)3, (int)2);
        if (vec3d3 != null && this.echofinEntity.blockPosition().distToCenterSqr((Position)Vec3.atCenterOf((Vec3i)this.homePos)) > 4.0) {
            return vec3d3;
        }
        if (this.echofinEntity.level().isNight() && this.echofinEntity.blockPosition().distToCenterSqr((Position)Vec3.atCenterOf((Vec3i)this.homePos)) > 64.0) {
            return Vec3.atCenterOf((Vec3i)this.homePos);
        }
        BlockPos blockpos = this.homePos.offset(-2 + this.echofinEntity.getRandom().nextInt(5), -1 + this.echofinEntity.getRandom().nextInt(3), -2 + this.echofinEntity.getRandom().nextInt(5));
        if (!this.echofinEntity.level().getBlockState(blockpos).canOcclude()) {
            return Vec3.atCenterOf((Vec3i)blockpos);
        }
        return null;
    }
}

