/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.custom.goal;

import net.emilsg.clutterbestiary.entity.custom.EmberTortoiseEntity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.animal.Animal;

public class EmberTortoiseLookAtEntityGoal
extends LookAtPlayerGoal {
    Animal animalEntity;

    public EmberTortoiseLookAtEntityGoal(Animal animal, Class<? extends LivingEntity> targetType, float range) {
        super((Mob)animal, targetType, range);
        this.animalEntity = animal;
    }

    public boolean canUse() {
        Animal animal = this.animalEntity;
        if (animal instanceof EmberTortoiseEntity) {
            EmberTortoiseEntity emberTortoise = (EmberTortoiseEntity)animal;
            return !emberTortoise.isShielding() && super.canUse();
        }
        return super.canUse();
    }

    public boolean canContinueToUse() {
        EmberTortoiseEntity emberTortoise;
        Animal animal = this.animalEntity;
        if (animal instanceof EmberTortoiseEntity && (emberTortoise = (EmberTortoiseEntity)animal).isShielding()) {
            return false;
        }
        return this.lookAt != null && super.canContinueToUse();
    }

    public void tick() {
        EmberTortoiseEntity emberTortoise;
        super.tick();
        Animal animal = this.animalEntity;
        if (animal instanceof EmberTortoiseEntity && (emberTortoise = (EmberTortoiseEntity)animal).isShielding()) {
            this.stop();
        }
    }
}

