/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.custom.parent;

import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public abstract class ParentFishEntity
extends AbstractFish {
    private static final EntityDataAccessor<Boolean> MOVING = SynchedEntityData.defineId(ParentFishEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    protected ParentFishEntity(EntityType<? extends AbstractFish> entityType, Level world) {
        super(entityType, world);
    }

    public abstract ItemStack getBucketItemStack();

    public boolean getHasSelfControl() {
        return this.canRandomSwim();
    }

    public boolean isMoving() {
        return (Boolean)this.entityData.get(MOVING);
    }

    public void setMoving(boolean moving) {
        this.entityData.set(MOVING, (Object)moving);
    }

    public void aiStep() {
        if (!this.level().isClientSide) {
            Vec3 velocity = this.getDeltaMovement();
            boolean isMoving = velocity.lengthSqr() > (double)5.0E-4f;
            this.setMoving(isMoving);
        }
        super.aiStep();
    }

    public void travel(Vec3 movementInput) {
        if (this.isEffectiveAi() && this.isInWater()) {
            this.moveRelative(0.01f, movementInput);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.7));
            if (this.getTarget() == null) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.005, 0.0));
            }
        } else {
            super.travel(movementInput);
        }
    }

    protected abstract SoundEvent getFlopSound();

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(MOVING, (Object)false);
    }
}

