/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.variants.koi;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.emilsg.clutterbestiary.entity.variants.BestiaryBasicVariant;
import net.minecraft.ChatFormatting;
import net.minecraft.resources.ResourceLocation;

public enum KoiSecondaryPatternTypeVariant implements BestiaryBasicVariant
{
    NONE("none", ChatFormatting.STRIKETHROUGH),
    SMALL_SPOTS("small_spots", ChatFormatting.ITALIC),
    MEDIUM_SPOTS("medium_spots", ChatFormatting.ITALIC);

    private static final Map<ResourceLocation, KoiSecondaryPatternTypeVariant> BY_ID;
    public static final Codec<KoiSecondaryPatternTypeVariant> CODEC;
    private final String name;
    private final ChatFormatting formatting;

    private KoiSecondaryPatternTypeVariant(String name, ChatFormatting formatting) {
        this.name = name;
        this.formatting = formatting;
    }

    public static KoiSecondaryPatternTypeVariant fromId(String id) {
        return Arrays.stream(KoiSecondaryPatternTypeVariant.values()).filter(v -> v.getID().equals(id)).findFirst().orElse(NONE);
    }

    public static KoiSecondaryPatternTypeVariant getRandom() {
        List<KoiSecondaryPatternTypeVariant> variants = Arrays.stream(KoiSecondaryPatternTypeVariant.values()).toList();
        return variants.get(new Random().nextInt(variants.size()));
    }

    @Override
    public String getID() {
        return "clutterbestiary:" + this.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ChatFormatting getFormatting() {
        return this.formatting;
    }

    public ResourceLocation getTextureLocation() {
        return ResourceLocation.fromNamespaceAndPath((String)"clutterbestiary", (String)("textures/entity/koi/koi_secondary_pattern_" + this.getName() + ".png"));
    }

    static {
        BY_ID = Arrays.stream(KoiSecondaryPatternTypeVariant.values()).collect(Collectors.toMap(v -> ResourceLocation.fromNamespaceAndPath((String)"clutterbestiary", (String)v.getName()), v -> v));
        CODEC = ResourceLocation.CODEC.comapFlatMap(id -> {
            KoiSecondaryPatternTypeVariant v = BY_ID.get(id);
            return v != null ? DataResult.success((Object)v) : DataResult.error(() -> "Unknown koi secondary pattern type variant: " + String.valueOf(id));
        }, v -> ResourceLocation.fromNamespaceAndPath((String)"clutterbestiary", (String)v.getName()));
    }
}

