/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.util;

import dev.architectury.registry.level.biome.BiomeModifications;
import dev.architectury.registry.level.entity.SpawnPlacementsRegistry;
import net.emilsg.clutterbestiary.entity.ModEntityTypes;
import net.emilsg.clutterbestiary.entity.custom.BeaverEntity;
import net.emilsg.clutterbestiary.entity.custom.BoopletEntity;
import net.emilsg.clutterbestiary.entity.custom.ButterflyEntity;
import net.emilsg.clutterbestiary.entity.custom.CapybaraEntity;
import net.emilsg.clutterbestiary.entity.custom.ChameleonEntity;
import net.emilsg.clutterbestiary.entity.custom.CrimsonNewtEntity;
import net.emilsg.clutterbestiary.entity.custom.DragonflyEntity;
import net.emilsg.clutterbestiary.entity.custom.EchofinEntity;
import net.emilsg.clutterbestiary.entity.custom.EmberTortoiseEntity;
import net.emilsg.clutterbestiary.entity.custom.EmperorPenguinEntity;
import net.emilsg.clutterbestiary.entity.custom.JellyfishEntity;
import net.emilsg.clutterbestiary.entity.custom.KiwiBirdEntity;
import net.emilsg.clutterbestiary.entity.custom.KoiEntity;
import net.emilsg.clutterbestiary.entity.custom.MantaRayEntity;
import net.emilsg.clutterbestiary.entity.custom.MossbloomEntity;
import net.emilsg.clutterbestiary.entity.custom.PotionWaspEntity;
import net.emilsg.clutterbestiary.entity.custom.SeahorseEntity;
import net.emilsg.clutterbestiary.entity.custom.WarpedNewtEntity;
import net.emilsg.clutterbestiary.util.ModBiomeTags;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.Heightmap;

public class ModUtil {
    public static Component buildCyclicFormattedName(String translationKey, int[] colorCycle, int tickOffset, boolean reverse) {
        MutableComponent finalText = Component.literal((String)"");
        String translated = Component.translatable((String)translationKey).getString();
        int cycleLength = colorCycle.length;
        for (int i = 0; i < translated.length(); ++i) {
            int colorIndex = reverse ? (i - tickOffset) % cycleLength : (i + tickOffset) % cycleLength;
            if (colorIndex < 0) {
                colorIndex += cycleLength;
            }
            int rgb = colorCycle[colorIndex];
            finalText.append((Component)Component.literal((String)String.valueOf(translated.charAt(i))).withStyle(style -> style.withColor(rgb)));
        }
        return finalText;
    }

    public static void grantImpossibleAdvancement(String path, ServerLevel world, Player player) {
        if (player instanceof ServerPlayer) {
            AdvancementProgress progress;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MinecraftServer server = world.getServer();
            AdvancementHolder advancement = server.getAdvancements().get(ResourceLocation.fromNamespaceAndPath((String)"clutterbestiary", (String)path));
            if (serverPlayer.getAdvancements().getOrStartProgress(advancement).isDone()) {
                return;
            }
            if (advancement != null && !(progress = serverPlayer.getAdvancements().getOrStartProgress(advancement)).isDone()) {
                for (String criterion : progress.getRemainingCriteria()) {
                    serverPlayer.getAdvancements().award(advancement, criterion);
                }
            }
        }
    }

    public static void registerSpawns() {
        BiomeModifications.addProperties(ctx -> ctx.hasTag(ModBiomeTags.SPAWNS_CHAMELEONS), (ctx, props) -> props.getSpawnProperties().addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntityTypes.CHAMELEON.get(), 100, 2, 4)));
    }

    public static void registerSpawnRestrictions() {
        SpawnPlacementsRegistry.register(ModEntityTypes.DRAGONFLY, (SpawnPlacementType)SpawnPlacementTypes.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, DragonflyEntity::isValidNaturalSpawn);
        SpawnPlacementsRegistry.register(ModEntityTypes.MOSSBLOOM, (SpawnPlacementType)SpawnPlacementTypes.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, MossbloomEntity::isValidNaturalSpawn);
        SpawnPlacementsRegistry.register(ModEntityTypes.CHAMELEON, (SpawnPlacementType)SpawnPlacementTypes.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ChameleonEntity::isValidNaturalSpawn);
        SpawnPlacementsRegistry.register(ModEntityTypes.KIWI_BIRD, (SpawnPlacementType)SpawnPlacementTypes.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, KiwiBirdEntity::isValidNaturalSpawn);
        SpawnPlacementsRegistry.register(ModEntityTypes.EMPEROR_PENGUIN, (SpawnPlacementType)SpawnPlacementTypes.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EmperorPenguinEntity::isValidNaturalSpawn);
        SpawnPlacementsRegistry.register(ModEntityTypes.BEAVER, (SpawnPlacementType)SpawnPlacementTypes.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BeaverEntity::isValidNaturalSpawn);
        SpawnPlacementsRegistry.register(ModEntityTypes.CAPYBARA, (SpawnPlacementType)SpawnPlacementTypes.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, CapybaraEntity::isValidNaturalSpawn);
        SpawnPlacementsRegistry.register(ModEntityTypes.BOOPLET, (SpawnPlacementType)SpawnPlacementTypes.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BoopletEntity::isValidNaturalSpawn);
        SpawnPlacementsRegistry.register(ModEntityTypes.POTION_WASP, (SpawnPlacementType)SpawnPlacementTypes.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, PotionWaspEntity::isValidNaturalSpawn);
        SpawnPlacementsRegistry.register(ModEntityTypes.JELLYFISH, (SpawnPlacementType)SpawnPlacementTypes.IN_WATER, (Heightmap.Types)Heightmap.Types.OCEAN_FLOOR, JellyfishEntity::isValidNaturalSpawn);
        SpawnPlacementsRegistry.register(ModEntityTypes.SEAHORSE, (SpawnPlacementType)SpawnPlacementTypes.IN_WATER, (Heightmap.Types)Heightmap.Types.OCEAN_FLOOR, SeahorseEntity::isValidNaturalSpawn);
        SpawnPlacementsRegistry.register(ModEntityTypes.MANTA_RAY, (SpawnPlacementType)SpawnPlacementTypes.IN_WATER, (Heightmap.Types)Heightmap.Types.OCEAN_FLOOR, MantaRayEntity::isValidNaturalSpawn);
        SpawnPlacementsRegistry.register(ModEntityTypes.KOI, (SpawnPlacementType)SpawnPlacementTypes.IN_WATER, (Heightmap.Types)Heightmap.Types.OCEAN_FLOOR, KoiEntity::isValidNaturalSpawn);
        SpawnPlacementsRegistry.register(ModEntityTypes.BUTTERFLY, (SpawnPlacementType)SpawnPlacementTypes.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ButterflyEntity::isValidNaturalSpawn);
        SpawnPlacementsRegistry.register(ModEntityTypes.CRIMSON_NEWT, (SpawnPlacementType)SpawnPlacementTypes.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, CrimsonNewtEntity::isValidNaturalSpawn);
        SpawnPlacementsRegistry.register(ModEntityTypes.WARPED_NEWT, (SpawnPlacementType)SpawnPlacementTypes.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, WarpedNewtEntity::isValidNaturalSpawn);
        SpawnPlacementsRegistry.register(ModEntityTypes.EMBER_TORTOISE, (SpawnPlacementType)SpawnPlacementTypes.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EmberTortoiseEntity::isValidNaturalSpawn);
        SpawnPlacementsRegistry.register(ModEntityTypes.ECHOFIN, (SpawnPlacementType)SpawnPlacementTypes.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EchofinEntity::isValidNaturalSpawn);
    }
}

