/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.iconleadingtooltip.util;

public final class IconLeadingUtil {
    private IconLeadingUtil() {
    }

    public static boolean isIconGlyph(int cp) {
        return cp >= 57344 && cp <= 63743 || cp >= 63744 && cp <= 64255 || cp >= 983040 && cp <= 1048573 || cp >= 0x100000 && cp <= 1114109;
    }

    public static int[] firstIconSpan(String s) {
        int len;
        for (int i = 0; i < s.length(); i += len) {
            int cp = s.codePointAt(i);
            len = Character.charCount(cp);
            if (!IconLeadingUtil.isIconGlyph(cp)) continue;
            return new int[]{i, i + len};
        }
        return new int[]{-1, -1};
    }

    public static String stripSectionCodes(String s) {
        StringBuilder out = new StringBuilder(s.length());
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            if (ch == '\u00a7') {
                if (i + 1 < s.length() && (s.charAt(i + 1) == 'x' || s.charAt(i + 1) == 'X')) {
                    i += 2;
                    for (int k = 0; k < 6 && i + 1 < s.length() && s.charAt(i) == '\u00a7'; ++k) {
                        i += 2;
                    }
                    continue;
                }
                i = Math.min(i + 2, s.length());
                continue;
            }
            out.append(ch);
            ++i;
        }
        return out.toString();
    }
}

