/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.iconleadingtooltip.client;

import dev.architectury.platform.Platform;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.bettercombat.api.WeaponAttributes;
import net.bettercombat.logic.EntityAttributeHelper;
import net.bettercombat.logic.WeaponRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.pixeldreamstudios.iconleadingtooltip.util.IconLeadingUtil;

public final class BcAttackRangeTooltip {
    private BcAttackRangeTooltip() {
    }

    public static void append(ItemStack stack, LocalPlayer player, List<Component> lines) {
        double totalRange;
        if (!Platform.isModLoaded((String)"bettercombat")) {
            return;
        }
        if (Platform.isModLoaded((String)"dynamictooltips")) {
            return;
        }
        WeaponAttributes attributes = WeaponRegistry.getAttributes((ItemStack)stack);
        if (attributes == null || attributes.attacks() == null || attributes.attacks().length == 0) {
            return;
        }
        AttributeInstance reachAttr = player.getAttribute(Attributes.BLOCK_INTERACTION_RANGE);
        if (reachAttr == null) {
            return;
        }
        ModifierTracker tracker = new ModifierTracker(reachAttr.getBaseValue());
        BcAttackRangeTooltip.addAllReachModifiersFrom(player, tracker);
        ItemStack equipped = player.getMainHandItem();
        boolean viewingEquipped = ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)equipped);
        if (!viewingEquipped) {
            BcAttackRangeTooltip.removeMainHandReachFrom(equipped, tracker);
            BcAttackRangeTooltip.addMainHandReachFrom(stack, tracker);
        }
        tracker.calculateValue();
        if (!EntityAttributeHelper.itemHasRangeAttribute((ItemStack)stack)) {
            tracker.currentTrackedValue += attributes.rangeBonus();
        }
        if ((totalRange = tracker.currentTrackedValue) <= 0.0) {
            return;
        }
        int insertAt = BcAttackRangeTooltip.findInsertIndex(lines);
        MutableComponent rangeLine = BcAttackRangeTooltip.buildRangeLine(totalRange);
        lines.add(Math.min(insertAt + 1, lines.size()), (Component)rangeLine);
    }

    private static int findInsertIndex(List<Component> lines) {
        int lastAttributeLine = -1;
        Integer lastGreenAttributeIndex = null;
        for (int i = 0; i < lines.size(); ++i) {
            Component line = lines.get(i);
            ComponentContents content = line.getContents();
            if (content instanceof TranslatableContents) {
                TranslatableContents tr = (TranslatableContents)content;
                String key = tr.getKey();
                if (!key.startsWith("attribute.modifier")) continue;
                lastAttributeLine = i;
                continue;
            }
            for (Component part : line.getSiblings()) {
                ComponentContents pc = part.getContents();
                if (!(pc instanceof TranslatableContents)) continue;
                TranslatableContents ptr = (TranslatableContents)pc;
                String pKey = ptr.getKey();
                if (pKey.contains("attribute.modifier.equals.0")) {
                    lastGreenAttributeIndex = i;
                }
                if (!pKey.startsWith("attribute.modifier")) continue;
                lastAttributeLine = i;
            }
        }
        if (lastGreenAttributeIndex != null) {
            return lastGreenAttributeIndex;
        }
        if (lastAttributeLine >= 0) {
            return lastAttributeLine;
        }
        return lines.size() - 1;
    }

    private static MutableComponent buildRangeLine(double range) {
        MutableComponent attr = Component.translatable((String)"attribute.name.generic.attack_range");
        String raw = attr.getString();
        int[] span = IconLeadingUtil.firstIconSpan(raw);
        if (span[0] >= 0) {
            String icon = raw.substring(span[0], span[1]);
            String restRaw = raw.substring(0, span[0]) + raw.substring(span[1]);
            String rest = IconLeadingUtil.stripSectionCodes(restRaw).replaceFirst("^\\s+", "");
            MutableComponent attrNoIcon = Component.literal((String)rest);
            MutableComponent body = Component.translatable((String)"attribute.modifier.equals.0", (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(range), attrNoIcon}).withStyle(ChatFormatting.DARK_GREEN);
            return Component.literal((String)"").append((Component)Component.literal((String)(icon + " "))).append((Component)body);
        }
        return Component.literal((String)"").append((Component)Component.translatable((String)"attribute.modifier.equals.0", (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(range), attr}).withStyle(ChatFormatting.DARK_GREEN));
    }

    private static void addAllReachModifiersFrom(LocalPlayer player, ModifierTracker tracker) {
        AttributeInstance reach = player.getAttribute(Attributes.BLOCK_INTERACTION_RANGE);
        if (reach == null) {
            return;
        }
        for (AttributeModifier m : reach.getModifiers()) {
            tracker.addModifier(m);
        }
    }

    private static void addMainHandReachFrom(ItemStack stack, ModifierTracker tracker) {
        stack.forEachModifier(EquipmentSlotGroup.MAINHAND, (attr, m) -> {
            if (attr.is(Attributes.BLOCK_INTERACTION_RANGE)) {
                tracker.addModifier((AttributeModifier)m);
            }
        });
    }

    private static void removeMainHandReachFrom(ItemStack stack, ModifierTracker tracker) {
        if (stack.isEmpty()) {
            return;
        }
        stack.forEachModifier(EquipmentSlotGroup.MAINHAND, (attr, m) -> {
            if (attr.is(Attributes.BLOCK_INTERACTION_RANGE)) {
                tracker.removeModifierById(m.id());
            }
        });
    }

    private static final class ModifierTracker {
        final double initialBaseReach;
        final List<AttributeModifier> applicableModifiers = new ArrayList<AttributeModifier>();
        double currentTrackedValue;

        ModifierTracker(double playerBaseReach) {
            this.initialBaseReach = playerBaseReach;
            this.currentTrackedValue = playerBaseReach;
        }

        void addModifier(AttributeModifier modifier) {
            if (modifier.amount() == 0.0) {
                return;
            }
            for (AttributeModifier m : this.applicableModifiers) {
                if (!m.id().equals((Object)modifier.id())) continue;
                return;
            }
            this.applicableModifiers.add(modifier);
        }

        void removeModifierById(ResourceLocation id) {
            this.applicableModifiers.removeIf(m -> m.id().equals((Object)id));
        }

        void calculateValue() {
            this.applicableModifiers.sort(Comparator.comparing(AttributeModifier::operation).thenComparing(a -> -Math.abs(a.amount())).thenComparing(AttributeModifier::id));
            double value = this.initialBaseReach;
            for (AttributeModifier m : this.applicableModifiers) {
                if (m.operation() != AttributeModifier.Operation.ADD_VALUE) continue;
                value += m.amount();
            }
            double addMultBase = 0.0;
            for (AttributeModifier m : this.applicableModifiers) {
                if (m.operation() != AttributeModifier.Operation.ADD_MULTIPLIED_BASE) continue;
                addMultBase += this.initialBaseReach * m.amount();
            }
            value += addMultBase;
            for (AttributeModifier m : this.applicableModifiers) {
                if (m.operation() != AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL) continue;
                value *= 1.0 + m.amount();
            }
            this.currentTrackedValue = value;
        }
    }
}

