/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.iconleadingtooltip.mixin;

import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.pixeldreamstudios.iconleadingtooltip.util.IconLeadingUtil;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemStack.class}, priority=500)
public abstract class ItemStackMixin {
    @Inject(method={"addModifierTooltip(Ljava/util/function/Consumer;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/core/Holder;Lnet/minecraft/world/entity/ai/attributes/AttributeModifier;)V"}, at={@At(value="HEAD")}, cancellable=true, require=0)
    private void iconleadingtooltip$iconBeforeNumber(Consumer<Component> consumer, @Nullable Player player, Holder<Attribute> attribute, AttributeModifier modifier, CallbackInfo ci) {
        double d = modifier.amount();
        boolean usesBase = false;
        if (player != null) {
            if (modifier.is(Item.BASE_ATTACK_DAMAGE_ID)) {
                d += player.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
                usesBase = true;
            } else if (modifier.is(Item.BASE_ATTACK_SPEED_ID)) {
                d += player.getAttributeBaseValue(Attributes.ATTACK_SPEED);
                usesBase = true;
            }
        }
        double shown = switch (modifier.operation()) {
            case AttributeModifier.Operation.ADD_MULTIPLIED_BASE, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL -> d * 100.0;
            default -> attribute.is(Attributes.KNOCKBACK_RESISTANCE) ? d * 10.0 : d;
        };
        MutableComponent attrName = Component.translatable((String)((Attribute)attribute.value()).getDescriptionId());
        String raw = attrName.getString();
        int[] span = IconLeadingUtil.firstIconSpan(raw);
        if (span[0] < 0) {
            return;
        }
        String icon = raw.substring(span[0], span[1]);
        String restRaw = raw.substring(0, span[0]) + raw.substring(span[1]);
        String rest = IconLeadingUtil.stripSectionCodes(restRaw).replaceFirst("^\\s+", "");
        MutableComponent attrNoIcon = Component.literal((String)rest);
        String numPlus = ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(shown);
        String numTake = ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(-shown);
        MutableComponent iconText = Component.literal((String)(icon + " "));
        if (usesBase) {
            MutableComponent body = Component.translatable((String)("attribute.modifier.equals." + modifier.operation().id()), (Object[])new Object[]{numPlus, attrNoIcon}).withStyle(ChatFormatting.DARK_GREEN);
            consumer.accept((Component)Component.empty().append((Component)iconText).append((Component)body));
            ci.cancel();
        } else if (d > 0.0) {
            MutableComponent body = Component.translatable((String)("attribute.modifier.plus." + modifier.operation().id()), (Object[])new Object[]{numPlus, attrNoIcon}).withStyle(((Attribute)attribute.value()).getStyle(true));
            consumer.accept((Component)Component.empty().append((Component)iconText).append((Component)body));
            ci.cancel();
        } else if (d < 0.0) {
            MutableComponent body = Component.translatable((String)("attribute.modifier.take." + modifier.operation().id()), (Object[])new Object[]{numTake, attrNoIcon}).withStyle(((Attribute)attribute.value()).getStyle(false));
            consumer.accept((Component)Component.empty().append((Component)iconText).append((Component)body));
            ci.cancel();
        } else {
            double baseValue;
            if (player != null && (baseValue = player.getAttributeBaseValue(attribute)) != 0.0) {
                double baseShown = switch (modifier.operation()) {
                    case AttributeModifier.Operation.ADD_MULTIPLIED_BASE, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL -> baseValue * 100.0;
                    default -> attribute.is(Attributes.KNOCKBACK_RESISTANCE) ? baseValue * 10.0 : baseValue;
                };
                String numBase = ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(baseShown);
                MutableComponent body = Component.translatable((String)("attribute.modifier.equals." + modifier.operation().id()), (Object[])new Object[]{numBase, attrNoIcon}).withStyle(ChatFormatting.DARK_GREEN);
                consumer.accept((Component)Component.empty().append((Component)iconText).append((Component)body));
                ci.cancel();
                return;
            }
            ci.cancel();
        }
    }
}

