/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.iconleadingtooltip.neoforge.client;

import dev.architectury.platform.Platform;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.pixeldreamstudios.iconleadingtooltip.client.BcAttackRangeTooltip;
import net.pixeldreamstudios.iconleadingtooltip.util.IconLeadingUtil;

@EventBusSubscriber(modid="icon_leading_tooltip", value={Dist.CLIENT})
public final class IconLeadingTooltipNeoForgeClient {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onItemTooltip(ItemTooltipEvent event) {
        LocalPlayer player;
        List tooltip = event.getToolTip();
        ItemStack stack = event.getItemStack();
        for (int i = 0; i < tooltip.size(); ++i) {
            Component line = (Component)tooltip.get(i);
            Component transformed = IconLeadingTooltipNeoForgeClient.transformLine(line);
            if (transformed == line) continue;
            tooltip.set(i, transformed);
        }
        if (Platform.isModLoaded((String)"bettercombat") && (player = Minecraft.getInstance().player) != null) {
            BcAttackRangeTooltip.append(stack, player, tooltip);
        }
    }

    private static Component transformLine(Component original) {
        String text = original.getString();
        int[] span = IconLeadingUtil.firstIconSpan(text);
        if (span[0] < 0) {
            return original;
        }
        if (!IconLeadingTooltipNeoForgeClient.isAttributeLine(original)) {
            return original;
        }
        if (span[0] == 0 || span[0] <= 2 && text.substring(0, span[0]).trim().isEmpty()) {
            return original;
        }
        String icon = text.substring(span[0], span[1]);
        Object withoutIcon = text.substring(0, span[0]) + text.substring(span[1]);
        withoutIcon = IconLeadingUtil.stripSectionCodes((String)withoutIcon);
        withoutIcon = ((String)withoutIcon).replaceAll("\\s+", " ").trim();
        MutableComponent iconText = Component.literal((String)(icon + " "));
        MutableComponent textPart = Component.literal((String)withoutIcon).setStyle(original.getStyle());
        return Component.empty().append((Component)iconText).append((Component)textPart);
    }

    private static boolean isAttributeLine(Component component) {
        TranslatableContents tr;
        String key;
        ComponentContents content = component.getContents();
        if (content instanceof TranslatableContents && ((key = (tr = (TranslatableContents)content).getKey()).startsWith("attribute.modifier.plus.") || key.startsWith("attribute.modifier.take.") || key.startsWith("attribute.modifier.equals.") || key.equals("neoforge.modifier.plus") || key.equals("neoforge.modifier.take"))) {
            return true;
        }
        for (Component sibling : component.getSiblings()) {
            TranslatableContents tr2;
            String key2;
            ComponentContents siblingContent = sibling.getContents();
            if (!(siblingContent instanceof TranslatableContents) || !(key2 = (tr2 = (TranslatableContents)siblingContent).getKey()).startsWith("attribute.modifier.plus.") && !key2.startsWith("attribute.modifier.take.") && !key2.startsWith("attribute.modifier.equals.") && !key2.equals("neoforge.modifier.plus") && !key2.equals("neoforge.modifier.take")) continue;
            return true;
        }
        return false;
    }
}

