/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.iconleadingtooltip.util;

public final class IconLeadingUtil {
    private IconLeadingUtil() {
    }

    public static boolean isIconGlyph(int cp) {
        return cp >= 57344 && cp <= 63743 || cp >= 63744 && cp <= 64255 || cp >= 118016 && cp <= 118271 || cp >= 129792 && cp <= 130047 || cp >= 983040 && cp <= 1048573 || cp >= 0x100000 && cp <= 1114109;
    }

    public static int[] firstIconSpan(String s) {
        int formattingStart = -1;
        int i = 0;
        while (i < s.length()) {
            int cp = s.codePointAt(i);
            int len = Character.charCount(cp);
            if (cp == 167) {
                if (formattingStart == -1) {
                    formattingStart = i;
                }
                if (i + 1 < s.length()) {
                    int nextCp = s.codePointAt(i + 1);
                    if (nextCp == 120 || nextCp == 88) {
                        i += 2;
                        for (int k = 0; k < 6 && i < s.length() && s.charAt(i) == '\u00a7' && i + 1 < s.length(); i += 2, ++k) {
                        }
                        continue;
                    }
                    i += 2;
                    continue;
                }
                ++i;
                continue;
            }
            if (IconLeadingUtil.isIconGlyph(cp)) {
                int actualStart = formattingStart >= 0 ? formattingStart : i;
                return new int[]{actualStart, i + len};
            }
            formattingStart = -1;
            i += len;
        }
        return new int[]{-1, -1};
    }

    public static String stripSectionCodes(String s) {
        StringBuilder out = new StringBuilder(s.length());
        int i = 0;
        while (i < s.length()) {
            int cp = s.codePointAt(i);
            int len = Character.charCount(cp);
            if (cp == 167) {
                if (i + 1 < s.length()) {
                    int nextCp = s.codePointAt(i + 1);
                    if (nextCp == 120 || nextCp == 88) {
                        int checkCp;
                        i += 2;
                        for (int k = 0; k < 6 && i < s.length() && (checkCp = s.codePointAt(i)) == 167 && i + 1 < s.length(); i += 2, ++k) {
                        }
                        continue;
                    }
                    i += 2;
                    continue;
                }
                ++i;
                continue;
            }
            out.appendCodePoint(cp);
            i += len;
        }
        return out.toString();
    }
}

