/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.iconleadingtooltip.mixin.trinkets;

import dev.emi.trinkets.api.TrinketsApi;
import dev.emi.trinkets.api.TrinketsAttributeModifiersComponent;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import net.pixeldreamstudios.iconleadingtooltip.util.IconLeadingUtil;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1799.class})
public abstract class TrinketsTooltipRedirectMixin {
    @Inject(method={"getTooltip"}, at={@At(value="RETURN")}, cancellable=true)
    private void ilt$moveIconsForTrinkets(class_1792.class_9635 context, @Nullable class_1657 player, class_1836 type, CallbackInfoReturnable<List<class_2561>> cir) {
        if (!FabricLoader.getInstance().isModLoaded("trinkets")) {
            return;
        }
        if (!this.ilt$isTrinketStack()) {
            return;
        }
        List in = (List)cir.getReturnValue();
        ArrayList<class_2561> out = new ArrayList<class_2561>(in.size());
        for (class_2561 t : in) {
            out.add(this.ilt$transformIfAttributeLine(t));
        }
        cir.setReturnValue(out);
    }

    @Unique
    private boolean ilt$isTrinketStack() {
        class_1799 self = (class_1799)this;
        boolean viaApi = TrinketsApi.getTrinket((class_1792)self.method_7909()) != null;
        TrinketsAttributeModifiersComponent comp = (TrinketsAttributeModifiersComponent)self.method_57824(TrinketsAttributeModifiersComponent.TYPE);
        boolean viaComponent = comp != null && comp.showInTooltip();
        return viaApi || viaComponent;
    }

    @Unique
    private class_2561 ilt$transformIfAttributeLine(class_2561 text) {
        Object object;
        class_7417 content = text.method_10851();
        if (!(content instanceof class_2588)) {
            return text;
        }
        class_2588 tr = (class_2588)content;
        String key = tr.method_11022();
        if (!(key.startsWith("attribute.modifier.plus.") || key.startsWith("attribute.modifier.take.") || key.startsWith("attribute.modifier.equals."))) {
            return text;
        }
        Object[] args = (Object[])tr.method_11023().clone();
        if (args.length < 2 || !((object = args[1]) instanceof class_2561)) {
            return text;
        }
        class_2561 attrText = (class_2561)object;
        String attrRaw = attrText.getString();
        if (!attrRaw.isEmpty() && IconLeadingUtil.isIconGlyph(attrRaw.codePointAt(0))) {
            return text;
        }
        int[] span = TrinketsTooltipRedirectMixin.ilt$findIconAnywhere(attrRaw);
        if (span == null) {
            return text;
        }
        String icon = attrRaw.substring(span[0], span[1]);
        String cleanedAttr = IconLeadingUtil.stripSectionCodes(attrRaw.substring(0, span[0]) + attrRaw.substring(span[1])).trim();
        args[1] = class_2561.method_43470((String)cleanedAttr);
        class_5250 rebuilt = class_2561.method_43469((String)key, (Object[])args).method_10862(text.method_10866());
        class_5250 iconText = class_2561.method_43470((String)(icon + " ")).method_27694(s -> s.method_36139(0xFFFFFF).method_10982(Boolean.valueOf(false)).method_10978(Boolean.valueOf(false)).method_30938(Boolean.valueOf(false)).method_36140(Boolean.valueOf(false)).method_36141(Boolean.valueOf(false)));
        return class_2561.method_43473().method_10852((class_2561)iconText).method_10852((class_2561)rebuilt);
    }

    @Unique
    private static int[] ilt$findIconAnywhere(String s) {
        int len;
        for (int i = 0; i < s.length(); i += len) {
            int cp = s.codePointAt(i);
            len = Character.charCount(cp);
            if (!IconLeadingUtil.isIconGlyph(cp)) continue;
            return new int[]{i, i + len};
        }
        return null;
    }
}

