/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.iconleadingtooltip.client;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.bettercombat.api.WeaponAttributes;
import net.bettercombat.logic.EntityAttributeHelper;
import net.bettercombat.logic.WeaponRegistry;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import net.minecraft.class_746;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.pixeldreamstudios.iconleadingtooltip.util.IconLeadingUtil;

@Environment(value=EnvType.CLIENT)
public final class BcAttackRangeTooltip {
    private BcAttackRangeTooltip() {
    }

    public static void append(class_1799 stack, class_746 player, List<class_2561> lines) {
        double totalRange;
        if (!FabricLoader.getInstance().isModLoaded("bettercombat")) {
            return;
        }
        if (FabricLoader.getInstance().isModLoaded("dynamictooltips")) {
            return;
        }
        WeaponAttributes attributes = WeaponRegistry.getAttributes((class_1799)stack);
        if (attributes == null || attributes.attacks() == null || attributes.attacks().length == 0) {
            return;
        }
        class_1324 reachAttr = player.method_5996(class_5134.field_47759);
        if (reachAttr == null) {
            return;
        }
        ModifierTracker tracker = new ModifierTracker(reachAttr.method_6201());
        BcAttackRangeTooltip.addAllReachModifiersFrom(player, tracker);
        class_1799 equipped = player.method_6047();
        boolean viewingEquipped = class_1799.method_7973((class_1799)stack, (class_1799)equipped);
        if (!viewingEquipped) {
            BcAttackRangeTooltip.removeMainHandReachFrom(equipped, tracker);
            BcAttackRangeTooltip.addMainHandReachFrom(stack, tracker);
        }
        tracker.calculateValue();
        if (!EntityAttributeHelper.itemHasRangeAttribute((class_1799)stack)) {
            tracker.currentTrackedValue += attributes.rangeBonus();
        }
        if ((totalRange = tracker.currentTrackedValue) <= 0.0) {
            return;
        }
        int insertAt = BcAttackRangeTooltip.findInsertIndex(lines);
        class_5250 rangeLine = BcAttackRangeTooltip.buildRangeLine(totalRange);
        lines.add(Math.min(insertAt + 1, lines.size()), (class_2561)rangeLine);
    }

    private static int findInsertIndex(List<class_2561> lines) {
        int lastAttributeLine = -1;
        Integer lastGreenAttributeIndex = null;
        for (int i = 0; i < lines.size(); ++i) {
            class_2561 line = lines.get(i);
            class_7417 content = line.method_10851();
            if (content instanceof class_2588) {
                class_2588 tr = (class_2588)content;
                String key = tr.method_11022();
                if (!key.startsWith("attribute.modifier")) continue;
                lastAttributeLine = i;
                continue;
            }
            for (class_2561 part : line.method_10855()) {
                class_7417 pc = part.method_10851();
                if (!(pc instanceof class_2588)) continue;
                class_2588 ptr = (class_2588)pc;
                String pKey = ptr.method_11022();
                if (pKey.contains("attribute.modifier.equals.0")) {
                    lastGreenAttributeIndex = i;
                }
                if (!pKey.startsWith("attribute.modifier")) continue;
                lastAttributeLine = i;
            }
        }
        if (lastGreenAttributeIndex != null) {
            return lastGreenAttributeIndex;
        }
        if (lastAttributeLine >= 0) {
            return lastAttributeLine;
        }
        return lines.size() - 1;
    }

    private static class_5250 buildRangeLine(double range) {
        class_5250 attr = class_2561.method_43471((String)"attribute.name.generic.attack_range");
        String raw = attr.getString();
        int[] span = IconLeadingUtil.firstIconSpan(raw);
        if (span[0] >= 0) {
            String icon = raw.substring(span[0], span[1]);
            String restRaw = raw.substring(0, span[0]) + raw.substring(span[1]);
            String rest = IconLeadingUtil.stripSectionCodes(restRaw).replaceFirst("^\\s+", "");
            class_5250 attrNoIcon = class_2561.method_43470((String)rest);
            class_5250 body = class_2561.method_43469((String)"attribute.modifier.equals.0", (Object[])new Object[]{class_9285.field_49329.format(range), attrNoIcon}).method_27692(class_124.field_1077);
            return class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)(icon + " "))).method_10852((class_2561)body);
        }
        return class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43469((String)"attribute.modifier.equals.0", (Object[])new Object[]{class_9285.field_49329.format(range), attr}).method_27692(class_124.field_1077));
    }

    private static void addAllReachModifiersFrom(class_746 player, ModifierTracker tracker) {
        class_1324 reach = player.method_5996(class_5134.field_47759);
        if (reach == null) {
            return;
        }
        for (class_1322 m : reach.method_6195()) {
            tracker.addModifier(m);
        }
    }

    private static void addMainHandReachFrom(class_1799 stack, ModifierTracker tracker) {
        stack.method_60617(class_9274.field_49217, (attr, m) -> {
            if (attr.comp_349() == class_5134.field_47759.comp_349()) {
                tracker.addModifier((class_1322)m);
            }
        });
    }

    private static void removeMainHandReachFrom(class_1799 stack, ModifierTracker tracker) {
        if (stack.method_7960()) {
            return;
        }
        stack.method_60617(class_9274.field_49217, (attr, m) -> {
            if (attr.comp_349() == class_5134.field_47759.comp_349()) {
                tracker.removeModifierById(m.comp_2447());
            }
        });
    }

    private static final class ModifierTracker {
        final double initialBaseReach;
        final List<class_1322> applicableModifiers = new ArrayList<class_1322>();
        double currentTrackedValue;

        ModifierTracker(double playerBaseReach) {
            this.initialBaseReach = playerBaseReach;
            this.currentTrackedValue = playerBaseReach;
        }

        void addModifier(class_1322 modifier) {
            if (modifier.comp_2449() == 0.0) {
                return;
            }
            for (class_1322 m : this.applicableModifiers) {
                if (!m.comp_2447().equals((Object)modifier.comp_2447())) continue;
                return;
            }
            this.applicableModifiers.add(modifier);
        }

        void removeModifierById(class_2960 id) {
            this.applicableModifiers.removeIf(m -> m.comp_2447().equals((Object)id));
        }

        void calculateValue() {
            this.applicableModifiers.sort(Comparator.comparing(class_1322::comp_2450).thenComparing(a -> -Math.abs(a.comp_2449())).thenComparing(class_1322::comp_2447));
            double value = this.initialBaseReach;
            for (class_1322 m : this.applicableModifiers) {
                if (m.comp_2450() != class_1322.class_1323.field_6328) continue;
                value += m.comp_2449();
            }
            double addMultBase = 0.0;
            for (class_1322 m : this.applicableModifiers) {
                if (m.comp_2450() != class_1322.class_1323.field_6330) continue;
                addMultBase += this.initialBaseReach * m.comp_2449();
            }
            value += addMultBase;
            for (class_1322 m : this.applicableModifiers) {
                if (m.comp_2450() != class_1322.class_1323.field_6331) continue;
                value *= 1.0 + m.comp_2449();
            }
            this.currentTrackedValue = value;
        }
    }
}

