/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.features.foraging.treewaypoints;

import com.google.gson.annotations.Expose;
import com.skyblock21.features.foraging.treewaypoints.TreeState;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;

public class Tree {
    public class_2338 basePos;
    @Expose
    public final int x;
    @Expose
    public final int y;
    @Expose
    public final int z;
    @Expose
    public final int maxY;
    @Expose
    public final boolean isBigTree;
    public final boolean isMangrove;
    public UUID waypointId;
    public TreeState currentState = TreeState.NOT_PRESENT;
    public long stateStartTime = 0L;
    public Set<class_2338> knownLogPositions = new HashSet<class_2338>();
    public final long NOT_PRESENT_DURATION = 30000L;
    public final long REGENERATING_DURATION_SMALL = 13000L;
    public final long REGENERATING_DURATION_BIG = 25000L;

    public Tree(class_2338 basePos, int maxY, boolean isBigTree, boolean isMangrove) {
        this.basePos = basePos;
        this.x = basePos.method_10263();
        this.y = basePos.method_10264();
        this.z = basePos.method_10260();
        this.maxY = maxY;
        this.isBigTree = isBigTree;
        this.isMangrove = isMangrove;
        this.waypointId = UUID.randomUUID();
        this.stateStartTime = System.currentTimeMillis();
    }

    public long getRegeneratingDuration() {
        return this.isBigTree ? 25000L : 13000L;
    }

    public long getTimeInCurrentState() {
        return System.currentTimeMillis() - this.stateStartTime;
    }

    public void setState(TreeState newState) {
        if (this.currentState != newState) {
            this.currentState = newState;
            this.stateStartTime = System.currentTimeMillis();
        }
    }

    public TreeState getState() {
        return this.currentState;
    }

    public boolean isBig() {
        return this.isBigTree;
    }

    public boolean isMangrove() {
        return this.isMangrove;
    }

    public class_2338 getCenterPos() {
        return this.knownLogPositions.isEmpty() ? this.basePos : this.findClosestLogToBase(this.knownLogPositions, this.basePos);
    }

    public int getLogCount() {
        return this.knownLogPositions.size();
    }

    public class_2248 getLogBlock() {
        return this.isMangrove ? class_2246.field_37549 : class_2246.field_10558;
    }

    public String getTreeTypeName() {
        String colorChar;
        StringBuilder typeName = new StringBuilder();
        String string = colorChar = this.currentState == TreeState.REGENERATING ? "\u00a76" : "\u00a7e";
        if (this.isBigTree) {
            typeName.append("\u00a7c\u00a7lL ");
        } else {
            typeName.append("\u00a7a\u00a7lS ");
        }
        if (this.isMangrove) {
            typeName.append(colorChar + "Mangrove");
        } else {
            typeName.append(colorChar + "Fig");
        }
        return typeName.toString();
    }

    public long getTimeInState() {
        return this.getTimeInCurrentState();
    }

    private class_2338 findClosestLogToBase(Set<class_2338> logPositions, class_2338 basePos) {
        return logPositions.stream().min((pos1, pos2) -> {
            double dist1 = basePos.method_10262((class_2382)pos1);
            double dist2 = basePos.method_10262((class_2382)pos2);
            return Double.compare(dist1, dist2);
        }).orElse(basePos);
    }
}

