/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.features.foraging.treewaypoints;

import com.skyblock21.Skyblock21;
import com.skyblock21.config.Skyblock21ConfigManager;
import com.skyblock21.events.BlockEvents;
import com.skyblock21.events.ChunkEvents;
import com.skyblock21.events.ParticleEvents;
import com.skyblock21.events.SkyblockEvents;
import com.skyblock21.features.foraging.treewaypoints.Tree;
import com.skyblock21.features.foraging.treewaypoints.TreeState;
import com.skyblock21.features.waypoints.Waypoint;
import com.skyblock21.features.waypoints.WaypointManager;
import com.skyblock21.util.Location;
import com.skyblock21.util.Utils;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2675;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_638;

public class TreeWaypoints {
    public static final Map<UUID, Tree> trees = new HashMap<UUID, Tree>();
    private static final int SCAN_RADIUS = 1;
    private static int ticks = 0;
    private static Tree nearestTree = null;

    public static void init() {
        ClientTickEvents.END_CLIENT_TICK.register(TreeWaypoints::tick);
        SkyblockEvents.LOCATION_CHANGE.register(TreeWaypoints::onLocationChange);
        ParticleEvents.SPAWN.register(TreeWaypoints::onParticle);
        ChunkEvents.CHUNK_REMOVED.register(TreeWaypoints::onChunkRemoved);
        ChunkEvents.CHUNK_SPAWNED.register(TreeWaypoints::onChunkSpawned);
        BlockEvents.BLOCK_ADDED.register(TreeWaypoints::onBlockAdded);
    }

    private static void onBlockAdded(class_1937 world, class_2338 blockPos, class_2680 blockState) {
        if (!Utils.isOnSkyblock()) {
            return;
        }
        if (!Utils.isInGalatea()) {
            return;
        }
        if (!Skyblock21ConfigManager.get().foraging.treeWaypoints) {
            return;
        }
        class_2248 block = blockState.method_26204();
        if (block != class_2246.field_10558 && block != class_2246.field_37549) {
            return;
        }
        for (Tree tree : trees.values()) {
            if (tree.getState() == TreeState.REGENERATING || tree.getLogBlock() != block || !tree.basePos.equals((Object)blockPos) && !tree.knownLogPositions.contains(blockPos)) continue;
            tree.setState(TreeState.REGENERATING);
            tree.stateStartTime -= (long)((double)tree.getRegeneratingDuration() * 0.1);
            return;
        }
    }

    private static void onChunkSpawned(class_638 clientWorld, class_2818 worldChunk) {
        if (!Utils.isOnSkyblock()) {
            return;
        }
        if (!Utils.isInGalatea()) {
            return;
        }
        if (!Skyblock21ConfigManager.get().foraging.treeWaypoints) {
            return;
        }
        class_1923 chunkPos = worldChunk.method_12004();
        for (Tree tree : trees.values()) {
            int chunkX = tree.basePos.method_10263() >> 4;
            int chunkZ = tree.basePos.method_10260() >> 4;
            if (chunkX != chunkPos.field_9181 || chunkZ != chunkPos.field_9180) continue;
            TreeWaypoints.updateTreeStateMachine(tree);
        }
    }

    private static void onChunkRemoved(class_638 clientWorld, class_2818 worldChunk) {
        if (!Utils.isOnSkyblock()) {
            return;
        }
        if (!Utils.isInGalatea()) {
            return;
        }
        if (!Skyblock21ConfigManager.get().foraging.treeWaypoints) {
            return;
        }
        class_1923 chunkPos = worldChunk.method_12004();
        for (Tree tree : trees.values()) {
            int chunkX = tree.basePos.method_10263() >> 4;
            int chunkZ = tree.basePos.method_10260() >> 4;
            if (chunkX != chunkPos.field_9181 || chunkZ != chunkPos.field_9180) continue;
            tree.setState(TreeState.NONE);
        }
    }

    private static void onParticle(class_2675 particleS2CPacket) {
        if (!Utils.isOnSkyblock()) {
            return;
        }
        if (!Utils.isInGalatea()) {
            return;
        }
        if (!Skyblock21ConfigManager.get().foraging.treeWaypoints) {
            return;
        }
        class_2396 particleType = particleS2CPacket.method_11551().method_10295();
        if (particleType != class_2398.field_47494) {
            return;
        }
        double particleX = particleS2CPacket.method_11544();
        double particleY = particleS2CPacket.method_11547();
        double particleZ = particleS2CPacket.method_11546();
        Tree closestTree = null;
        double closestDistance = Double.MAX_VALUE;
        for (Tree tree : trees.values()) {
            double distance;
            if (!TreeWaypoints.isTreeAllowed(tree) || !((distance = new class_243(particleX, particleY, particleZ).method_1028((double)tree.basePos.method_10263(), (double)tree.basePos.method_10264(), (double)tree.basePos.method_10260())) < closestDistance)) continue;
            closestDistance = distance;
            closestTree = tree;
        }
        if (closestTree != null && closestDistance <= 20.0) {
            closestTree.setState(TreeState.NOT_PRESENT);
        }
    }

    private static void onLocationChange(Location location) {
        if (location == Location.GALATEA) {
            TreeWaypoints.performInitialWorldScan();
        } else {
            trees.clear();
            WaypointManager.removeAllWaypoints();
        }
    }

    public static void loadTrees() {
        try (BufferedReader r = class_310.method_1551().method_1478().openAsReader(class_2960.method_60655((String)"skyblock21", (String)"tree_locations.json"));){
            Tree[] loadedTrees;
            for (Tree tree : loadedTrees = (Tree[])Skyblock21.GSON.fromJson((Reader)r, Tree[].class)) {
                tree.basePos = new class_2338(tree.x, tree.y, tree.z);
                tree.currentState = TreeState.NONE;
                tree.knownLogPositions = new HashSet<class_2338>();
                tree.stateStartTime = System.currentTimeMillis();
                tree.waypointId = UUID.randomUUID();
                trees.put(tree.waypointId, tree);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean isTreeAllowed(Tree tree) {
        boolean onlySmall = Skyblock21ConfigManager.get().foraging.onlyShowSmallTrees;
        boolean mangrove = Skyblock21ConfigManager.get().foraging.showMangroveTreeWaypoints;
        boolean fig = Skyblock21ConfigManager.get().foraging.showFigTreeWaypoints;
        if (onlySmall && tree.isBigTree) {
            return false;
        }
        if (tree.isMangrove) {
            return mangrove;
        }
        return fig;
    }

    public static void tick(class_310 client) {
        if (client.field_1687 == null || client.field_1724 == null) {
            return;
        }
        if (++ticks % 2 != 0) {
            return;
        }
        if (!Utils.isOnSkyblock()) {
            return;
        }
        if (!Utils.isInGalatea()) {
            return;
        }
        if (!Skyblock21ConfigManager.get().foraging.treeWaypoints) {
            return;
        }
        for (Tree tree : trees.values()) {
            TreeWaypoints.updateTreeStateMachine(tree);
        }
        class_2338 playerPos = client.field_1724.method_24515();
        nearestTree = TreeWaypoints.findSecondNearestSmallTree(playerPos);
        TreeWaypoints.updateAllWaypoints();
        if (ticks == 20) {
            ticks = 0;
        }
    }

    private static void updateTreeStateMachine(Tree tree) {
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null) {
            return;
        }
        Set<class_2338> logPositions = TreeWaypoints.scanAreaForLogs((class_1937)client.field_1687, tree);
        HashSet connectedLogs = logPositions.isEmpty() ? new HashSet() : TreeWaypoints.scanNeighborsForTree((class_1937)client.field_1687, logPositions, tree);
        boolean treePhysicallyPresent = !connectedLogs.isEmpty();
        long timeInState = tree.getTimeInCurrentState();
        if ((tree.currentState == TreeState.PRESENT || tree.currentState == TreeState.NONE) && ticks % 20 != 0) {
            return;
        }
        switch (tree.currentState) {
            case NONE: {
                if (treePhysicallyPresent) {
                    tree.setState(TreeState.PRESENT);
                    tree.knownLogPositions = new HashSet<class_2338>(connectedLogs);
                }
            }
            case NOT_PRESENT: {
                if (timeInState < tree.NOT_PRESENT_DURATION) break;
                tree.setState(TreeState.REGENERATING);
                break;
            }
            case REGENERATING: {
                if (timeInState < tree.getRegeneratingDuration()) break;
                tree.setState(TreeState.PRESENT);
                break;
            }
            case PRESENT: {
                if (!treePhysicallyPresent) {
                    tree.setState(TreeState.NOT_PRESENT);
                    break;
                }
                tree.knownLogPositions = new HashSet<class_2338>(connectedLogs);
            }
        }
    }

    private static Set<class_2338> scanAreaForLogs(class_1937 world, Tree tree) {
        HashSet<class_2338> logPositions = new HashSet<class_2338>();
        int baseX = tree.basePos.method_10263();
        int baseZ = tree.basePos.method_10260();
        for (int x = baseX - 1; x <= baseX + 1; ++x) {
            for (int z = baseZ - 1; z <= baseZ + 1; ++z) {
                for (int y = tree.y; y <= tree.maxY; ++y) {
                    class_2338 pos = new class_2338(x, y, z);
                    class_2248 block = world.method_8320(pos).method_26204();
                    if (block != tree.getLogBlock()) continue;
                    logPositions.add(pos);
                }
            }
        }
        return logPositions;
    }

    private static Set<class_2338> scanNeighborsForTree(class_1937 world, Set<class_2338> initialLogs, Tree tree) {
        HashSet<class_2338> connectedLogs = new HashSet<class_2338>();
        HashSet<class_2338> visited = new HashSet<class_2338>();
        LinkedList<class_2338> queue = new LinkedList<class_2338>();
        if (!initialLogs.isEmpty()) {
            class_2338 start = initialLogs.iterator().next();
            queue.add(start);
            visited.add(start);
        }
        while (!queue.isEmpty()) {
            class_2338 current = (class_2338)queue.poll();
            connectedLogs.add(current);
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        class_2248 block;
                        class_2338 neighbor;
                        if (dx == 0 && dy == 0 && dz == 0 || visited.contains(neighbor = current.method_10069(dx, dy, dz)) || (block = world.method_8320(neighbor).method_26204()) != tree.getLogBlock()) continue;
                        visited.add(neighbor);
                        queue.add(neighbor);
                    }
                }
            }
        }
        return connectedLogs.size() >= 2 ? connectedLogs : new HashSet<class_2338>();
    }

    private static void updateAllWaypoints() {
        for (Tree tree : trees.values()) {
            TreeWaypoints.updateWaypointForTree(tree);
        }
    }

    private static void updateWaypointForTree(Tree tree) {
        Waypoint waypoint = WaypointManager.getWaypoint(tree.waypointId);
        String name = TreeWaypoints.getWaypointName(tree);
        int color = TreeWaypoints.getWaypointColor(tree);
        boolean visible = TreeWaypoints.shouldWaypointBeVisible(tree);
        boolean onlyNearest = Skyblock21ConfigManager.get().foraging.onlyNearestTree;
        if (onlyNearest && !tree.equals(nearestTree)) {
            visible = false;
        }
        if (waypoint == null && visible) {
            waypoint = WaypointManager.addWaypoint(tree.waypointId, name, tree.getCenterPos(), color);
            waypoint.setBeaconBeam(!Skyblock21ConfigManager.get().foraging.noBeaconBeams);
        } else if (waypoint != null) {
            waypoint.setVisible(visible);
            waypoint.setBeaconBeam(!Skyblock21ConfigManager.get().foraging.noBeaconBeams);
            if (visible) {
                waypoint.setPosition(tree.basePos);
                waypoint.setName(name);
                waypoint.setColor(color);
                waypoint.setHideWhenClose(tree.currentState == TreeState.PRESENT);
            }
        }
    }

    private static String getWaypointName(Tree tree) {
        class_2338 playerPos;
        Object treeName = tree.getTreeTypeName();
        if (!tree.isBig() && (playerPos = class_310.method_1551().field_1724.method_24515()) != null && nearestTree != null && TreeWaypoints.nearestTree.waypointId.equals(tree.waypointId)) {
            treeName = (String)treeName + " \u00a7a(nearest)";
        }
        switch (tree.getState()) {
            case NOT_PRESENT: {
                return (String)treeName + " Broken";
            }
            case REGENERATING: {
                long totalDuration = tree.isBig() ? 24000L : 12000L;
                long regenSecondsLeft = (totalDuration - tree.getTimeInState()) / 1000L;
                return (String)treeName + (String)((long)Skyblock21ConfigManager.get().foraging.timeBeforeReady >= regenSecondsLeft ? " \u00a77(" + Math.max(0L, regenSecondsLeft) + "s)" : "");
            }
            case PRESENT: {
                return treeName;
            }
        }
        return "Unknown Tree";
    }

    private static int getWaypointColor(Tree tree) {
        switch (tree.getState()) {
            case REGENERATING: {
                return 0xFFFF00;
            }
            case PRESENT: {
                if (tree.isMangrove()) {
                    return tree.isBig() ? 9127187 : 13789470;
                }
                return tree.isBig() ? 25600 : 3329330;
            }
        }
        return 0xFFFFFF;
    }

    private static boolean shouldWaypointBeVisible(Tree tree) {
        class_2338 playerPos = class_310.method_1551().field_1724.method_24515();
        if (playerPos == null) {
            return false;
        }
        int distance = (int)playerPos.method_40081((double)tree.basePos.method_10263(), (double)tree.basePos.method_10264(), (double)tree.basePos.method_10260());
        int maxDistance = Skyblock21ConfigManager.get().foraging.maxDistance;
        return tree.currentState != TreeState.NOT_PRESENT && tree.currentState != TreeState.NONE && TreeWaypoints.isTreeAllowed(tree) && (maxDistance == 0 || distance <= maxDistance * maxDistance);
    }

    public static void performInitialWorldScan() {
        if (trees.isEmpty()) {
            TreeWaypoints.loadTrees();
            return;
        }
        for (Tree tree : trees.values()) {
            HashSet connectedLogs;
            class_310 client = class_310.method_1551();
            if (client.field_1687 == null) continue;
            Set<class_2338> logPositions = TreeWaypoints.scanAreaForLogs((class_1937)client.field_1687, tree);
            Set<Object> set = connectedLogs = logPositions.isEmpty() ? new HashSet() : TreeWaypoints.scanNeighborsForTree((class_1937)client.field_1687, logPositions, tree);
            if (connectedLogs.isEmpty()) {
                tree.setState(TreeState.NOT_PRESENT);
                continue;
            }
            tree.setState(TreeState.PRESENT);
            tree.knownLogPositions = new HashSet<class_2338>(connectedLogs);
        }
    }

    private static Tree findSecondNearestSmallTree(class_2338 playerPos) {
        ArrayList<Tree> sortedTrees = new ArrayList<Tree>();
        for (Tree tree : trees.values()) {
            if (tree.isBig() || !TreeWaypoints.isTreeAllowed(tree) || !TreeWaypoints.shouldWaypointBeVisible(tree) || tree.getState() == TreeState.REGENERATING && tree.getTimeInCurrentState() <= tree.getRegeneratingDuration() - 2000L) continue;
            sortedTrees.add(tree);
        }
        sortedTrees.sort((t1, t2) -> {
            double dist1 = playerPos.method_10262((class_2382)t1.basePos);
            double dist2 = playerPos.method_10262((class_2382)t2.basePos);
            return Double.compare(dist1, dist2);
        });
        return sortedTrees.size() >= 2 ? (Tree)sortedTrees.get(1) : null;
    }
}

