/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.features.waypoints;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.skyblock21.features.waypoints.Waypoint;
import com.skyblock21.features.waypoints.WaypointManager;
import java.awt.Color;
import java.util.List;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_10799;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_9799;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class WaypointRenderer {
    private static final class_310 client = class_310.method_1551();
    private static final double MAX_RENDER_DISTANCE = 1000.0;
    private static final float BEACON_HEIGHT = 256.0f;
    private static final class_9799 ALLOCATOR = new class_9799(1536);
    public static final class_1921.class_4687 FILLED_BOX = class_1921.method_24049((String)"filled_box", (int)1536, (boolean)false, (boolean)false, (RenderPipeline)class_10799.field_56837, (class_1921.class_4688)class_1921.class_4688.method_23598().method_23617(false));

    public static void renderWaypoints(WorldRenderContext context, class_4184 camera, float tickDelta) {
        if (WaypointRenderer.client.field_1687 == null || WaypointRenderer.client.field_1724 == null) {
            return;
        }
        List<Waypoint> visibleWaypoints = WaypointManager.getVisibleWaypoints();
        if (visibleWaypoints.isEmpty()) {
            return;
        }
        class_243 cameraPos = camera.method_19326();
        class_4587 matrices = context.matrixStack();
        if (matrices == null) {
            return;
        }
        for (Waypoint waypoint : visibleWaypoints) {
            class_243 waypointPos = class_243.method_24954((class_2382)waypoint.getPosition());
            double distance = Math.sqrt(WaypointRenderer.client.field_1724.method_5707(waypointPos));
            if (waypoint.shouldHideWhenClose() && distance < 8.0 || distance > 1000.0) continue;
            if (waypoint.isCircleOnFloor()) {
                WaypointRenderer.renderCircleOnBlock(context, matrices, waypoint.getPosition(), cameraPos, waypoint.getColor(), 0.7f, 256);
            }
            if (waypoint.isBeaconBeam()) {
                WaypointRenderer.renderWaypointBeacon(context, matrices, waypoint, camera, cameraPos, distance);
            }
            if (waypoint.getName().isEmpty()) continue;
            WaypointRenderer.renderWaypointText(context, waypoint, distance, tickDelta);
        }
    }

    private static void renderCircleOnBlock(WorldRenderContext context, class_4587 matrices, class_2338 blockPos, class_243 cameraPos, int color, float radius, int segments) {
        float alpha = 0.7f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        matrices.method_22903();
        matrices.method_22904((double)blockPos.method_10263() + 0.5 - cameraPos.field_1352, (double)blockPos.method_10264() + 1.01 - cameraPos.field_1351, (double)blockPos.method_10260() + 0.5 - cameraPos.field_1350);
        Matrix4f matrix = matrices.method_23760().method_23761();
        class_4597.class_4598 consumers = (class_4597.class_4598)context.consumers();
        class_4588 vertexConsumer = consumers.getBuffer((class_1921)FILLED_BOX);
        float angleStep = (float)(Math.PI * 2 / (double)segments);
        float centerX = 0.0f;
        float centerZ = 0.0f;
        for (int i = 0; i <= segments; ++i) {
            float angle1 = (float)i * angleStep;
            float angle2 = (float)(i + 1) * angleStep;
            float x1 = centerX + radius * (float)Math.cos(angle1);
            float z1 = centerZ + radius * (float)Math.sin(angle1);
            float x2 = centerX + radius * (float)Math.cos(angle2);
            float z2 = centerZ + radius * (float)Math.sin(angle2);
            vertexConsumer.method_22918(matrix, centerX, 0.0f, centerZ).method_22915(r, g, b, alpha).method_22913(0.5f, 0.5f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_22914(0.0f, 1.0f, 0.0f);
            vertexConsumer.method_22918(matrix, x1, 0.0f, z1).method_22915(r, g, b, alpha).method_22913(0.5f + x1 / radius * 0.5f, 0.5f + z1 / radius * 0.5f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_22914(0.0f, 1.0f, 0.0f);
            vertexConsumer.method_22918(matrix, x2, 0.0f, z2).method_22915(r, g, b, alpha).method_22913(0.5f + x2 / radius * 0.5f, 0.5f + z2 / radius * 0.5f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_22914(0.0f, 1.0f, 0.0f);
            vertexConsumer.method_22918(matrix, centerX, 0.0f, centerZ).method_22915(r, g, b, alpha).method_22913(0.5f, 0.5f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_22914(0.0f, 1.0f, 0.0f);
        }
        consumers.method_22993();
        matrices.method_22909();
    }

    private static void renderWaypointBeacon(WorldRenderContext context, class_4587 matrices, Waypoint waypoint, class_4184 camera, class_243 cameraPos, double distance) {
        class_2338 pos = waypoint.getPosition();
        class_243 waypointPos = class_243.method_24954((class_2382)pos).method_1031(0.5, 0.0, 0.5);
        matrices.method_22903();
        matrices.method_22904(waypointPos.field_1352 - cameraPos.field_1352, waypointPos.field_1351 - cameraPos.field_1351, waypointPos.field_1350 - cameraPos.field_1350);
        WaypointRenderer.renderBeaconBeam(context, matrices, waypoint.getColor(), distance);
        matrices.method_22909();
    }

    private static void renderBeaconBeam(WorldRenderContext context, class_4587 matrices, int color, double distance) {
        float alpha = Math.max(0.1f, 1.0f - (float)(distance / 1000.0));
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        Matrix4f matrix = matrices.method_23760().method_23761();
        class_4597.class_4598 consumers = (class_4597.class_4598)context.consumers();
        class_4588 vertexConsumer = consumers.getBuffer((class_1921)FILLED_BOX);
        float width = 0.2f;
        int y = 0;
        while ((float)y < 256.0f) {
            float yPos = y;
            float nextY = Math.min((float)(y + 4), 256.0f);
            vertexConsumer.method_22918(matrix, -width, yPos, -width).method_22915(r, g, b, alpha);
            vertexConsumer.method_22918(matrix, width, yPos, -width).method_22915(r, g, b, alpha);
            vertexConsumer.method_22918(matrix, width, nextY, -width).method_22915(r, g, b, alpha);
            vertexConsumer.method_22918(matrix, -width, nextY, -width).method_22915(r, g, b, alpha);
            vertexConsumer.method_22918(matrix, width, yPos, width).method_22915(r, g, b, alpha);
            vertexConsumer.method_22918(matrix, -width, yPos, width).method_22915(r, g, b, alpha);
            vertexConsumer.method_22918(matrix, -width, nextY, width).method_22915(r, g, b, alpha);
            vertexConsumer.method_22918(matrix, width, nextY, width).method_22915(r, g, b, alpha);
            vertexConsumer.method_22918(matrix, -width, yPos, width).method_22915(r, g, b, alpha);
            vertexConsumer.method_22918(matrix, -width, yPos, -width).method_22915(r, g, b, alpha);
            vertexConsumer.method_22918(matrix, -width, nextY, -width).method_22915(r, g, b, alpha);
            vertexConsumer.method_22918(matrix, -width, nextY, width).method_22915(r, g, b, alpha);
            vertexConsumer.method_22918(matrix, width, yPos, -width).method_22915(r, g, b, alpha);
            vertexConsumer.method_22918(matrix, width, yPos, width).method_22915(r, g, b, alpha);
            vertexConsumer.method_22918(matrix, width, nextY, width).method_22915(r, g, b, alpha);
            vertexConsumer.method_22918(matrix, width, nextY, -width).method_22915(r, g, b, alpha);
            y += 4;
        }
        consumers.method_22993();
    }

    private static void renderWaypointText(WorldRenderContext context, Waypoint waypoint, double distance, float tickDelta) {
        if (distance > 250.0) {
            return;
        }
        Matrix4f positionMatrix = new Matrix4f();
        class_2338 pos = waypoint.getPosition();
        class_243 waypointPos = class_243.method_24954((class_2382)pos).method_1031(0.5, 2.5, 0.5);
        float scale = 1.0f + 3.0f * (float)(distance / 30.0);
        class_327 textRenderer = WaypointRenderer.client.field_1772;
        String text = waypoint.getName() + " \u00a7c" + Math.round(distance) + "m";
        class_4184 camera = context.camera();
        class_243 cameraPos = camera.method_19326();
        positionMatrix.translate((float)(waypointPos.method_10216() - cameraPos.method_10216()), (float)(waypointPos.method_10214() - cameraPos.method_10214()), (float)(waypointPos.method_10215() - cameraPos.method_10215())).rotate((Quaternionfc)camera.method_23767()).scale(scale *= 0.025f, -scale, scale);
        class_4597.class_4598 consumers = class_4597.method_22991((class_9799)ALLOCATOR);
        float xOffset = (float)(-textRenderer.method_1727(text)) / 2.0f;
        textRenderer.method_27521(text, xOffset, 0.0f, 0xFFFFFF, true, positionMatrix, (class_4597)consumers, class_327.class_6415.field_33994, new Color(0, 0, 0, 130).getRGB(), 0xF000F0);
        consumers.method_22993();
    }
}

