/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.features.foraging.treewaypoints;

import com.skyblock21.Skyblock21;
import com.skyblock21.config.Skyblock21ConfigManager;
import com.skyblock21.events.ChatEvents;
import com.skyblock21.events.SkyblockEvents;
import com.skyblock21.features.foraging.treewaypoints.Tree;
import com.skyblock21.features.foraging.treewaypoints.TreeState;
import com.skyblock21.features.waypoints.Waypoint;
import com.skyblock21.features.waypoints.WaypointManager;
import com.skyblock21.util.Location;
import com.skyblock21.util.Utils;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class TreeWaypoints {
    public static final Map<UUID, Tree> trees = new HashMap<UUID, Tree>();
    private static final int SCAN_RADIUS = 1;
    private static int ticks = 0;

    public static void init() {
        ClientTickEvents.END_CLIENT_TICK.register(TreeWaypoints::tick);
        ChatEvents.RECEIVE_TEXT.register(TreeWaypoints::onChat);
        SkyblockEvents.LOCATION_CHANGE.register(TreeWaypoints::onLocationChange);
    }

    private static void onLocationChange(Location location) {
        if (location == Location.GALATEA) {
            TreeWaypoints.performInitialWorldScan();
        } else {
            trees.clear();
            WaypointManager.removeAllWaypoints();
        }
    }

    public static void loadTrees() {
        try (BufferedReader r = class_310.method_1551().method_1478().openAsReader(class_2960.method_60655((String)"skyblock21", (String)"tree_locations.json"));){
            Tree[] loadedTrees;
            for (Tree tree : loadedTrees = (Tree[])Skyblock21.GSON.fromJson((Reader)r, Tree[].class)) {
                tree.basePos = new class_2338(tree.x, tree.y, tree.z);
                tree.currentState = TreeState.NONE;
                tree.knownLogPositions = new HashSet<class_2338>();
                tree.stateStartTime = System.currentTimeMillis();
                tree.waypointId = UUID.randomUUID();
                trees.put(tree.waypointId, tree);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean isTreeAllowed(Tree tree) {
        boolean onlySmall = Skyblock21ConfigManager.get().foraging.onlyShowSmallTrees;
        boolean mangrove = Skyblock21ConfigManager.get().foraging.showMangroveTreeWaypoints;
        boolean fig = Skyblock21ConfigManager.get().foraging.showFigTreeWaypoints;
        if (onlySmall && tree.isBigTree) {
            return false;
        }
        if (tree.isMangrove) {
            return mangrove;
        }
        return fig;
    }

    public static void tick(class_310 client) {
        if (client.field_1687 == null || client.field_1724 == null) {
            return;
        }
        if (++ticks % 2 != 0) {
            return;
        }
        if (!Utils.isOnSkyblock()) {
            return;
        }
        if (!Utils.isInGalatea()) {
            return;
        }
        if (!Skyblock21ConfigManager.get().foraging.treeWaypoints) {
            return;
        }
        for (Tree tree : trees.values()) {
            TreeWaypoints.updateTreeStateMachine(tree);
        }
        TreeWaypoints.updateAllWaypoints();
        if (ticks == 20) {
            ticks = 0;
        }
    }

    private static void onChat(class_2561 text) {
        String message = text.getString();
        if (!message.contains("rewards gained")) {
            return;
        }
        for (Tree tree : trees.values()) {
            double distance;
            class_2338 playerPos = class_310.method_1551().field_1724.method_24515();
            if (playerPos == null || !((distance = tree.basePos.method_10262((class_2382)playerPos)) <= 25.0)) continue;
            if (tree.currentState != TreeState.PRESENT) break;
            tree.setState(TreeState.NOT_PRESENT);
            tree.knownLogPositions.clear();
            break;
        }
    }

    private static void updateTreeStateMachine(Tree tree) {
        int chunkZ;
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null) {
            return;
        }
        int chunkX = tree.basePos.method_10263() >> 4;
        if (!client.field_1687.method_8393(chunkX, chunkZ = tree.basePos.method_10260() >> 4) && tree.currentState != TreeState.NONE) {
            System.out.println("Tree is in unloaded chunk: " + String.valueOf(tree.basePos) + " (" + chunkX + ", " + chunkZ + ")");
            tree.setState(TreeState.NONE);
            return;
        }
        Set<class_2338> logPositions = TreeWaypoints.scanAreaForLogs((class_1937)client.field_1687, tree);
        HashSet connectedLogs = logPositions.isEmpty() ? new HashSet() : TreeWaypoints.scanNeighborsForTree((class_1937)client.field_1687, logPositions, tree);
        boolean treePhysicallyPresent = !connectedLogs.isEmpty();
        long timeInState = tree.getTimeInCurrentState();
        if ((tree.currentState == TreeState.PRESENT || tree.currentState == TreeState.NONE) && ticks % 20 != 0) {
            return;
        }
        switch (tree.currentState) {
            case NONE: {
                if (treePhysicallyPresent) {
                    tree.setState(TreeState.PRESENT);
                    tree.knownLogPositions = new HashSet<class_2338>(connectedLogs);
                }
            }
            case NOT_PRESENT: {
                if (timeInState < tree.NOT_PRESENT_DURATION) break;
                tree.setState(TreeState.REGENERATING);
                break;
            }
            case REGENERATING: {
                if (timeInState < tree.getRegeneratingDuration()) break;
                tree.setState(TreeState.PRESENT);
                break;
            }
            case PRESENT: {
                if (!treePhysicallyPresent) {
                    tree.setState(TreeState.NOT_PRESENT);
                    tree.knownLogPositions.clear();
                    break;
                }
                tree.knownLogPositions = new HashSet<class_2338>(connectedLogs);
            }
        }
    }

    private static Set<class_2338> scanAreaForLogs(class_1937 world, Tree tree) {
        HashSet<class_2338> logPositions = new HashSet<class_2338>();
        int baseX = tree.basePos.method_10263();
        int baseZ = tree.basePos.method_10260();
        for (int x = baseX - 1; x <= baseX + 1; ++x) {
            for (int z = baseZ - 1; z <= baseZ + 1; ++z) {
                for (int y = tree.y; y <= tree.maxY; ++y) {
                    class_2338 pos = new class_2338(x, y, z);
                    class_2248 block = world.method_8320(pos).method_26204();
                    if (block != tree.getLogBlock()) continue;
                    logPositions.add(pos);
                }
            }
        }
        return logPositions;
    }

    private static Set<class_2338> scanNeighborsForTree(class_1937 world, Set<class_2338> initialLogs, Tree tree) {
        HashSet<class_2338> connectedLogs = new HashSet<class_2338>();
        HashSet<class_2338> visited = new HashSet<class_2338>();
        LinkedList<class_2338> queue = new LinkedList<class_2338>();
        if (!initialLogs.isEmpty()) {
            class_2338 start = initialLogs.iterator().next();
            queue.add(start);
            visited.add(start);
        }
        while (!queue.isEmpty()) {
            class_2338 current = (class_2338)queue.poll();
            connectedLogs.add(current);
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        class_2248 block;
                        class_2338 neighbor;
                        if (dx == 0 && dy == 0 && dz == 0 || visited.contains(neighbor = current.method_10069(dx, dy, dz)) || (block = world.method_8320(neighbor).method_26204()) != tree.getLogBlock()) continue;
                        visited.add(neighbor);
                        queue.add(neighbor);
                    }
                }
            }
        }
        return connectedLogs.size() >= 2 ? connectedLogs : new HashSet<class_2338>();
    }

    private static void updateAllWaypoints() {
        for (Tree tree : trees.values()) {
            TreeWaypoints.updateWaypointForTree(tree);
        }
    }

    private static void updateWaypointForTree(Tree tree) {
        Waypoint waypoint = WaypointManager.getWaypoint(tree.waypointId);
        String name = TreeWaypoints.getWaypointName(tree);
        int color = TreeWaypoints.getWaypointColor(tree);
        boolean visible = TreeWaypoints.shouldWaypointBeVisible(tree);
        if (waypoint == null && visible) {
            waypoint = WaypointManager.addWaypoint(tree.waypointId, name, tree.getCenterPos(), color);
            waypoint.setBeaconBeam(true);
        } else if (waypoint != null) {
            waypoint.setVisible(visible);
            if (visible) {
                waypoint.setPosition(tree.basePos);
                waypoint.setName(name);
                waypoint.setColor(color);
                waypoint.setHideWhenClose(tree.currentState == TreeState.PRESENT);
            }
        }
    }

    private static String getWaypointName(Tree tree) {
        String treeName = tree.getTreeTypeName();
        switch (tree.getState()) {
            case NOT_PRESENT: {
                return treeName + " Broken";
            }
            case REGENERATING: {
                long totalDuration = tree.isBig() ? 24000L : 12000L;
                long regenSecondsLeft = (totalDuration - tree.getTimeInState()) / 1000L;
                return treeName + (String)((long)Skyblock21ConfigManager.get().foraging.timeBeforeReady >= regenSecondsLeft ? " \u00a77(" + Math.max(0L, regenSecondsLeft) + "s)" : "");
            }
            case PRESENT: {
                return treeName;
            }
        }
        return "Unknown Tree";
    }

    private static int getWaypointColor(Tree tree) {
        switch (tree.getState()) {
            case REGENERATING: {
                return 0xFFFF00;
            }
            case PRESENT: {
                if (tree.isMangrove()) {
                    return tree.isBig() ? 9127187 : 13789470;
                }
                return tree.isBig() ? 25600 : 3329330;
            }
        }
        return 0xFFFFFF;
    }

    private static boolean shouldWaypointBeVisible(Tree tree) {
        class_2338 playerPos = class_310.method_1551().field_1724.method_24515();
        if (playerPos == null) {
            return false;
        }
        int distance = (int)playerPos.method_40081((double)tree.basePos.method_10263(), (double)tree.basePos.method_10264(), (double)tree.basePos.method_10260());
        int maxDistance = Skyblock21ConfigManager.get().foraging.maxDistance;
        return tree.currentState != TreeState.NOT_PRESENT && tree.currentState != TreeState.NONE && TreeWaypoints.isTreeAllowed(tree) && (maxDistance == 0 || distance <= maxDistance * maxDistance);
    }

    public static void performInitialWorldScan() {
        if (trees.isEmpty()) {
            TreeWaypoints.loadTrees();
            return;
        }
        for (Tree tree : trees.values()) {
            HashSet connectedLogs;
            class_310 client = class_310.method_1551();
            if (client.field_1687 == null) continue;
            Set<class_2338> logPositions = TreeWaypoints.scanAreaForLogs((class_1937)client.field_1687, tree);
            Set<Object> set = connectedLogs = logPositions.isEmpty() ? new HashSet() : TreeWaypoints.scanNeighborsForTree((class_1937)client.field_1687, logPositions, tree);
            if (connectedLogs.isEmpty()) {
                tree.setState(TreeState.NOT_PRESENT);
                continue;
            }
            tree.setState(TreeState.PRESENT);
            tree.knownLogPositions = new HashSet<class_2338>(connectedLogs);
        }
    }
}

