/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.events;

import com.skyblock21.util.Area;
import com.skyblock21.util.Location;
import java.util.Arrays;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_3542;

@Environment(value=EnvType.CLIENT)
public final class SkyblockEvents {
    public static final Event<SkyblockJoin> JOIN = EventFactory.createArrayBacked(SkyblockJoin.class, callbacks -> () -> {
        for (SkyblockJoin callback : callbacks) {
            callback.onSkyblockJoin();
        }
    });
    public static final Event<SkyblockLeave> LEAVE = EventFactory.createArrayBacked(SkyblockLeave.class, callbacks -> () -> {
        for (SkyblockLeave callback : callbacks) {
            callback.onSkyblockLeave();
        }
    });
    public static final Event<SkyblockLocationChange> LOCATION_CHANGE = EventFactory.createArrayBacked(SkyblockLocationChange.class, callbacks -> location -> {
        for (SkyblockLocationChange callback : callbacks) {
            callback.onSkyblockLocationChange(location);
        }
    });
    public static final Event<SkyblockAreaChange> AREA_CHANGE = EventFactory.createArrayBacked(SkyblockAreaChange.class, callbacks -> area -> {
        for (SkyblockAreaChange callback : callbacks) {
            callback.onSkyblockAreaChange(area);
        }
    });
    public static final Event<SkillGained> SKILL_GAINED = EventFactory.createArrayBacked(SkillGained.class, listeners -> (skill, amount) -> {
        for (SkillGained listener : listeners) {
            listener.onSkillGained(skill, amount);
        }
    });
    public static final Event<ProfileChange> PROFILE_CHANGE = EventFactory.createArrayBacked(ProfileChange.class, callbacks -> (prev, profile) -> {
        for (ProfileChange callback : callbacks) {
            callback.onSkyblockProfileChange(prev, profile);
        }
    });
    public static final Event<ProfileInit> PROFILE_INIT = EventFactory.createArrayBacked(ProfileInit.class, callbacks -> profile -> {
        for (ProfileInit callback : callbacks) {
            callback.onSkyblockProfileInit(profile);
        }
    });

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface ProfileInit {
        public void onSkyblockProfileInit(String var1);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface ProfileChange {
        public void onSkyblockProfileChange(String var1, String var2);
    }

    @FunctionalInterface
    public static interface SkillGained {
        public void onSkillGained(Skill var1, double var2);
    }

    public static enum Skill implements class_3542
    {
        FARMING("Farming"),
        MINING("Mining"),
        COMBAT("Combat"),
        FORAGING("Foraging"),
        HUNTING("Hunting"),
        TAMING("Taming"),
        CARPENTRY("Carpentry"),
        ENCHANTING("Enchanting"),
        SOCIAL("Social"),
        UNKNOWN("Unknown");

        public final String name;

        private Skill(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        public static Skill fromName(String displayName) {
            return Arrays.stream(Skill.values()).filter(s -> s.name.equals(displayName)).findFirst().orElse(UNKNOWN);
        }
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface SkyblockAreaChange {
        public void onSkyblockAreaChange(Area var1);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface SkyblockLocationChange {
        public void onSkyblockLocationChange(Location var1);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface SkyblockLeave {
        public void onSkyblockLeave();
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface SkyblockJoin {
        public void onSkyblockJoin();
    }
}

