/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.hud.elements;

import com.skyblock21.config.Skyblock21ConfigManager;
import com.skyblock21.events.ChatEvents;
import com.skyblock21.events.SkyblockEvents;
import com.skyblock21.hud.MultiLineHudElement;
import com.skyblock21.hud.SortType;
import com.skyblock21.util.Location;
import com.skyblock21.util.TextUtils;
import com.skyblock21.util.Utils;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class HuntingTrackerElement
extends MultiLineHudElement {
    private Map<String, Integer> trackedShards;
    private int totalHuntingXP = 0;
    private long activeTimeStart = System.currentTimeMillis();
    private long totalActiveTime = 0L;
    private long lastActiveTime = System.currentTimeMillis();
    private boolean isAFK = false;
    private class_243 lastPlayerPos = null;
    private float lastPlayerYaw = 0.0f;
    private float lastPlayerPitch = 0.0f;
    private long lastMovementTime = System.currentTimeMillis();
    private static final long AFK_THRESHOLD = 10000L;
    private boolean paused = true;
    private static final Pattern SHARD_PATTERN = Pattern.compile("(?:a|(\\d+)) (.*?) \u00a7.Shard");
    private static final NumberFormat formatter = NumberFormat.getNumberInstance(Locale.US);

    public HuntingTrackerElement(int x, int y) {
        super(x, y);
        this.setTitle("\u00a79\u00a7lHunting", 0xFFFFFF, 1.2f, true);
        this.addLine("hunting_exp", (class_2561)class_2561.method_43470((String)"\u00a79Hunting XP: \u00a7f%d".formatted(this.totalHuntingXP)));
        this.addLine("hunting_rate", (class_2561)class_2561.method_43470((String)"\u00a79XP/Hour: \u00a7f0"));
        this.addLine("active_time", (class_2561)class_2561.method_43470((String)"\u00a7dActive Time: \u00a7f0s"));
        this.addConditionalLine("afk_status", (class_2561)class_2561.method_43470((String)"\u00a77(Paused)"), () -> this.isAFK);
        this.createGroup("shards", "Shards", 1, true);
        this.setGroupSorting("shards", SortType.AMOUNT, false);
        this.addContainerClickableLine("reset_hunting", (class_2561)class_2561.method_43470((String)"\u00a7c[Reset Tracker]"), this::resetTracker).setHoverText((class_2561)class_2561.method_43470((String)"\u00a7eReset the hunting tracker"));
        this.trackedShards = new HashMap<String, Integer>();
        SkyblockEvents.SKILL_GAINED.register(this::onSkillGained);
        SkyblockEvents.LOCATION_CHANGE.register(this::onLocationChange);
        ChatEvents.RECEIVE_TEXT.register(this::onChat);
    }

    private void onLocationChange(Location location) {
        if (!Utils.isOnSkyblock()) {
            this.pauseTracker();
        }
    }

    private void onChat(class_2561 text) {
        String message = text.getString();
        Matcher matcher = SHARD_PATTERN.matcher(message);
        if (!matcher.find()) {
            return;
        }
        String amount = matcher.group(1);
        String itemName = matcher.group(2);
        int count = amount != null ? Integer.parseInt(amount) : 1;
        this.addOrUpdateShard(itemName, count);
    }

    @Override
    protected void onTick(class_310 client) {
        if (client.field_1724 == null) {
            return;
        }
        this.updateAFKStatus(client);
        if (this.activeTimeStart != -1L) {
            long currentActiveTime = this.calculateCurrentActiveTime();
            this.updateLine("active_time", (class_2561)class_2561.method_43470((String)"\u00a7dActive Time: \u00a7f%s".formatted(Utils.formatTime(currentActiveTime))));
        }
    }

    private void updateAFKStatus(class_310 client) {
        boolean hasMovedLook;
        class_243 currentPos = client.field_1724.method_19538();
        float currentYaw = client.field_1724.method_36454();
        float currentPitch = client.field_1724.method_36455();
        boolean hasMovedPosition = this.lastPlayerPos == null || !currentPos.equals((Object)this.lastPlayerPos);
        boolean bl = hasMovedLook = Math.abs(currentYaw - this.lastPlayerYaw) > 0.2f || Math.abs(currentPitch - this.lastPlayerPitch) > 0.2f;
        if (hasMovedPosition || hasMovedLook) {
            if (this.isAFK) {
                this.resumeTracker();
            }
            this.lastMovementTime = System.currentTimeMillis();
            this.lastPlayerPos = currentPos;
            this.lastPlayerYaw = currentYaw;
            this.lastPlayerPitch = currentPitch;
            this.isAFK = false;
        } else {
            long timeSinceMovement = System.currentTimeMillis() - this.lastMovementTime;
            if (timeSinceMovement >= 10000L && !this.isAFK) {
                this.pauseTracker();
                this.isAFK = true;
            }
        }
    }

    private void pauseTracker() {
        if (!this.paused && this.activeTimeStart != -1L) {
            this.totalActiveTime += System.currentTimeMillis() - this.lastActiveTime;
            this.paused = true;
        }
    }

    private void resumeTracker() {
        if (this.paused) {
            this.lastActiveTime = System.currentTimeMillis();
            this.paused = false;
        }
    }

    private long calculateCurrentActiveTime() {
        if (this.activeTimeStart == -1L) {
            return 0L;
        }
        long currentActive = this.totalActiveTime;
        if (!this.paused) {
            currentActive += System.currentTimeMillis() - this.lastActiveTime;
        }
        return currentActive;
    }

    private void updateRates() {
        long currentActiveTime = this.calculateCurrentActiveTime();
        if (currentActiveTime > 0L) {
            double hoursActive = (double)currentActiveTime / 3600000.0;
            long xpPerHour = Math.round((double)this.totalHuntingXP / hoursActive);
            this.updateLine("hunting_rate", (class_2561)class_2561.method_43470((String)"\u00a79XP/Hour: \u00a7f%s".formatted(formatter.format(xpPerHour))));
        } else {
            this.updateLine("hunting_rate", (class_2561)class_2561.method_43470((String)"\u00a79XP/Hour: \u00a7f0"));
        }
    }

    private void onSkillGained(SkyblockEvents.Skill skill, double amount) {
        if (skill != SkyblockEvents.Skill.HUNTING) {
            return;
        }
        if (this.totalHuntingXP == 0) {
            this.activeTimeStart = System.currentTimeMillis();
            this.lastActiveTime = System.currentTimeMillis();
            this.totalActiveTime = 0L;
        }
        this.paused = false;
        this.isAFK = false;
        this.lastMovementTime = System.currentTimeMillis();
        this.totalHuntingXP += (int)amount;
        this.updateLine("hunting_exp", (class_2561)class_2561.method_43470((String)"\u00a79Hunting XP: \u00a7f%s".formatted(formatter.format(this.totalHuntingXP))));
        this.updateRates();
    }

    public void addOrUpdateShard(String shard, int amount) {
        if (this.trackedShards.containsKey(shard)) {
            this.updateAmountLine(shard, shard, this.trackedShards.get(shard) + amount);
            this.trackedShards.put(shard, this.trackedShards.get(shard) + amount);
        } else {
            this.addAmountLine(shard, shard, amount, "shards");
            this.trackedShards.put(shard, amount);
        }
    }

    public void resetTracker() {
        this.trackedShards.clear();
        this.totalHuntingXP = 0;
        this.totalActiveTime = 0L;
        this.activeTimeStart = -1L;
        this.lastActiveTime = System.currentTimeMillis();
        this.paused = true;
        this.isAFK = false;
        this.lines.removeIf(line -> line.getGroupId() != null && line.getGroupId().equals("shards"));
        TextUtils.addMessage("\u00a7aHunting tracker reset!", true, false);
        this.updateLine("hunting_exp", (class_2561)class_2561.method_43470((String)"\u00a79Hunting XP: \u00a7f%d".formatted(this.totalHuntingXP)));
        this.updateLine("hunting_rate", (class_2561)class_2561.method_43470((String)"\u00a79XP/Hour: \u00a7f0"));
        this.updateLine("active_time", (class_2561)class_2561.method_43470((String)"\u00a7dActive Time: \u00a7f0s"));
        this.updateLine("afk_status", (class_2561)class_2561.method_43470((String)"\u00a77Status: \u00a7aActive"));
    }

    @Override
    public boolean isEnabled() {
        return Skyblock21ConfigManager.get().hunting.huntingTracker;
    }
}

