/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.hud.elements;

import com.skyblock21.config.Skyblock21ConfigManager;
import com.skyblock21.config.persistent.PersistentData;
import com.skyblock21.features.Scathas;
import com.skyblock21.hud.MultiLineHudElement;
import com.skyblock21.util.Location;
import com.skyblock21.util.Utils;
import java.awt.Color;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class ScathaTrackerElement
extends MultiLineHudElement {
    public ScathaTrackerElement(int x, int y) {
        super(x, y);
        this.setTitle("\u00a7lScatha Tracker", new Color(134, 239, 244).getRGB(), 1.1f, true);
        this.addAmountLine("worms", "\u00a7bWorms", 0L);
        this.addLine("scathas", (class_2561)class_2561.method_43470((String)"\u00a7bScathas: \u00a7f0 \u00a77(0%)"));
        this.addAmountLine("spawns_since_drop", "\u00a77Spawns since pet drop", 0L);
        this.addLine("last_spawn", (class_2561)class_2561.method_43470((String)"\u00a77Last Scatha spawn: \u00a7f28s ago"));
        this.addConditionalLine("cannot_spawn", (class_2561)class_2561.method_43470((String)"\u00a7cCannot spawn scatha yet! 5s"), () -> {
            Scathas.ScathasData data = PersistentData.get().scathasData;
            return data != null && System.currentTimeMillis() - data.lastScathaKillTime < 30000L;
        });
        this.addContainerClickableLine("reset_stats", (class_2561)class_2561.method_43470((String)"\u00a7c[Reset Stats]"), () -> {
            Scathas.ScathasData data = PersistentData.get().scathasData;
            if (data != null) {
                data.wormsSpawned = 0;
                data.scathasSpawned = 0;
                data.sinceLastScathaPetDropSpawns = 0;
                data.lastSpawnTime = -1L;
                data.lastScathaKillTime = 0L;
            }
        }).setHoverText((class_2561)class_2561.method_43470((String)"\u00a7eReset the scatha tracker"));
    }

    @Override
    protected void renderDummy(class_332 context) {
        this.renderElement(context);
    }

    @Override
    protected void onTick(class_310 client) {
        Scathas.ScathasData data = PersistentData.get().scathasData;
        if (data == null) {
            return;
        }
        this.updateAmountLine("worms", data.wormsSpawned);
        this.updateLine("scathas", (class_2561)class_2561.method_43470((String)String.format("\u00a7bScathas: \u00a7f%d \u00a77(%.0f%%)", data.scathasSpawned, data.scathasSpawned > 0 ? (double)data.scathasSpawned * 100.0 / (double)(data.wormsSpawned + data.scathasSpawned) : 0.0)));
        this.updateAmountLine("spawns_since_drop", data.sinceLastScathaPetDropSpawns);
        this.updateLine("last_spawn", (class_2561)class_2561.method_43470((String)String.format("\u00a77Last Scatha spawn: \u00a7f%s ago", data.lastSpawnTime == -1L || System.currentTimeMillis() - data.lastSpawnTime >= 86400000L ? "N/A" : Utils.formatTime(System.currentTimeMillis() - data.lastSpawnTime))));
        if (System.currentTimeMillis() - data.lastScathaKillTime < 30000L) {
            this.updateLine("cannot_spawn", (class_2561)class_2561.method_43470((String)String.format("\u00a7cCannot spawn Scatha yet! %s", Utils.formatTime(30000L - (System.currentTimeMillis() - data.lastScathaKillTime)))));
        }
    }

    @Override
    public boolean isEnabled() {
        return Skyblock21ConfigManager.get().mining.scathaTracker;
    }

    @Override
    public boolean isAllowedInLocation(Location location) {
        return !Skyblock21ConfigManager.get().mining.showOnlyInCrystalHollows || location.equals((Object)Location.CRYSTAL_HOLLOWS);
    }
}

