/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.util;

import com.skyblock21.Skyblock21;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BooleanSupplier;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;

public class TickScheduler {
    private static TickScheduler clientInstance;
    private static TickScheduler serverInstance;
    private final Map<String, ScheduledTask> tasks = new ConcurrentHashMap<String, ScheduledTask>();
    private final AtomicLong taskIdCounter = new AtomicLong(0L);
    private long currentTick = 0L;
    private final PriorityQueue<ScheduledTask> taskQueue = new PriorityQueue<ScheduledTask>(Comparator.comparing(ScheduledTask::getNextExecutionTick));

    private TickScheduler() {
    }

    public static TickScheduler getClientScheduler() {
        if (clientInstance == null) {
            clientInstance = new TickScheduler();
            clientInstance.initializeClientScheduler();
        }
        return clientInstance;
    }

    public static TickScheduler getServerScheduler() {
        if (serverInstance == null) {
            serverInstance = new TickScheduler();
            serverInstance.initializeServerScheduler();
        }
        return serverInstance;
    }

    private void initializeClientScheduler() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1687 != null) {
                this.tick();
            }
        });
        Skyblock21.LOGGER.debug("Client TickScheduler initialized");
    }

    private void initializeServerScheduler() {
        ServerTickEvents.END_SERVER_TICK.register(server -> this.tick());
        Skyblock21.LOGGER.debug("Server TickScheduler initialized");
    }

    private void tick() {
        ++this.currentTick;
        while (!this.taskQueue.isEmpty() && this.taskQueue.peek().getNextExecutionTick() <= this.currentTick) {
            ScheduledTask task = this.taskQueue.poll();
            if (task == null || task.isCancelled()) continue;
            try {
                task.execute();
                if (task.isRepeating() && !task.isCancelled()) {
                    task.scheduleNext(this.currentTick);
                    this.taskQueue.offer(task);
                    continue;
                }
                this.tasks.remove(task.getId());
            }
            catch (Exception e) {
                Skyblock21.LOGGER.error("Error executing scheduled task {}: {}", (Object)task.getId(), (Object)e.getMessage());
                task.cancel();
                this.tasks.remove(task.getId());
            }
        }
    }

    public String scheduleTask(Runnable task, long delayTicks) {
        return this.scheduleTask("auto_" + this.taskIdCounter.incrementAndGet(), task, delayTicks);
    }

    public String scheduleTask(String taskId, Runnable task, long delayTicks) {
        if (delayTicks < 0L) {
            throw new IllegalArgumentException("Delay cannot be negative");
        }
        ScheduledTask scheduledTask = new ScheduledTask(taskId, task, this.currentTick + delayTicks, -1L, false);
        this.tasks.put(taskId, scheduledTask);
        this.taskQueue.offer(scheduledTask);
        return taskId;
    }

    public String scheduleRepeatingTask(Runnable task, long delayTicks, long intervalTicks) {
        return this.scheduleRepeatingTask("auto_" + this.taskIdCounter.incrementAndGet(), task, delayTicks, intervalTicks);
    }

    public String scheduleRepeatingTask(String taskId, Runnable task, long delayTicks, long intervalTicks) {
        if (delayTicks < 0L || intervalTicks <= 0L) {
            throw new IllegalArgumentException("Invalid delay or interval");
        }
        ScheduledTask scheduledTask = new ScheduledTask(taskId, task, this.currentTick + delayTicks, intervalTicks, true);
        this.tasks.put(taskId, scheduledTask);
        this.taskQueue.offer(scheduledTask);
        return taskId;
    }

    public String scheduleLimitedTask(String taskId, Runnable task, long intervalTicks, int maxExecutions) {
        AtomicCounter counter = new AtomicCounter(0);
        Runnable limitedTask = () -> {
            task.run();
            if (counter.incrementAndGet() >= maxExecutions) {
                this.cancelTask(taskId);
            }
        };
        return this.scheduleRepeatingTask(taskId, limitedTask, 0L, intervalTicks);
    }

    public String scheduleConditionalTask(String taskId, Runnable task, long intervalTicks, BooleanSupplier stopCondition) {
        Runnable conditionalTask = () -> {
            task.run();
            if (stopCondition.getAsBoolean()) {
                this.cancelTask(taskId);
            }
        };
        return this.scheduleRepeatingTask(taskId, conditionalTask, 0L, intervalTicks);
    }

    public boolean cancelTask(String taskId) {
        ScheduledTask task = this.tasks.remove(taskId);
        if (task != null) {
            task.cancel();
            return true;
        }
        return false;
    }

    public boolean hasTask(String taskId) {
        ScheduledTask task = this.tasks.get(taskId);
        return task != null && !task.isCancelled();
    }

    public void cancelAllTasks() {
        for (ScheduledTask task : this.tasks.values()) {
            task.cancel();
        }
        this.tasks.clear();
        this.taskQueue.clear();
    }

    public long getCurrentTick() {
        return this.currentTick;
    }

    public Set<String> getActiveTaskIds() {
        return new HashSet<String>(this.tasks.keySet());
    }

    public int getActiveTaskCount() {
        return this.tasks.size();
    }

    public String scheduleTaskInSeconds(Runnable task, double seconds) {
        return this.scheduleTask(task, this.secondsToTicks(seconds));
    }

    public String scheduleTaskInSeconds(String taskId, Runnable task, double seconds) {
        return this.scheduleTask(taskId, task, this.secondsToTicks(seconds));
    }

    public String scheduleRepeatingTaskInSeconds(Runnable task, double delaySeconds, double intervalSeconds) {
        return this.scheduleRepeatingTask(task, this.secondsToTicks(delaySeconds), this.secondsToTicks(intervalSeconds));
    }

    public String scheduleRepeatingTaskInSeconds(String taskId, Runnable task, double delaySeconds, double intervalSeconds) {
        return this.scheduleRepeatingTask(taskId, task, this.secondsToTicks(delaySeconds), this.secondsToTicks(intervalSeconds));
    }

    public String scheduleLimitedTaskInSeconds(String taskId, Runnable task, double intervalSeconds, int maxExecutions) {
        return this.scheduleLimitedTask(taskId, task, this.secondsToTicks(intervalSeconds), maxExecutions);
    }

    private long secondsToTicks(double seconds) {
        return Math.round(seconds * 20.0);
    }

    private static class ScheduledTask {
        private final String id;
        private final Runnable task;
        private long nextExecutionTick;
        private final long intervalTicks;
        private final boolean repeating;
        private volatile boolean cancelled = false;

        public ScheduledTask(String id, Runnable task, long nextExecutionTick, long intervalTicks, boolean repeating) {
            this.id = id;
            this.task = task;
            this.nextExecutionTick = nextExecutionTick;
            this.intervalTicks = intervalTicks;
            this.repeating = repeating;
        }

        public void execute() {
            if (!this.cancelled) {
                this.task.run();
            }
        }

        public void scheduleNext(long currentTick) {
            if (this.repeating && !this.cancelled) {
                this.nextExecutionTick = currentTick + this.intervalTicks;
            }
        }

        public void cancel() {
            this.cancelled = true;
        }

        public String getId() {
            return this.id;
        }

        public long getNextExecutionTick() {
            return this.nextExecutionTick;
        }

        public long getIntervalTicks() {
            return this.intervalTicks;
        }

        public boolean isRepeating() {
            return this.repeating;
        }

        public boolean isCancelled() {
            return this.cancelled;
        }
    }

    private static class AtomicCounter {
        private volatile int value;

        public AtomicCounter(int initialValue) {
            this.value = initialValue;
        }

        public synchronized int incrementAndGet() {
            return ++this.value;
        }

        public int get() {
            return this.value;
        }
    }
}

