/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.features.itemcustomization;

import com.skyblock21.config.persistent.PersistentData;
import com.skyblock21.features.itemcustomization.ItemCustomization;
import com.skyblock21.util.TextUtils;
import com.skyblock21.util.Utils;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4286;
import net.minecraft.class_437;
import net.minecraft.class_7923;
import net.minecraft.class_9279;
import net.minecraft.class_9290;
import net.minecraft.class_9334;

public class ItemCustomizationScreen
extends class_437 {
    private final class_1799 itemStack;
    private final String itemUuid;
    private ItemCustomization customization;
    private class_342 nameField;
    private class_342 itemIdField;
    private class_4286 glintCheckbox;
    private class_4185 saveButton;
    private class_4185 resetButton;
    private String errorMessage = "";
    private int errorTicks = 0;
    private static final String[][] COLOR_CODES = new String[][]{{"&0", "Black", "0x000000"}, {"&1", "Dark Blue", "0x0000AA"}, {"&2", "Dark Green", "0x00AA00"}, {"&3", "Dark Aqua", "0x00AAAA"}, {"&4", "Dark Red", "0xAA0000"}, {"&5", "Dark Purple", "0xAA00AA"}, {"&6", "Gold", "0xFFAA00"}, {"&7", "Gray", "0xAAAAAA"}, {"&8", "Dark Gray", "0x555555"}, {"&9", "Blue", "0x5555FF"}, {"&a", "Green", "0x55FF55"}, {"&b", "Aqua", "0x55FFFF"}, {"&c", "Red", "0xFF5555"}, {"&d", "Light Purple", "0xFF55FF"}, {"&e", "Yellow", "0xFFFF55"}, {"&f", "White", "0xFFFFFF"}};
    private static final String[][] FORMAT_CODES = new String[][]{{"&k", "Obfuscated", "Random chars"}, {"&l", "Bold", "Bold text"}, {"&m", "Strikethrough", "Crossed out"}, {"&n", "Underline", "Underlined"}, {"&o", "Italic", "Italic text"}, {"&r", "Reset", "Reset formatting"}};

    public ItemCustomizationScreen(class_1799 itemStack) {
        super((class_2561)class_2561.method_43470((String)"Item Customization"));
        this.itemStack = itemStack;
        this.itemUuid = Utils.getItemUUID(itemStack);
        this.customization = PersistentData.get().itemCustomizations.getOrDefault(this.itemUuid, new ItemCustomization());
    }

    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        int startY = this.field_22790 / 2 - 80;
        this.nameField = new class_342(this.field_22793, centerX - 100, startY, 200, 20, (class_2561)class_2561.method_43470((String)""));
        this.nameField.method_1880(130);
        String name = this.customization.customName.isEmpty() ? (this.itemStack.method_65130() != null ? TextUtils.translateColorCodes(this.itemStack.method_65130().getString(), true) : "") : this.customization.customName;
        this.nameField.method_1852(name);
        this.nameField.method_1863(this::onNameChanged);
        this.method_25429((class_364)this.nameField);
        this.itemIdField = new class_342(this.field_22793, centerX - 100, startY + 40, 200, 20, (class_2561)class_2561.method_43470((String)""));
        this.itemIdField.method_1880(100);
        this.itemIdField.method_1852(this.customization.customItemId);
        this.itemIdField.method_1863(this::onItemIdChanged);
        this.method_25429((class_364)this.itemIdField);
        this.glintCheckbox = class_4286.method_54787((class_2561)class_2561.method_43470((String)"Enable Glint"), (class_327)this.field_22793).method_54789(centerX - 50, startY + 80).method_54794(this.customization.hasGlint).method_54788();
        this.method_37063((class_364)this.glintCheckbox);
        this.saveButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Save"), button -> this.save()).method_46434(centerX - 105, startY + 120, 100, 20).method_46431();
        this.method_37063((class_364)this.saveButton);
        this.resetButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Reset"), button -> this.reset()).method_46434(centerX + 5, startY + 120, 100, 20).method_46431();
        this.method_37063((class_364)this.resetButton);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Close"), button -> this.method_25419()).method_46434(centerX - 50, startY + 150, 100, 20).method_46431());
    }

    private void onNameChanged(String newValue) {
    }

    private void onItemIdChanged(String newValue) {
        if (!newValue.isEmpty()) {
            try {
                class_2960 id = class_2960.method_12829((String)newValue);
                if (id == null) {
                    this.setError("Invalid item ID format");
                    return;
                }
                class_1792 item = (class_1792)class_7923.field_41178.method_63535(id);
                if (item == null || item.equals(class_7923.field_41178.method_63535(class_2960.method_60654((String)"air")))) {
                    this.setError("Item not found: " + newValue);
                    return;
                }
                this.clearError();
            }
            catch (Exception e) {
                this.setError("Invalid item ID: " + e.getMessage());
            }
        } else {
            this.clearError();
        }
    }

    private void setError(String message) {
        this.errorMessage = message;
        this.errorTicks = 100;
        this.saveButton.field_22763 = false;
    }

    private void clearError() {
        this.errorMessage = "";
        this.errorTicks = 0;
        this.saveButton.field_22763 = true;
    }

    public void method_25393() {
        super.method_25393();
        if (this.errorTicks > 0) {
            --this.errorTicks;
            if (this.errorTicks == 0) {
                this.clearError();
            }
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        super.method_25394(context, mouseX, mouseY, delta);
        int centerX = this.field_22789 / 2;
        int startY = this.field_22790 / 2 - 80;
        context.method_27534(this.field_22793, this.field_22785, centerX, startY - 80, 0xFFFFFF);
        class_1799 previewStack = this.createPreviewStack();
        context.method_51448().method_22903();
        context.method_51448().method_22905(3.0f, 3.0f, 1.0f);
        context.method_51427(previewStack, (centerX - 24) / 3, (startY - 60) / 3);
        context.method_51448().method_22909();
        context.method_25303(this.field_22793, "Custom Name:", centerX - 100, startY - 10, 0xFFFFFF);
        context.method_25303(this.field_22793, "Custom Item ID:", centerX - 100, startY + 30, 0xFFFFFF);
        this.nameField.method_25394(context, mouseX, mouseY, delta);
        this.itemIdField.method_25394(context, mouseX, mouseY, delta);
        if (!this.errorMessage.isEmpty() && this.errorTicks > 0) {
            context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)this.errorMessage).method_27692(class_124.field_1061), centerX, startY + 100, 0xFF5555);
        }
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)"Use & for color codes (e.g., &a for green)").method_27692(class_124.field_1080), centerX - 100, startY + 60, 0x888888);
        this.drawColorCodePanel(context, mouseX, mouseY);
    }

    private void drawColorCodePanel(class_332 context, int mouseX, int mouseY) {
        String name;
        String code;
        int panelX = this.field_22789 / 2 + 120;
        int panelY = this.field_22790 / 2 - 100;
        int panelWidth = 140;
        int panelHeight = 280;
        context.method_25294(panelX, panelY, panelX + panelWidth, panelY + panelHeight, Integer.MIN_VALUE);
        context.method_49601(panelX, panelY, panelWidth, panelHeight, -5592406);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)"Color Codes"), panelX + 5, panelY + 5, 0xFFFFFF, false);
        int yOffset = 20;
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)"Colors:"), panelX + 5, panelY + yOffset, 0xFFFFFF, false);
        yOffset += 12;
        for (String[] colorCode : COLOR_CODES) {
            code = colorCode[0];
            name = colorCode[1];
            String formattedCode = code.replace('&', '\u00a7');
            context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)(formattedCode + code)), panelX + 5, panelY + yOffset, 0xFFFFFF, false);
            context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)name), panelX + 35, panelY + yOffset, 0xCCCCCC, false);
            yOffset += 10;
        }
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)"Formatting:"), panelX + 5, panelY + (yOffset += 5), 0xFFFFFF, false);
        yOffset += 12;
        for (String[] formatCode : FORMAT_CODES) {
            code = formatCode[0];
            name = formatCode[1];
            context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)code), panelX + 5, panelY + yOffset, 0xFFFF55, false);
            context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)name), panelX + 35, panelY + yOffset, 0xCCCCCC, false);
            yOffset += 10;
        }
    }

    private class_1799 createPreviewStack() {
        String customName;
        class_1799 preview = this.itemStack.method_7972();
        String customItemId = this.itemIdField.method_1882().trim();
        if (!customItemId.isEmpty()) {
            try {
                class_1792 customItem;
                class_2960 id = class_2960.method_12829((String)customItemId);
                if (id != null && (customItem = (class_1792)class_7923.field_41178.method_63535(id)) != null && !customItem.equals(class_7923.field_41178.method_63535(class_2960.method_60654((String)"air")))) {
                    preview = new class_1799((class_1935)customItem, preview.method_7947());
                    preview.method_57379(class_9334.field_49628, (Object)((class_9279)this.itemStack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302)));
                    class_9290 lore = (class_9290)this.itemStack.method_58694(class_9334.field_49632);
                    if (lore != null) {
                        preview.method_57379(class_9334.field_49632, (Object)lore);
                    }
                }
            }
            catch (Exception id) {
                // empty catch block
            }
        }
        if (!(customName = this.nameField.method_1882().trim()).isEmpty()) {
            String formattedName = TextUtils.translateColorCodes(customName, false);
            preview.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)formattedName));
        }
        if (this.glintCheckbox.method_20372()) {
            preview.method_57379(class_9334.field_49641, (Object)true);
        } else {
            preview.method_57379(class_9334.field_49641, (Object)false);
        }
        return preview;
    }

    private void save() {
        ItemCustomization temp;
        String itemId = this.itemIdField.method_1882().trim();
        if (!itemId.isEmpty() && !(temp = new ItemCustomization("", itemId, false)).isValidItemId()) {
            this.setError("Cannot save: Invalid item ID");
            return;
        }
        ItemCustomization newCustomization = new ItemCustomization(this.nameField.method_1882(), itemId, this.glintCheckbox.method_20372());
        if (newCustomization.hasCustomName() || newCustomization.hasCustomItemId() || newCustomization.hasGlint) {
            PersistentData.get().itemCustomizations.put(this.itemUuid, newCustomization);
        } else {
            PersistentData.get().itemCustomizations.remove(this.itemUuid);
        }
        PersistentData.save();
        this.method_25419();
    }

    private void reset() {
        this.nameField.method_1852(this.itemStack.method_65130() != null ? this.itemStack.method_65130().getString() : "");
        this.itemIdField.method_1852(this.itemStack.method_7909().toString());
        this.clearError();
    }

    public boolean method_25422() {
        return this.errorMessage.isEmpty();
    }

    public void method_25419() {
        if (!this.errorMessage.isEmpty()) {
            return;
        }
        super.method_25419();
    }
}

