/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.features.keyshortcuts;

import com.skyblock21.config.persistent.PersistentData;
import com.skyblock21.features.keyshortcuts.Modifier;
import com.skyblock21.features.keyshortcuts.Shortcut;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4286;
import net.minecraft.class_437;
import org.lwjgl.glfw.GLFW;

public class KeyShortcutsScreen
extends class_437 {
    private final class_437 parent;
    private final List<ShortcutEntry> entries = new ArrayList<ShortcutEntry>();
    private int scrollOffset = 0;
    private final int entryHeight = 30;
    private int maxVisibleEntries;
    private final int listStartY = 80;
    private int listEndY;
    private int scrollbarX;
    private final int scrollbarWidth = 8;
    private KeybindButton listeningButton = null;
    private boolean isDraggingScrollbar = false;
    private int dragStartY = 0;
    private int dragStartOffset = 0;

    public KeyShortcutsScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Key Shortcuts"));
        this.parent = parent;
    }

    protected void method_25426() {
        int paddingX = this.field_22789 / 10;
        int paddingY = this.field_22790 / 10;
        this.listEndY = this.field_22790 - paddingY - 60;
        this.scrollbarX = this.field_22789 - paddingX - 8 - 10;
        int availableHeight = this.listEndY - 80;
        this.maxVisibleEntries = Math.max(5, availableHeight / 30);
        this.entries.clear();
        for (Shortcut shortcut : PersistentData.get().shortcuts) {
            this.entries.add(new ShortcutEntry(shortcut));
        }
        if (this.entries.isEmpty() || !this.entries.get(this.entries.size() - 1).isEmpty()) {
            this.entries.add(new ShortcutEntry(new Shortcut()));
        }
        this.initializeWidgets();
        int buttonY = this.field_22790 - paddingY - 25;
        int buttonWidth = 100;
        int buttonSpacing = 20;
        int totalButtonWidth = buttonWidth * 2 + buttonSpacing;
        int buttonStartX = (this.field_22789 - totalButtonWidth) / 2;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Done"), button -> this.saveAndClose()).method_46434(buttonStartX, buttonY, buttonWidth, 25).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Add New"), button -> {
            this.entries.add(new ShortcutEntry(new Shortcut()));
            this.initializeWidgets();
        }).method_46434(buttonStartX + buttonWidth + buttonSpacing, buttonY, buttonWidth, 25).method_46431());
    }

    private void initializeWidgets() {
        this.method_37067();
        int paddingX = this.field_22789 / 10;
        int entryWidth = this.field_22789 - paddingX * 2 - 8 - 20;
        for (int i = 0; i < this.entries.size(); ++i) {
            if (i < this.scrollOffset || i >= this.scrollOffset + this.maxVisibleEntries) continue;
            ShortcutEntry entry = this.entries.get(i);
            int y = 80 + (i - this.scrollOffset) * 30;
            int checkboxX = paddingX + 20;
            int commandX = checkboxX + 50;
            int commandWidth = (int)((double)entryWidth * 0.4);
            int keybindX = commandX + commandWidth + 10;
            int keybindWidth = (int)((double)entryWidth * 0.35);
            int removeX = keybindX + keybindWidth + 10;
            int removeWidth = 80;
            entry.enabledBox = class_4286.method_54787((class_2561)class_2561.method_43470((String)""), (class_327)this.field_22793).method_54789(checkboxX, y + 3).method_54794(entry.shortcut.enabled).method_54788();
            this.method_37063((class_364)entry.enabledBox);
            entry.commandField = new class_342(this.field_22793, commandX, y, commandWidth, 25, (class_2561)class_2561.method_43470((String)"Command"));
            entry.commandField.method_1852(entry.shortcut.command);
            entry.commandField.method_1880(256);
            this.method_37063((class_364)entry.commandField);
            entry.keybindButton = new KeybindButton(keybindX, y, keybindWidth, 25, entry);
            this.method_37063((class_364)entry.keybindButton);
            int index = i;
            class_4185 removeButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Remove"), button -> {
                this.entries.remove(index);
                int maxOffset = Math.max(0, this.entries.size() - this.maxVisibleEntries);
                this.scrollOffset = Math.min(this.scrollOffset, maxOffset);
                this.initializeWidgets();
            }).method_46434(removeX, y, removeWidth, 25).method_46431();
            this.method_37063((class_364)removeButton);
        }
        int paddingY = this.field_22790 / 10;
        int buttonY = this.field_22790 - paddingY - 25;
        int buttonWidth = 100;
        int buttonSpacing = 20;
        int totalButtonWidth = buttonWidth * 2 + buttonSpacing;
        int buttonStartX = (this.field_22789 - totalButtonWidth) / 2;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Done"), button -> this.saveAndClose()).method_46434(buttonStartX, buttonY, buttonWidth, 25).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Add New"), button -> {
            this.updateEntriesFromFields();
            this.entries.add(new ShortcutEntry(new Shortcut()));
            this.initializeWidgets();
        }).method_46434(buttonStartX + buttonWidth + buttonSpacing, buttonY, buttonWidth, 25).method_46431());
    }

    private void updateEntriesFromFields() {
        for (ShortcutEntry entry : this.entries) {
            if (entry.commandField != null) {
                entry.shortcut.command = entry.commandField.method_1882();
            }
            if (entry.enabledBox == null) continue;
            entry.shortcut.enabled = entry.enabledBox.method_20372();
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        int paddingX = this.field_22789 / 10;
        int paddingY = this.field_22790 / 10;
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, paddingY / 2, 0xFFFFFF);
        int checkboxX = paddingX + 20;
        int commandX = checkboxX + 60;
        int keybindX = commandX + (int)((double)(this.field_22789 - paddingX * 2 - 8 - 20) * 0.4) + 10;
        context.method_25303(this.field_22793, "Enabled", checkboxX, 60, 0xFFFFFF);
        context.method_25303(this.field_22793, "Command", commandX, 60, 0xFFFFFF);
        context.method_25303(this.field_22793, "Keybind", keybindX, 60, 0xFFFFFF);
        context.method_25294(paddingX - 5, 75, this.scrollbarX + 8 + 5, this.listEndY + 5, Integer.MIN_VALUE);
        if (this.entries.size() > this.maxVisibleEntries) {
            this.renderScrollbar(context, mouseX, mouseY);
        }
        String countText = String.format("Entries: %d | Showing: %d-%d", this.entries.size(), this.entries.size() > 0 ? this.scrollOffset + 1 : 0, Math.min(this.scrollOffset + this.maxVisibleEntries, this.entries.size()));
        context.method_25303(this.field_22793, countText, paddingX, this.field_22790 - paddingY - 45, 0xCCCCCC);
    }

    private void renderScrollbar(class_332 context, int mouseX, int mouseY) {
        boolean isHovered;
        int totalEntries = this.entries.size();
        int scrollbarHeight = this.listEndY - 80;
        context.method_25294(this.scrollbarX, 80, this.scrollbarX + 8, this.listEndY, 0x40FFFFFF);
        float thumbRatio = (float)this.maxVisibleEntries / (float)totalEntries;
        int thumbHeight = Math.max(10, (int)((float)scrollbarHeight * thumbRatio));
        float scrollRatio = (float)this.scrollOffset / (float)(totalEntries - this.maxVisibleEntries);
        int thumbY = 80 + (int)((float)(scrollbarHeight - thumbHeight) * scrollRatio);
        boolean bl = isHovered = mouseX >= this.scrollbarX && mouseX <= this.scrollbarX + 8 && mouseY >= thumbY && mouseY <= thumbY + thumbHeight;
        int thumbColor = this.isDraggingScrollbar ? -1 : (isHovered ? -1056964609 : -2130706433);
        context.method_25294(this.scrollbarX, thumbY, this.scrollbarX + 8, thumbY + thumbHeight, thumbColor);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.listeningButton != null) {
            if (keyCode == 256) {
                this.listeningButton.entry.shortcut.keyCode = 0;
                this.listeningButton.entry.shortcut.modifiers = new HashSet<Modifier>();
            } else {
                if (this.isModifierKey(keyCode)) {
                    return true;
                }
                this.listeningButton.entry.shortcut.keyCode = keyCode;
                this.listeningButton.entry.shortcut.modifiers = new HashSet<Modifier>();
                if ((modifiers & 2) != 0) {
                    this.listeningButton.entry.shortcut.modifiers.add(Modifier.CTRL);
                }
                if ((modifiers & 4) != 0) {
                    this.listeningButton.entry.shortcut.modifiers.add(Modifier.ALT);
                }
                if ((modifiers & 1) != 0) {
                    this.listeningButton.entry.shortcut.modifiers.add(Modifier.SHIFT);
                }
            }
            this.listeningButton = null;
            return true;
        }
        if (keyCode == 265) {
            this.scroll(-1);
            return true;
        }
        if (keyCode == 264) {
            this.scroll(1);
            return true;
        }
        if (keyCode == 266) {
            this.scroll(-5);
            return true;
        }
        if (keyCode == 267) {
            this.scroll(5);
            return true;
        }
        if (keyCode == 268) {
            this.scrollOffset = 0;
            this.initializeWidgets();
            return true;
        }
        if (keyCode == 269) {
            this.scrollOffset = Math.max(0, this.entries.size() - this.maxVisibleEntries);
            this.initializeWidgets();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    private boolean isModifierKey(int keyCode) {
        return keyCode == 341 || keyCode == 345 || keyCode == 342 || keyCode == 346 || keyCode == 340 || keyCode == 344 || keyCode == 343 || keyCode == 347;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.entries.size() > this.maxVisibleEntries) {
            this.scroll(-((int)verticalAmount) * 3);
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.listeningButton != null) {
            this.listeningButton.entry.shortcut.keyCode = button + 1000;
            this.listeningButton.entry.shortcut.modifiers = new HashSet<Modifier>();
            long window = class_310.method_1551().method_22683().method_4490();
            if (GLFW.glfwGetKey((long)window, (int)341) == 1 || GLFW.glfwGetKey((long)window, (int)345) == 1) {
                this.listeningButton.entry.shortcut.modifiers.add(Modifier.CTRL);
            }
            if (GLFW.glfwGetKey((long)window, (int)342) == 1 || GLFW.glfwGetKey((long)window, (int)346) == 1) {
                this.listeningButton.entry.shortcut.modifiers.add(Modifier.ALT);
            }
            if (GLFW.glfwGetKey((long)window, (int)340) == 1 || GLFW.glfwGetKey((long)window, (int)344) == 1) {
                this.listeningButton.entry.shortcut.modifiers.add(Modifier.SHIFT);
            }
            this.listeningButton = null;
            return true;
        }
        if (button == 0 && this.entries.size() > this.maxVisibleEntries && mouseX >= (double)this.scrollbarX && mouseX <= (double)(this.scrollbarX + 8) && mouseY >= 80.0 && mouseY <= (double)this.listEndY) {
            float scrollRatio;
            int scrollbarHeight = this.listEndY - 80;
            int totalEntries = this.entries.size();
            float thumbRatio = (float)this.maxVisibleEntries / (float)totalEntries;
            int thumbHeight = Math.max(10, (int)((float)scrollbarHeight * thumbRatio));
            int thumbY = 80 + (int)((float)(scrollbarHeight - thumbHeight) * (scrollRatio = (float)this.scrollOffset / (float)(totalEntries - this.maxVisibleEntries)));
            if (mouseY >= (double)thumbY && mouseY <= (double)(thumbY + thumbHeight)) {
                this.isDraggingScrollbar = true;
                this.dragStartY = (int)mouseY;
                this.dragStartOffset = this.scrollOffset;
                return true;
            }
            this.updateEntriesFromFields();
            float clickRatio = (float)(mouseY - 80.0) / (float)scrollbarHeight;
            int newOffset = (int)(clickRatio * (float)(totalEntries - this.maxVisibleEntries));
            this.scrollOffset = class_3532.method_15340((int)newOffset, (int)0, (int)(totalEntries - this.maxVisibleEntries));
            this.initializeWidgets();
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.isDraggingScrollbar = false;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isDraggingScrollbar && this.entries.size() > this.maxVisibleEntries) {
            this.updateEntriesFromFields();
            int dragDistance = (int)mouseY - this.dragStartY;
            int scrollbarHeight = this.listEndY - 80;
            int totalEntries = this.entries.size();
            float thumbRatio = (float)this.maxVisibleEntries / (float)totalEntries;
            int thumbHeight = Math.max(10, (int)((float)scrollbarHeight * thumbRatio));
            float dragRatio = (float)dragDistance / (float)(scrollbarHeight - thumbHeight);
            int newOffset = this.dragStartOffset + (int)(dragRatio * (float)(totalEntries - this.maxVisibleEntries));
            int oldOffset = this.scrollOffset;
            this.scrollOffset = class_3532.method_15340((int)newOffset, (int)0, (int)(totalEntries - this.maxVisibleEntries));
            if (oldOffset != this.scrollOffset) {
                this.initializeWidgets();
            }
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    private void scroll(int amount) {
        if (this.entries.size() <= this.maxVisibleEntries) {
            return;
        }
        this.updateEntriesFromFields();
        int oldOffset = this.scrollOffset;
        this.scrollOffset = class_3532.method_15340((int)(this.scrollOffset + amount), (int)0, (int)(this.entries.size() - this.maxVisibleEntries));
        if (oldOffset != this.scrollOffset) {
            this.initializeWidgets();
        }
    }

    private void saveAndClose() {
        PersistentData.get().shortcuts.clear();
        for (ShortcutEntry entry : this.entries) {
            if (entry.commandField != null) {
                entry.shortcut.command = entry.commandField.method_1882();
            }
            if (entry.enabledBox != null) {
                entry.shortcut.enabled = entry.enabledBox.method_20372();
            }
            if (entry.shortcut.command.trim().isEmpty() || entry.shortcut.keyCode == 0) continue;
            PersistentData.get().shortcuts.add(entry.shortcut);
        }
        PersistentData.save();
        this.field_22787.method_1507(this.parent);
    }

    public void method_25419() {
        this.saveAndClose();
    }

    private class KeybindButton
    extends class_4185 {
        private ShortcutEntry entry;

        public KeybindButton(int x, int y, int width, int height, ShortcutEntry entry) {
            super(x, y, width, height, (class_2561)class_2561.method_43470((String)""), button -> {}, field_40754);
            this.entry = entry;
        }

        public class_2561 method_25369() {
            if (KeyShortcutsScreen.this.listeningButton == this) {
                return class_2561.method_43470((String)"Press a key...").method_27692(class_124.field_1054);
            }
            if (this.entry.shortcut.keyCode == 0) {
                return class_2561.method_43470((String)"Click to set").method_27692(class_124.field_1080);
            }
            return class_2561.method_43470((String)this.entry.shortcut.getDisplayString());
        }

        public void method_25306() {
            KeyShortcutsScreen.this.listeningButton = this;
        }

        public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            super.method_48579(context, mouseX, mouseY, delta);
            if (this.entry.shortcut.keyCode != 0 && KeyShortcutsScreen.this.listeningButton != this) {
                boolean hasConflict = false;
                for (ShortcutEntry other : KeyShortcutsScreen.this.entries) {
                    if (other == this.entry || other.shortcut.keyCode != this.entry.shortcut.keyCode || !other.shortcut.modifiers.equals(this.entry.shortcut.modifiers)) continue;
                    hasConflict = true;
                    break;
                }
                if (hasConflict) {
                    context.method_51433(KeyShortcutsScreen.this.field_22793, "!", this.method_46426() + this.method_25368() + 5, this.method_46427() + 6, 0xFF0000, false);
                }
            }
        }
    }

    private static class ShortcutEntry {
        public Shortcut shortcut;
        public class_342 commandField;
        public class_4286 enabledBox;
        public KeybindButton keybindButton;

        public ShortcutEntry(Shortcut shortcut) {
            this.shortcut = shortcut;
        }

        public boolean isEmpty() {
            return this.shortcut.command.trim().isEmpty() && this.shortcut.keyCode == 0;
        }
    }
}

