/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.hud;

import net.minecraft.class_2561;

public class HudLine {
    private final String id;
    private class_2561 content;
    private boolean enabled;
    private String groupId;
    private int order;
    private boolean clickable;
    private boolean hoverable;
    private Runnable clickAction;
    private class_2561 hoverText;
    private boolean conditionalVisibility;
    private ConditionalVisibilityProvider visibilityProvider;

    public HudLine(String id, class_2561 content) {
        this.id = id;
        this.content = content;
        this.enabled = true;
        this.order = 0;
        this.clickable = false;
        this.hoverable = false;
        this.conditionalVisibility = false;
    }

    public HudLine(String id, class_2561 content, String groupId) {
        this.id = id;
        this.content = content;
        this.enabled = true;
        this.groupId = groupId;
        this.order = 0;
        this.clickable = false;
        this.hoverable = false;
        this.conditionalVisibility = false;
    }

    public HudLine(String id, class_2561 content, String groupId, int order) {
        this.id = id;
        this.content = content;
        this.enabled = true;
        this.groupId = groupId;
        this.order = order;
        this.clickable = false;
        this.hoverable = false;
        this.conditionalVisibility = false;
    }

    public String getId() {
        return this.id;
    }

    public class_2561 getContent() {
        return this.content;
    }

    public void setContent(class_2561 content) {
        this.content = content;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public boolean hasGroup() {
        return this.groupId != null && !this.groupId.isEmpty();
    }

    public int getSortValue() {
        return this.order;
    }

    public int getDisplayWidth() {
        return 0;
    }

    public boolean isClickable() {
        return this.clickable;
    }

    public void setClickable(boolean clickable) {
        this.clickable = clickable;
    }

    public boolean isHoverable() {
        return this.hoverable;
    }

    public void setHoverable(boolean hoverable) {
        this.hoverable = hoverable;
    }

    public Runnable getClickAction() {
        return this.clickAction;
    }

    public void setClickAction(Runnable clickAction) {
        this.clickAction = clickAction;
        this.clickable = clickAction != null;
    }

    public class_2561 getHoverText() {
        return this.hoverText;
    }

    public void setHoverText(class_2561 hoverText) {
        this.hoverText = hoverText;
        this.hoverable = hoverText != null;
    }

    public void setMultilineHoverText(String ... lines) {
        if (lines == null || lines.length == 0) {
            this.setHoverText(null);
            return;
        }
        String combinedText = String.join((CharSequence)"\n", lines);
        this.setHoverText((class_2561)class_2561.method_43470((String)combinedText));
    }

    public void setHoverTextFormatted(String ... lines) {
        if (lines == null || lines.length == 0) {
            this.setHoverText(null);
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < lines.length; ++i) {
            if (i > 0) {
                sb.append("\n");
            }
            sb.append(lines[i]);
        }
        this.setHoverText((class_2561)class_2561.method_43470((String)sb.toString()));
    }

    public boolean hasConditionalVisibility() {
        return this.conditionalVisibility;
    }

    public void setConditionalVisibility(boolean conditionalVisibility) {
        this.conditionalVisibility = conditionalVisibility;
    }

    public ConditionalVisibilityProvider getVisibilityProvider() {
        return this.visibilityProvider;
    }

    public void setVisibilityProvider(ConditionalVisibilityProvider visibilityProvider) {
        this.visibilityProvider = visibilityProvider;
        this.conditionalVisibility = visibilityProvider != null;
    }

    public void onClick() {
        if (this.clickable && this.clickAction != null) {
            this.clickAction.run();
        }
    }

    public boolean shouldShow() {
        if (!this.enabled) {
            return false;
        }
        if (this.conditionalVisibility && this.visibilityProvider != null) {
            return this.visibilityProvider.shouldShow();
        }
        return true;
    }

    @FunctionalInterface
    public static interface ConditionalVisibilityProvider {
        public boolean shouldShow();
    }
}

