/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.hud;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.skyblock21.hud.EditGuiScreen;
import com.skyblock21.hud.EditHudElementScreen;
import com.skyblock21.hud.HudAmountLine;
import com.skyblock21.hud.HudElement;
import com.skyblock21.hud.HudGroup;
import com.skyblock21.hud.HudLine;
import com.skyblock21.hud.SortType;
import com.skyblock21.util.Location;
import com.skyblock21.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_465;
import net.minecraft.class_5348;

public abstract class MultiLineHudElement
extends HudElement {
    protected List<HudLine> lines = new ArrayList<HudLine>();
    protected final Map<String, HudGroup> groups = new HashMap<String, HudGroup>();
    protected int maxWidth = 0;
    protected int totalHeight = 0;
    protected HudTitle title;
    protected List<LineRenderInfo> lastRenderedLines = new ArrayList<LineRenderInfo>();

    public MultiLineHudElement(int x, int y) {
        super(x, y);
    }

    public MultiLineHudElement(int x, int y, Location location) {
        super(x, y, location);
    }

    public MultiLineHudElement(int x, int y, Location location, boolean alwaysDummy) {
        super(x, y, location, alwaysDummy);
    }

    public void setTitle(String text, int color) {
        this.title = new HudTitle(text, color, 1.0f);
        this.recalculateDimensions();
    }

    public void setTitle(String text, int color, float scale) {
        this.title = new HudTitle(text, color, scale);
        this.recalculateDimensions();
    }

    public void setTitle(String text, int color, float scale, boolean shadow) {
        this.title = new HudTitle(text, color, scale, shadow);
        this.recalculateDimensions();
    }

    public HudTitle getTitle() {
        return this.title;
    }

    public void removeTitle() {
        this.title = null;
        this.recalculateDimensions();
    }

    public void addLine(String id, class_2561 content) {
        this.lines.add(new HudLine(id, content));
        this.recalculateDimensions();
    }

    public void addClickableLine(String id, class_2561 content, Runnable clickAction) {
        HudLine line = new HudLine(id, content);
        line.setClickAction(clickAction);
        this.lines.add(line);
        this.recalculateDimensions();
    }

    public HudLine addContainerClickableLine(String id, class_2561 content, Runnable clickAction) {
        HudLine line = new HudLine(id, content);
        line.setClickAction(clickAction);
        line.setVisibilityProvider(() -> {
            class_310 client = class_310.method_1551();
            return client.field_1755 instanceof class_465 || client.field_1755 instanceof EditGuiScreen || client.field_1755 instanceof EditHudElementScreen;
        });
        this.lines.add(line);
        this.recalculateDimensions();
        return line;
    }

    public void addHoverableLine(String id, class_2561 content, class_2561 hoverText) {
        HudLine line = new HudLine(id, content);
        line.setHoverText(hoverText);
        this.lines.add(line);
        this.recalculateDimensions();
    }

    public void addHoverableLine(String id, class_2561 content, String ... hoverLines) {
        HudLine line = new HudLine(id, content);
        line.setMultilineHoverText(hoverLines);
        this.lines.add(line);
        this.recalculateDimensions();
    }

    public void addHoverableLine(String id, String groupId, class_2561 content, String ... hoverLines) {
        HudLine line = new HudLine(id, content, groupId);
        line.setMultilineHoverText(hoverLines);
        this.lines.add(line);
        this.recalculateDimensions();
    }

    public void addConditionalLine(String id, class_2561 content, HudLine.ConditionalVisibilityProvider visibilityProvider) {
        HudLine line = new HudLine(id, content);
        line.setVisibilityProvider(visibilityProvider);
        this.lines.add(line);
        this.recalculateDimensions();
    }

    public void addAmountLine(String id, String itemName, long amount) {
        this.lines.add(new HudAmountLine(id, itemName, amount));
        this.recalculateDimensions();
    }

    public void addAmountLine(String id, String itemName, long amount, String groupId) {
        this.lines.add(new HudAmountLine(id, itemName, amount, groupId));
        this.recalculateDimensions();
    }

    public void addLine(String id, class_2561 content, String groupId) {
        this.lines.add(new HudLine(id, content, groupId));
        this.recalculateDimensions();
    }

    public void addLine(String id, class_2561 content, String groupId, int order) {
        this.lines.add(new HudLine(id, content, groupId, order));
        this.recalculateDimensions();
    }

    public void createGroup(String id, String displayName, boolean alignAmounts) {
        this.groups.put(id, new HudGroup(id, displayName, 0, alignAmounts));
    }

    public void createGroup(String id, String displayName, int order, boolean alignAmounts) {
        this.groups.put(id, new HudGroup(id, displayName, order, alignAmounts));
    }

    public void setGroupSorting(String groupId, SortType sortType, boolean ascending) {
        HudGroup group = this.groups.get(groupId);
        if (group != null) {
            group.setSortType(sortType);
            group.setAscending(ascending);
            this.recalculateDimensions();
        }
    }

    public void removeLine(String id) {
        this.lines.removeIf(line -> line.getId().equals(id));
        this.recalculateDimensions();
    }

    public void updateLine(String id, class_2561 content) {
        if (this.lines.stream().noneMatch(l -> Objects.equals(l.getId(), id))) {
            this.addLine(id, content);
        }
        for (HudLine line : this.lines) {
            if (!line.getId().equals(id)) continue;
            line.setContent(content);
            this.recalculateDimensions();
            return;
        }
    }

    public void updateAmountLine(String id, String itemName, long amount) {
        if (this.lines.stream().noneMatch(l -> Objects.equals(l.getId(), id))) {
            this.addAmountLine(id, itemName, 0L);
        }
        for (HudLine line : this.lines) {
            if (!line.getId().equals(id) || !(line instanceof HudAmountLine)) continue;
            HudAmountLine amountLine = (HudAmountLine)line;
            amountLine.updateItemName(itemName);
            amountLine.updateAmount(amount);
            this.recalculateDimensions();
            return;
        }
    }

    public void updateAmountLine(String id, long amount) {
        if (this.lines.stream().noneMatch(l -> Objects.equals(l.getId(), id))) {
            this.addAmountLine(id, id, 0L);
        }
        for (HudLine line : this.lines) {
            if (!line.getId().equals(id) || !(line instanceof HudAmountLine)) continue;
            HudAmountLine amountLine = (HudAmountLine)line;
            amountLine.updateAmount(amount);
            this.recalculateDimensions();
            return;
        }
    }

    public List<HudLine> getVisibleLines() {
        Map<String, List<HudLine>> groupedLines = this.lines.stream().filter(this::isLineVisible).collect(Collectors.groupingBy(line -> line.hasGroup() ? line.getGroupId() : "ungrouped"));
        ArrayList<HudLine> sortedLines = new ArrayList<HudLine>();
        List sortedGroupIds = groupedLines.keySet().stream().sorted((a, b) -> {
            if (a.equals("ungrouped")) {
                return 1;
            }
            if (b.equals("ungrouped")) {
                return -1;
            }
            HudGroup groupA = this.groups.get(a);
            HudGroup groupB = this.groups.get(b);
            return Integer.compare(groupA != null ? groupA.getOrder() : 0, groupB != null ? groupB.getOrder() : 0);
        }).toList();
        for (String groupId : sortedGroupIds) {
            List<HudLine> groupLines = groupedLines.get(groupId);
            if (groupId.equals("ungrouped")) {
                groupLines.sort(Comparator.comparingInt(HudLine::getOrder));
            } else {
                HudGroup group = this.groups.get(groupId);
                if (group != null) {
                    groupLines.sort(group.getComparator());
                }
            }
            sortedLines.addAll(groupLines);
        }
        return sortedLines;
    }

    private boolean isLineVisible(HudLine line) {
        HudGroup group;
        if (!line.shouldShow()) {
            return false;
        }
        if (line.hasGroup() && ((group = this.groups.get(line.getGroupId())) == null || !group.isEnabled())) {
            return false;
        }
        class_310 client = class_310.method_1551();
        boolean inEditMode = client.field_1755 instanceof EditGuiScreen || client.field_1755 instanceof EditHudElementScreen;
        boolean inContainerScreen = client.field_1755 instanceof class_465;
        return !line.isClickable() || !inEditMode && inContainerScreen;
    }

    /*
     * Unable to fully structure code
     */
    protected void recalculateDimensions() {
        block10: {
            block9: {
                textRenderer = class_310.method_1551().field_1772;
                if (textRenderer == null) {
                    return;
                }
                visibleLines = this.getVisibleLines();
                this.maxWidth = 0;
                this.totalHeight = 0;
                titleHeight = 0;
                if (this.title != null) {
                    titleWidth = (int)((float)textRenderer.method_1727(this.title.getText()) * this.title.getScale());
                    this.maxWidth = Math.max(this.maxWidth, titleWidth);
                    Objects.requireNonNull(textRenderer);
                    titleHeight = (int)(9.0f * this.title.getScale()) + this.VERTICAL_SPACING;
                }
                if (!visibleLines.isEmpty()) break block9;
                if (this.title == null) {
                    this.maxWidth = 100;
                    Objects.requireNonNull(textRenderer);
                    this.totalHeight = 9;
                } else {
                    this.totalHeight = titleHeight;
                }
                break block10;
            }
            for (HudLine line : visibleLines) {
                if (line.getContent() == null) continue;
                if (!(line instanceof HudAmountLine)) ** GOTO lbl-1000
                amountLine = (HudAmountLine)line;
                if (line.hasGroup()) {
                    group = this.groups.get(line.getGroupId());
                    if (group != null && group.isAlignAmounts()) {
                        nameWidth = group.getMaxItemNameWidth(visibleLines);
                        amountWidth = textRenderer.method_1727(" x" + HudAmountLine.formatAmount(amountLine.getAmount()));
                        lineWidth = nameWidth + amountWidth + 10;
                    } else {
                        lineWidth = textRenderer.method_27525((class_5348)line.getContent());
                    }
                } else lbl-1000:
                // 2 sources

                {
                    lineWidth = textRenderer.method_27525((class_5348)line.getContent());
                }
                this.maxWidth = Math.max(this.maxWidth, lineWidth);
            }
            v0 = visibleLines.size();
            Objects.requireNonNull(textRenderer);
            this.totalHeight = titleHeight + v0 * 9 + (visibleLines.size() - 1) * this.VERTICAL_SPACING;
        }
        this.maxWidth += this.HORIZONTAL_SPACING * 2;
        this.totalHeight += this.VERTICAL_SPACING * 2;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void renderElement(class_332 context) {
        textRenderer = class_310.method_1551().field_1772;
        visibleLines = this.getVisibleLines();
        this.lastRenderedLines.clear();
        yOffset = this.VERTICAL_SPACING;
        if (this.title != null) {
            matrices = context.method_51448();
            matrices.method_22903();
            matrices.method_22905(this.title.getScale(), this.title.getScale(), 1.0f);
            if (this.title.hasShadow()) {
                context.method_25303(textRenderer, this.title.getText(), (int)((float)this.HORIZONTAL_SPACING / this.title.getScale()), (int)((float)yOffset / this.title.getScale()), this.title.getColor());
            } else {
                context.method_51433(textRenderer, this.title.getText(), (int)((float)this.HORIZONTAL_SPACING / this.title.getScale()), (int)((float)yOffset / this.title.getScale()), this.title.getColor(), false);
            }
            matrices.method_22909();
            Objects.requireNonNull(textRenderer);
            yOffset += (int)(9.0f * this.title.getScale()) + this.VERTICAL_SPACING;
        }
        for (HudLine line : visibleLines) {
            block8: {
                if (line.getContent() == null) break block8;
                v0 = textRenderer.method_27525((class_5348)line.getContent());
                Objects.requireNonNull(textRenderer);
                renderInfo = new LineRenderInfo(line, this.HORIZONTAL_SPACING, yOffset, v0, 9);
                this.lastRenderedLines.add(renderInfo);
                if (!(line instanceof HudAmountLine)) ** GOTO lbl-1000
                amountLine = (HudAmountLine)line;
                if (line.hasGroup()) {
                    group = this.groups.get(line.getGroupId());
                    if (group != null && group.isAlignAmounts()) {
                        this.renderAlignedAmountLine(context, textRenderer, amountLine, group, visibleLines, yOffset);
                    } else {
                        context.method_51439(textRenderer, line.getContent(), this.HORIZONTAL_SPACING, yOffset, 0xFFFFFF, false);
                    }
                } else lbl-1000:
                // 2 sources

                {
                    context.method_51439(textRenderer, line.getContent(), this.HORIZONTAL_SPACING, yOffset, 0xFFFFFF, false);
                }
            }
            Objects.requireNonNull(textRenderer);
            yOffset += 9 + this.VERTICAL_SPACING;
        }
    }

    private void renderAlignedAmountLine(class_332 context, class_327 textRenderer, HudAmountLine amountLine, HudGroup group, List<HudLine> visibleLines, int yOffset) {
        int maxNameWidth = group.getMaxItemNameWidth(visibleLines);
        context.method_51439(textRenderer, (class_2561)class_2561.method_43470((String)amountLine.getItemName()), this.HORIZONTAL_SPACING, yOffset, 0xFFFFFF, false);
        String amountText = "x" + HudAmountLine.formatAmount(amountLine.getAmount());
        context.method_51439(textRenderer, (class_2561)class_2561.method_43470((String)amountText), this.HORIZONTAL_SPACING + maxNameWidth + 10, yOffset, 0xFFFFFF, false);
    }

    @Override
    public boolean shouldRenderDummy() {
        class_310 client = class_310.method_1551();
        boolean inEditMode = client.field_1755 instanceof EditGuiScreen || client.field_1755 instanceof EditHudElementScreen;
        return this.alwaysRenderDummy || inEditMode && (!this.isEnabled() || !this.isAllowedInLocation(Utils.getLocation()));
    }

    @Override
    public int getWidth() {
        return this.maxWidth;
    }

    @Override
    public int getHeight() {
        return this.totalHeight;
    }

    public boolean handleClick(double mouseX, double mouseY) {
        if (!this.isEnabled()) {
            return false;
        }
        for (LineRenderInfo renderInfo : this.lastRenderedLines) {
            if (!renderInfo.line.isClickable() || !this.isMouseOverLine(mouseX, mouseY, renderInfo)) continue;
            renderInfo.line.onClick();
            return true;
        }
        return false;
    }

    public HudLine getHoveredLine(double mouseX, double mouseY) {
        if (!this.isEnabled()) {
            return null;
        }
        for (LineRenderInfo renderInfo : this.lastRenderedLines) {
            if (!renderInfo.line.isHoverable() || !this.isMouseOverLine(mouseX, mouseY, renderInfo)) continue;
            return renderInfo.line;
        }
        return null;
    }

    private boolean isMouseOverLine(double mouseX, double mouseY, LineRenderInfo renderInfo) {
        float effectiveX = this.getEffectiveX();
        float effectiveY = this.getEffectiveY();
        float effectiveScale = this.getEffectiveScale();
        float lineX = effectiveX + (float)renderInfo.x * effectiveScale;
        float lineY = effectiveY + (float)renderInfo.y * effectiveScale;
        float lineWidth = (float)renderInfo.width * effectiveScale;
        float lineHeight = (float)renderInfo.height * effectiveScale;
        return mouseX >= (double)lineX && mouseX <= (double)(lineX + lineWidth) && mouseY >= (double)lineY && mouseY <= (double)(lineY + lineHeight);
    }

    public JsonObject saveLineStates() {
        JsonObject root = new JsonObject();
        if (this.title != null) {
            JsonObject titleObj = new JsonObject();
            titleObj.addProperty("text", this.title.getText());
            titleObj.addProperty("color", (Number)this.title.getColor());
            titleObj.addProperty("scale", (Number)Float.valueOf(this.title.getScale()));
            titleObj.addProperty("shadow", Boolean.valueOf(this.title.hasShadow()));
            root.add("title", (JsonElement)titleObj);
        }
        JsonArray linesArray = new JsonArray();
        for (HudLine line : this.lines) {
            JsonObject lineObj = new JsonObject();
            lineObj.addProperty("id", line.getId());
            lineObj.addProperty("enabled", Boolean.valueOf(line.isEnabled()));
            lineObj.addProperty("order", (Number)line.getOrder());
            lineObj.addProperty("type", line.getClass().getSimpleName());
            lineObj.addProperty("clickable", Boolean.valueOf(line.isClickable()));
            lineObj.addProperty("hoverable", Boolean.valueOf(line.isHoverable()));
            if (line.hasGroup()) {
                lineObj.addProperty("groupId", line.getGroupId());
            }
            linesArray.add((JsonElement)lineObj);
        }
        root.add("lines", (JsonElement)linesArray);
        JsonArray groupsArray = new JsonArray();
        for (HudGroup group : this.groups.values()) {
            groupsArray.add((JsonElement)group.saveToJson());
        }
        root.add("groups", (JsonElement)groupsArray);
        return root;
    }

    public void loadLineStates(JsonObject data) {
        if (data == null) {
            return;
        }
        if (data.has("title")) {
            JsonObject titleObj = data.getAsJsonObject("title");
            String text = titleObj.get("text").getAsString();
            int color = titleObj.get("color").getAsInt();
            float scale = titleObj.has("scale") ? titleObj.get("scale").getAsFloat() : 1.0f;
            boolean shadow = titleObj.has("shadow") ? titleObj.get("shadow").getAsBoolean() : true;
            this.title = new HudTitle(text, color, scale, shadow);
        }
        if (data.has("groups")) {
            JsonArray groupsArray = data.getAsJsonArray("groups");
            for (JsonElement element : groupsArray) {
                JsonObject groupObj = element.getAsJsonObject();
                String groupId = groupObj.get("id").getAsString();
                HudGroup group = this.groups.get(groupId);
                if (group == null) continue;
                group.loadFromJson(groupObj);
            }
        }
        if (data.has("lines")) {
            JsonArray linesArray = data.getAsJsonArray("lines");
            for (JsonElement element : linesArray) {
                JsonObject lineObj = element.getAsJsonObject();
                String lineId = lineObj.get("id").getAsString();
                HudLine line = this.getLine(lineId);
                if (line == null) continue;
                line.setEnabled(lineObj.get("enabled").getAsBoolean());
                if (lineObj.has("order")) {
                    line.setOrder(lineObj.get("order").getAsInt());
                }
                if (!lineObj.has("groupId")) continue;
                line.setGroupId(lineObj.get("groupId").getAsString());
            }
        }
        this.recalculateDimensions();
    }

    public HudLine getLine(String id) {
        return this.lines.stream().filter(line -> line.getId().equals(id)).findFirst().orElse(null);
    }

    public void createGroup(String id, String displayName) {
        this.groups.put(id, new HudGroup(id, displayName));
    }

    public void createGroup(String id, String displayName, int order) {
        this.groups.put(id, new HudGroup(id, displayName, order));
    }

    public void toggleGroup(String groupId) {
        HudGroup group = this.groups.get(groupId);
        if (group != null) {
            group.setEnabled(!group.isEnabled());
            this.recalculateDimensions();
        }
    }

    public void setGroupEnabled(String groupId, boolean enabled) {
        HudGroup group = this.groups.get(groupId);
        if (group != null) {
            group.setEnabled(enabled);
            this.recalculateDimensions();
        }
    }

    public HudGroup getGroup(String groupId) {
        return this.groups.get(groupId);
    }

    public Collection<HudGroup> getGroups() {
        return this.groups.values();
    }

    public List<HudLine> getLines() {
        return new ArrayList<HudLine>(this.lines);
    }

    public void clearLines() {
        this.lines.clear();
        this.recalculateDimensions();
    }

    public void toggleLine(String id) {
        for (HudLine line : this.lines) {
            if (!line.getId().equals(id)) continue;
            line.setEnabled(!line.isEnabled());
            this.recalculateDimensions();
            return;
        }
    }

    public void setLineEnabled(String id, boolean enabled) {
        for (HudLine line : this.lines) {
            if (!line.getId().equals(id)) continue;
            line.setEnabled(enabled);
            this.recalculateDimensions();
            return;
        }
    }

    public static class HudTitle {
        private final String text;
        private final int color;
        private final float scale;
        private final boolean shadow;

        public HudTitle(String text, int color, float scale) {
            this(text, color, scale, true);
        }

        public HudTitle(String text, int color, float scale, boolean shadow) {
            this.text = text;
            this.color = color;
            this.scale = scale;
            this.shadow = shadow;
        }

        public String getText() {
            return this.text;
        }

        public int getColor() {
            return this.color;
        }

        public float getScale() {
            return this.scale;
        }

        public boolean hasShadow() {
            return this.shadow;
        }
    }

    private static class LineRenderInfo {
        final HudLine line;
        final int x;
        final int y;
        final int width;
        final int height;

        LineRenderInfo(HudLine line, int x, int y, int width, int height) {
            this.line = line;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }
    }
}

