/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.hud.elements;

import com.skyblock21.config.Skyblock21ConfigManager;
import com.skyblock21.config.persistent.PersistentData;
import com.skyblock21.features.foraging.GalateaTracker;
import com.skyblock21.hud.MultiLineHudElement;
import com.skyblock21.hud.SortType;
import com.skyblock21.util.Location;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class BonusGiftsTrackerElement
extends MultiLineHudElement {
    public static BonusGiftsTrackerElement INSTANCE;
    private Set<String> trackedGifts = new HashSet<String>();

    public BonusGiftsTrackerElement(int x, int y) {
        super(x, y, Location.GALATEA);
        if (INSTANCE == null) {
            INSTANCE = this;
        }
        this.setTitle("\u00a7lBonus Gifts", 0xFF55FF, 1.2f, true);
        this.createGroup("gifts", "Bonus Gifts", true);
        this.setGroupSorting("gifts", SortType.AMOUNT, false);
        this.addContainerClickableLine("reset_gifts", (class_2561)class_2561.method_43470((String)"\u00a7c[Reset Tracker]"), () -> {
            GalateaTracker.resetBonusGifts();
            this.clearGiftLines();
        }).setHoverText((class_2561)class_2561.method_43470((String)"\u00a7eReset the bonus gifts tracker"));
    }

    private void clearGiftLines() {
        this.lines.removeIf(line -> line.getGroupId() != null && line.getGroupId().equals("gifts"));
        this.trackedGifts.clear();
        this.recalculateDimensions();
    }

    public void addOrUpdateGift(String giftName, int amount) {
        String lineId = "gift_" + giftName.hashCode();
        if (this.trackedGifts.contains(giftName)) {
            this.updateAmountLine(lineId, "\u00a7d" + giftName, amount);
        } else {
            this.addAmountLine(lineId, "\u00a7d" + giftName, amount, "gifts");
            this.trackedGifts.add(giftName);
        }
    }

    @Override
    protected void onTick(class_310 client) {
        Map<String, Integer> bonusDrops = PersistentData.get().bonusDrops;
        for (Map.Entry<String, Integer> entry : bonusDrops.entrySet()) {
            String giftName = entry.getKey();
            int amount = entry.getValue();
            this.addOrUpdateGift(giftName, amount);
        }
        HashSet<String> toRemove = new HashSet<String>();
        for (String giftName : this.trackedGifts) {
            if (bonusDrops.containsKey(giftName)) continue;
            String lineId = "gift_" + giftName.hashCode();
            this.removeLine(lineId);
            toRemove.add(giftName);
        }
        this.trackedGifts.removeAll(toRemove);
        if (!toRemove.isEmpty()) {
            this.recalculateDimensions();
        }
    }

    @Override
    public boolean shouldRenderDummy() {
        return super.shouldRenderDummy() || PersistentData.get().bonusDrops.isEmpty();
    }

    @Override
    protected void renderDummy(class_332 context) {
        this.renderElement(context);
    }

    @Override
    public boolean isEnabled() {
        return Skyblock21ConfigManager.get().foraging.bonusGiftsTracker;
    }
}

