/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.util;

import java.awt.Color;

public class ColorUtil {
    public static int getColor(Colors color) {
        return switch (color.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> -1;
            case 1 -> -65536;
            case 2 -> -16711936;
            case 3 -> -16776961;
            case 4 -> -256;
            case 5 -> -16711681;
            case 6 -> -65281;
            case 7 -> 10233845;
            case 8 -> 15055103;
            case 9 -> 8069026;
            case 10 -> -16777216;
            case 11 -> -14606047;
            case 12 -> -2894893;
            case 13 -> 0x60000000;
        };
    }

    public static int getIntFromColor(Color color) {
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        return red << 16 | green << 8 | blue;
    }

    public static int applyAlpha(int color, int alpha) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        return alpha << 24 | r << 16 | g << 8 | b;
    }

    public static int interpolateColor(int color1, int color2, float factor) {
        factor = Math.max(0.0f, Math.min(1.0f, factor));
        int a1 = color1 >> 24 & 0xFF;
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int a2 = color2 >> 24 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int a = (int)((float)a1 + factor * (float)(a2 - a1));
        int r = (int)((float)r1 + factor * (float)(r2 - r1));
        int g = (int)((float)g1 + factor * (float)(g2 - g1));
        int b = (int)((float)b1 + factor * (float)(b2 - b1));
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int getRainbowColor(float time, float saturation, float brightness) {
        float hue = time % 1.0f;
        Color color = Color.getHSBColor(hue, saturation, brightness);
        return ColorUtil.getIntFromColor(color);
    }

    public static Color getColorFromInt(int color) {
        int alpha = color >> 24 & 0xFF;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        return new Color(red, green, blue, alpha);
    }

    public static enum Colors {
        WHITE,
        RED,
        GREEN,
        BLUE,
        YELLOW,
        CYAN,
        MAGENTA,
        PURPLE,
        LAVENDER,
        DARK_PURPLE,
        BLACK,
        GRAY,
        LIGHT_GRAY,
        PANEL;

    }
}

