/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.util;

import com.skyblock21.util.ColorUtil;
import me.x150.renderer.render.ExtendedDrawContext;
import me.x150.renderer.util.Color;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.joml.Vector4f;

public class Render2DUtil {
    private static final class_310 MC = class_310.method_1551();

    public static void drawRoundedRect(class_332 context, int x, int y, int width, int height, Vector4f radius, int color) {
        ExtendedDrawContext.drawRoundedRect((class_332)context, (float)x, (float)y, (float)width, (float)height, (Vector4f)radius, (Color)new Color(ColorUtil.getColorFromInt(color)));
    }

    public static void drawRoundedRectOutline(class_332 context, float x, float y, float width, float height, float radius, float lineWidth, int color) {
        int ix = (int)x;
        int iy = (int)y;
        int iWidth = (int)width;
        int iHeight = (int)height;
        int iRadius = Math.min((int)radius, Math.min(iWidth, iHeight) / 2);
        int iLineWidth = Math.max(1, (int)lineWidth);
        if (iRadius <= 0) {
            Render2DUtil.drawRectOutline(context, ix, iy, iWidth, iHeight, iLineWidth, color);
            return;
        }
        context.method_25294(ix + iRadius, iy, ix + iWidth - iRadius, iy + iLineWidth, color);
        context.method_25294(ix + iRadius, iy + iHeight - iLineWidth, ix + iWidth - iRadius, iy + iHeight, color);
        context.method_25294(ix, iy + iRadius, ix + iLineWidth, iy + iHeight - iRadius, color);
        context.method_25294(ix + iWidth - iLineWidth, iy + iRadius, ix + iWidth, iy + iHeight - iRadius, color);
        Render2DUtil.drawCornerOutline(context, ix, iy, iRadius, iLineWidth, color, CornerType.TOP_LEFT);
        Render2DUtil.drawCornerOutline(context, ix + iWidth - iRadius, iy, iRadius, iLineWidth, color, CornerType.TOP_RIGHT);
        Render2DUtil.drawCornerOutline(context, ix + iWidth - iRadius, iy + iHeight - iRadius, iRadius, iLineWidth, color, CornerType.BOTTOM_RIGHT);
        Render2DUtil.drawCornerOutline(context, ix, iy + iHeight - iRadius, iRadius, iLineWidth, color, CornerType.BOTTOM_LEFT);
    }

    private static void drawCorner(class_332 context, int x, int y, int radius, int color, CornerType corner) {
        int baseAlpha = color >> 24 & 0xFF;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        for (int py = 0; py < radius; ++py) {
            for (int px = 0; px < radius; ++px) {
                int alpha;
                float coverage = Render2DUtil.getPixelCoverage(px, py, radius, corner);
                if (!(coverage > 0.0f) || (alpha = (int)((float)baseAlpha * coverage)) <= 0) continue;
                int pixelColor = alpha << 24 | red << 16 | green << 8 | blue;
                int drawX = x + (corner == CornerType.TOP_RIGHT || corner == CornerType.BOTTOM_RIGHT ? radius - px - 1 : px);
                int drawY = y + (corner == CornerType.BOTTOM_LEFT || corner == CornerType.BOTTOM_RIGHT ? radius - py - 1 : py);
                context.method_25294(drawX, drawY, drawX + 1, drawY + 1, pixelColor);
            }
        }
    }

    private static void drawCornerOutline(class_332 context, int x, int y, int radius, int lineWidth, int color, CornerType corner) {
        int baseAlpha = color >> 24 & 0xFF;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        for (int py = 0; py < radius; ++py) {
            for (int px = 0; px < radius; ++px) {
                int alpha;
                float innerCoverage;
                float outerCoverage = Render2DUtil.getPixelCoverage(px, py, radius, corner);
                float coverage = Math.max(0.0f, outerCoverage - (innerCoverage = Render2DUtil.getPixelCoverage(px, py, radius - lineWidth, corner)));
                if (!(coverage > 0.0f) || (alpha = (int)((float)baseAlpha * coverage)) <= 0) continue;
                int pixelColor = alpha << 24 | red << 16 | green << 8 | blue;
                int drawX = x + (corner == CornerType.TOP_RIGHT || corner == CornerType.BOTTOM_RIGHT ? radius - px - 1 : px);
                int drawY = y + (corner == CornerType.BOTTOM_LEFT || corner == CornerType.BOTTOM_RIGHT ? radius - py - 1 : py);
                context.method_25294(drawX, drawY, drawX + 1, drawY + 1, pixelColor);
            }
        }
    }

    private static float getPixelCoverage(int px, int py, float radius, CornerType corner) {
        if (radius <= 0.0f) {
            return 0.0f;
        }
        float centerX = radius - 0.5f;
        float centerY = radius - 0.5f;
        int samples = 0;
        int inside = 0;
        for (int sx = 0; sx < 4; ++sx) {
            for (int sy = 0; sy < 4; ++sy) {
                float sampleX = (float)px + ((float)sx + 0.5f) / 4.0f;
                float dx = sampleX - centerX;
                float sampleY = (float)py + ((float)sy + 0.5f) / 4.0f;
                float dy = sampleY - centerY;
                float dist = (float)Math.sqrt(dx * dx + dy * dy);
                if (dist <= radius) {
                    ++inside;
                }
                ++samples;
            }
        }
        return (float)inside / (float)samples;
    }

    private static void drawRectOutline(class_332 context, int x, int y, int width, int height, int lineWidth, int color) {
        context.method_25294(x, y, x + width, y + lineWidth, color);
        context.method_25294(x, y + height - lineWidth, x + width, y + height, color);
        context.method_25294(x, y, x + lineWidth, y + height, color);
        context.method_25294(x + width - lineWidth, y, x + width, y + height, color);
    }

    public static void drawImage(class_2960 texture, int posX, int posY, int renderWidth, int renderHeight, int imageWidth, int imageHeight, class_332 context) {
        context.method_25290(class_1921::method_62277, texture, posX, posY, 0.0f, 0.0f, renderWidth, renderHeight, imageWidth, imageHeight);
    }

    public static void drawRoundedRect(class_332 context, int x, int y, int width, int height, Vector4f radius) {
        Render2DUtil.drawRoundedRect(context, x, y, width, height, radius, -1);
    }

    public static void drawRoundedRectOutline(class_332 context, float x, float y, float width, float height, float radius, float lineWidth) {
        Render2DUtil.drawRoundedRectOutline(context, x, y, width, height, radius, lineWidth, -1);
    }

    public static void drawGradientRoundedRect(class_332 context, int x, int y, int width, int height, Vector4f radius, int colorLeft, int colorRight) {
        for (int i = 0; i < width; ++i) {
            float factor = (float)i / (float)width;
            int interpolatedColor = ColorUtil.interpolateColor(colorLeft, colorRight, factor);
            Vector4f columnRadius = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
            if (i == 0) {
                columnRadius.x = radius.x;
                columnRadius.w = radius.w;
            }
            if (i == width - 1) {
                columnRadius.y = radius.y;
                columnRadius.z = radius.z;
            }
            Render2DUtil.drawRoundedRect(context, x + i, y, 1, height, columnRadius, interpolatedColor);
        }
    }

    public static void drawRect(class_332 context, float x, float y, float width, float height, int color) {
        context.method_25294((int)x, (int)y, (int)(x + width), (int)(y + height), color);
    }

    private static enum CornerType {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_RIGHT,
        BOTTOM_LEFT;

    }
}

