/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.util;

import it.unimi.dsi.fastutil.chars.CharList;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_7417;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class TextUtils {
    private static final CharList FORMAT_CODES = CharList.of((char[])new char[]{'4', 'c', '6', 'e', '2', 'a', 'b', '3', '1', '9', 'd', '5', 'f', '7', '8', '0', 'r', 'k', 'l', 'm', 'n', 'o'});
    public static final String PREFIX = "\u00a7b[SkyBlock\u00a7f21\u00a7b]\u00a77 ";

    public static String removeFormatting(class_2561 msg) {
        if (msg == null || msg.getString().isEmpty()) {
            return msg.getString();
        }
        String text = msg.getString();
        StringBuilder builder = new StringBuilder();
        boolean skipNext = false;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\u00a7') {
                skipNext = true;
                continue;
            }
            if (skipNext) {
                skipNext = FORMAT_CODES.contains(c);
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static String translateColorCodes(String text, boolean reverse) {
        if (text == null) {
            return "";
        }
        char colorChar = reverse ? (char)'&' : '\u00a7';
        char secondChar = reverse ? (char)'\u00a7' : '&';
        return text.replace(secondChar + "0", colorChar + "0").replace(secondChar + "1", colorChar + "1").replace(secondChar + "2", colorChar + "2").replace(secondChar + "3", colorChar + "3").replace(secondChar + "4", colorChar + "4").replace(secondChar + "5", colorChar + "5").replace(secondChar + "6", colorChar + "6").replace(secondChar + "7", colorChar + "7").replace(secondChar + "8", colorChar + "8").replace(secondChar + "9", colorChar + "9").replace(secondChar + "a", colorChar + "a").replace(secondChar + "b", colorChar + "b").replace(secondChar + "c", colorChar + "c").replace(secondChar + "d", colorChar + "d").replace(secondChar + "e", colorChar + "e").replace(secondChar + "f", colorChar + "f").replace(secondChar + "k", colorChar + "k").replace(secondChar + "l", colorChar + "l").replace(secondChar + "m", colorChar + "m").replace(secondChar + "n", colorChar + "n").replace(secondChar + "o", colorChar + "o").replace(secondChar + "r", colorChar + "r");
    }

    public static int parseIntWithSuffix(String str) {
        String suffix;
        Pattern pattern = Pattern.compile("^(\\d*\\.?\\d+)([kmb]?)$", 2);
        Matcher matcher = pattern.matcher(str.trim());
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid format: " + str);
        }
        double number = Double.parseDouble(matcher.group(1));
        return switch (suffix = matcher.group(2).toLowerCase()) {
            case "" -> (int)number;
            case "k" -> (int)(number * 1000.0);
            case "m" -> (int)(number * 1000000.0);
            case "b" -> (int)(number * 1.0E9);
            default -> throw new IllegalArgumentException("Unknown suffix: " + suffix);
        };
    }

    public static void addMessage(String message, boolean prefixed, boolean overlay) {
        if (class_310.method_1551().field_1724 == null) {
            return;
        }
        class_5250 text = prefixed ? class_2561.method_43470((String)PREFIX).method_10852((class_2561)class_2561.method_43470((String)message)) : class_2561.method_43470((String)message);
        class_310.method_1551().field_1724.method_7353((class_2561)text, overlay);
    }

    public static void addMessageWithCommandButton(String message, boolean prefixed, String buttonText, String command) {
        if (class_310.method_1551().field_1724 == null) {
            return;
        }
        class_5250 text = prefixed ? class_2561.method_43470((String)PREFIX).method_10852((class_2561)class_2561.method_43470((String)message)) : class_2561.method_43470((String)message);
        buttonText = Objects.equals(buttonText, "") ? "[Click here]" : "[" + (String)buttonText + "]";
        text.method_10852((class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43470((String)buttonText).method_10862(class_2583.field_24360.method_10977(class_124.field_1060).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)command))).method_10958((class_2558)new class_2558.class_10609(command)))));
        class_310.method_1551().field_1724.method_7353((class_2561)text, false);
    }

    public static class_5250 fromLegacy(@NotNull String legacy) {
        class_5250 newText = class_2561.method_43473();
        StringBuilder builder = new StringBuilder();
        class_124 formatting = null;
        boolean bold = false;
        boolean italic = false;
        boolean underline = false;
        boolean strikethrough = false;
        boolean obfuscated = false;
        for (int i = 0; i < legacy.length(); ++i) {
            if (i != 0 && legacy.charAt(i - 1) == '\u00a7' && FORMAT_CODES.contains(Character.toLowerCase(legacy.charAt(i))) && !builder.isEmpty()) {
                newText.method_10852((class_2561)class_2561.method_43470((String)builder.toString()).method_10862(class_2583.field_24360.method_10977(formatting).method_10982(Boolean.valueOf(bold)).method_10978(Boolean.valueOf(italic)).method_30938(Boolean.valueOf(underline)).method_36140(Boolean.valueOf(strikethrough)).method_36141(Boolean.valueOf(obfuscated))));
                builder.delete(0, builder.length());
                formatting = null;
                bold = false;
                italic = false;
                underline = false;
                strikethrough = false;
                obfuscated = false;
            }
            if (i != 0 && legacy.charAt(i - 1) == '\u00a7') {
                class_124 fmt = class_124.method_544((char)legacy.charAt(i));
                switch (fmt) {
                    case field_1067: {
                        bold = true;
                        break;
                    }
                    case field_1056: {
                        italic = true;
                        break;
                    }
                    case field_1073: {
                        underline = true;
                        break;
                    }
                    case field_1055: {
                        strikethrough = true;
                        break;
                    }
                    case field_1051: {
                        obfuscated = true;
                        break;
                    }
                    default: {
                        formatting = fmt;
                        break;
                    }
                }
                continue;
            }
            if (legacy.charAt(i) != '\u00a7' && (i == 0 || i != 0 && legacy.charAt(i - 1) != '\u00a7')) {
                builder.append(legacy.charAt(i));
            }
            if (i != legacy.length() - 1) continue;
            newText.method_10852((class_2561)class_2561.method_43470((String)builder.toString()).method_10862(class_2583.field_24360.method_10977(formatting).method_10982(Boolean.valueOf(bold)).method_10978(Boolean.valueOf(italic)).method_30938(Boolean.valueOf(underline)).method_36140(Boolean.valueOf(strikethrough)).method_36141(Boolean.valueOf(obfuscated))));
        }
        return newText;
    }

    public static String toLegacy(@NotNull class_2561 text) {
        StringBuilder formattedText = new StringBuilder();
        text.method_27658((style, s) -> {
            String colorName;
            if (style.method_10973() != null && (colorName = style.method_10973().method_27721()) != null) {
                switch (colorName) {
                    case "gold": {
                        formattedText.append("\u00a76");
                        break;
                    }
                    case "red": {
                        formattedText.append("\u00a7c");
                        break;
                    }
                    case "blue": {
                        formattedText.append("\u00a79");
                        break;
                    }
                    case "green": {
                        formattedText.append("\u00a7a");
                        break;
                    }
                    case "yellow": {
                        formattedText.append("\u00a7e");
                        break;
                    }
                    case "white": {
                        formattedText.append("\u00a7f");
                        break;
                    }
                    case "dark_red": {
                        formattedText.append("\u00a74");
                        break;
                    }
                    case "dark_blue": {
                        formattedText.append("\u00a71");
                        break;
                    }
                    case "dark_green": {
                        formattedText.append("\u00a72");
                        break;
                    }
                    case "dark_aqua": {
                        formattedText.append("\u00a73");
                        break;
                    }
                    case "dark_gray": {
                        formattedText.append("\u00a78");
                        break;
                    }
                    case "black": {
                        formattedText.append("\u00a70");
                        break;
                    }
                    case "dark_purple": {
                        formattedText.append("\u00a75");
                        break;
                    }
                    case "light_purple": {
                        formattedText.append("\u00a7d");
                        break;
                    }
                    case "gray": {
                        formattedText.append("\u00a77");
                        break;
                    }
                    case "reset": {
                        formattedText.append("\u00a7r");
                    }
                }
            }
            if (style.method_10984()) {
                formattedText.append("\u00a7l");
            }
            if (style.method_10966()) {
                formattedText.append("\u00a7o");
            }
            if (style.method_10965()) {
                formattedText.append("\u00a7n");
            }
            if (style.method_10986()) {
                formattedText.append("\u00a7m");
            }
            if (style.method_10987()) {
                formattedText.append("\u00a7k");
            }
            formattedText.append(s);
            return Optional.empty();
        }, class_2583.field_24360);
        return formattedText.toString();
    }

    public static class_2561 stylizeAndReplace(@NotNull class_2561 text, @NotNull class_2583 baseStyle, @NotNull String textToStylize, @NotNull class_2583 newStyle, @NotNull String[] replaceableText, @NotNull String replacementRegex, @NotNull String replacementText, int replacementMatches) {
        String stringForm = text.getString();
        if (Arrays.stream(replaceableText).anyMatch(stringForm::contains)) {
            List textComponents = text.method_10855();
            int textComponentCount = textComponents.size();
            class_5250 newText = class_2561.method_43473().method_10862(baseStyle);
            int replacementsMatched = 0;
            for (int i = 0; i < textComponentCount; ++i) {
                String componentString = ((class_2561)textComponents.get(i)).getString();
                if (componentString.contains(textToStylize) && replacementsMatched < replacementMatches) {
                    newText.method_10852((class_2561)class_2561.method_43470((String)componentString).method_10862(newStyle));
                    ++replacementsMatched;
                    continue;
                }
                if (Arrays.stream(replaceableText).anyMatch(componentString::contains)) {
                    if (replacementText.isEmpty()) continue;
                    class_2583 componentStyle = ((class_2561)textComponents.get(i)).method_10866();
                    newText.method_10852((class_2561)class_2561.method_43470((String)componentString.replaceAll(replacementRegex, replacementText)).method_10862(componentStyle));
                    continue;
                }
                newText.method_10852((class_2561)textComponents.get(i));
            }
            return newText;
        }
        return text;
    }

    public static class_2561 stylize(@NotNull class_2561 text, @NotNull class_2583 baseStyle, @NotNull String textToStylize, @NotNull class_2583 newStyle, int matches) {
        String stringForm = text.getString();
        if (stringForm.contains(textToStylize)) {
            List textComponents = text.method_10855();
            int textComponentCount = textComponents.size();
            class_5250 newText = class_2561.method_43473().method_10862(baseStyle);
            int partsMatched = 0;
            for (int i = 0; i < textComponentCount; ++i) {
                String componentString = ((class_2561)textComponents.get(i)).getString();
                if (componentString.contains(textToStylize) && partsMatched < matches) {
                    newText.method_10852((class_2561)class_2561.method_43470((String)componentString).method_10862(newStyle));
                    ++partsMatched;
                    continue;
                }
                newText.method_10852((class_2561)textComponents.get(i));
            }
            return newText;
        }
        return text;
    }

    public static class_5250 rainbowify(@NotNull String text) {
        class_5250 newText = class_2561.method_43473();
        float textLength = text.length();
        float next = Math.nextDown(1.0f) * textLength;
        newText.method_10852((class_2561)class_2561.method_43470((String)String.valueOf(text.charAt(0))).method_54663(Color.getHSBColor(Math.nextDown(1.0f), 1.0f, 1.0f).getRGB()));
        int i = 1;
        while ((float)i < textLength) {
            float i2 = i;
            newText.method_10852((class_2561)class_2561.method_43470((String)String.valueOf(text.charAt(i))).method_54663(Color.getHSBColor(i2 / next, 1.0f, 1.0f).getRGB()));
            ++i;
        }
        return newText;
    }

    public static class_5250 progressivelyRainbowify(@NotNull String text, int totalTextLength, int positionLeftOffAt) {
        class_5250 newText = class_2561.method_43473();
        float next = Math.nextDown(1.0f) * (float)totalTextLength;
        newText.method_10852((class_2561)class_2561.method_43470((String)String.valueOf(text.charAt(0))).method_54663(Color.getHSBColor((float)positionLeftOffAt / next, 1.0f, 1.0f).getRGB()));
        for (int i = 1; i < text.length(); ++i) {
            float i2 = i + positionLeftOffAt;
            newText.method_10852((class_2561)class_2561.method_43470((String)String.valueOf(text.charAt(i))).method_54663(Color.getHSBColor(i2 / next, 1.0f, 1.0f).getRGB()));
        }
        return newText;
    }

    public static class_5481 replaceInOrdered(class_5481 orderedText, String wantedWord, class_2561 replacementText) {
        class_5250 text = class_2561.method_43473();
        orderedText.accept((index, style, codePoint) -> {
            text.method_10852((class_2561)class_2561.method_43470((String)Character.toString(codePoint)).method_10862(style));
            return true;
        });
        String stringified = text.getString();
        int startIndex = stringified.indexOf(wantedWord);
        int endIndex = startIndex + wantedWord.length();
        if (startIndex == -1) {
            return orderedText;
        }
        List textComponents = text.method_10855();
        textComponents.set(startIndex, replacementText);
        for (int i = endIndex - 1; i >= startIndex + 1; --i) {
            textComponents.remove(i);
        }
        return text.method_30937();
    }

    public static class_5481 replaceMultipleInOrdered(class_5481 orderedText, String wantedWord, class_2561 replacementText) {
        boolean occurs;
        class_5250 text = class_2561.method_43473();
        orderedText.accept((index, style, codePoint) -> {
            text.method_10852((class_2561)class_2561.method_43470((String)Character.toString(codePoint)).method_10862(style));
            return true;
        });
        String stringified = text.getString();
        boolean bl = occurs = stringified.indexOf(wantedWord) != -1;
        if (!occurs) {
            return orderedText;
        }
        int occurrences = StringUtils.countMatches((CharSequence)stringified, (CharSequence)wantedWord);
        class_5250 newText = text;
        int indexFrom = 0;
        for (int i = 0; i < occurrences; ++i) {
            String currentString = newText.getString();
            int startIndex = currentString.indexOf(wantedWord, indexFrom);
            int endIndex = startIndex + wantedWord.length();
            if (startIndex == -1) break;
            List textComponents = newText.method_10855();
            textComponents.set(startIndex, replacementText);
            for (int i2 = endIndex - 1; i2 >= startIndex + 1; --i2) {
                textComponents.remove(i2);
            }
            newText = TextUtils.deconstructComponents((class_2561)newText);
            int lengthDiff = newText.getString().length() - currentString.length();
            indexFrom = endIndex + lengthDiff;
        }
        return newText.method_30937();
    }

    public static class_5250 deconstructComponents(class_2561 text) {
        List currentComponents = text.method_10855();
        class_5250 newText = class_2561.method_43473();
        List newComponents = newText.method_10855();
        for (int i = 0; i < currentComponents.size(); ++i) {
            class_2561 current = (class_2561)currentComponents.get(i);
            String currentString = current.getString();
            if (currentString.length() <= 1) {
                newComponents.add(current);
                continue;
            }
            current.method_30937().accept((index, style, codePoint) -> {
                newComponents.add(class_2561.method_43470((String)Character.toString(codePoint)).method_10862(style));
                return true;
            });
        }
        return newText;
    }

    public static class_5250 deconstructAllComponents(class_2561 text) {
        List currentComponents = text.method_10855();
        class_5250 newText = class_2561.method_43473();
        List newComponents = newText.method_10855();
        text.method_30937().accept((index, style, codePoint) -> {
            newComponents.add(class_2561.method_43470((String)Character.toString(codePoint)).method_10862(style));
            return true;
        });
        for (int i = 0; i < currentComponents.size(); ++i) {
            class_2561 current = (class_2561)currentComponents.get(i);
            String currentString = current.getString();
            if (currentString.length() <= 1) {
                newComponents.add(current);
                continue;
            }
            current.method_30937().accept((index, style, codePoint) -> {
                newComponents.add(class_2561.method_43470((String)Character.toString(codePoint)).method_10862(style));
                return true;
            });
        }
        return newText;
    }

    public static class_5481 replaceMultipleEntriesInOrdered(class_5481 orderedText, Object2ObjectLinkedOpenHashMap<String, class_2561> replacements) {
        class_5250 text = class_2561.method_43473();
        orderedText.accept((index, style, codePoint) -> {
            text.method_10852((class_2561)class_2561.method_43470((String)Character.toString(codePoint)).method_10862(style));
            return true;
        });
        String stringified = text.getString();
        class_5250 newText = text;
        if (stringified.length() != text.method_10855().size()) {
            return orderedText;
        }
        block0: for (Map.Entry entry : replacements.entrySet()) {
            boolean occurs;
            String wantedWord = (String)entry.getKey();
            class_2561 replacementText = (class_2561)entry.getValue();
            boolean bl = occurs = stringified.indexOf(wantedWord) != -1;
            if (!occurs) continue;
            int occurrences = StringUtils.countMatches((CharSequence)stringified, (CharSequence)wantedWord);
            int indexFrom = 0;
            for (int i = 0; i < occurrences; ++i) {
                String currentString = newText.getString();
                int startIndex = currentString.indexOf(wantedWord, indexFrom);
                int endIndex = startIndex + wantedWord.length();
                if (startIndex == -1) continue block0;
                List textComponents = newText.method_10855();
                textComponents.set(startIndex, replacementText);
                for (int i2 = endIndex - 1; i2 >= startIndex + 1; --i2) {
                    textComponents.remove(i2);
                }
                newText = TextUtils.deconstructComponents((class_2561)newText);
                int lengthDiff = newText.getString().length() - currentString.length();
                indexFrom = endIndex + lengthDiff;
            }
        }
        return newText.equals((Object)text) ? orderedText : newText.method_30937();
    }

    public static class_5250 recursiveCopy(class_2561 original) {
        class_5250 newText = class_5250.method_43477((class_7417)original.method_10851()).method_10862(original.method_10866());
        ((ArrayList)newText.method_10855()).ensureCapacity(original.method_10855().size());
        for (class_2561 sibling : original.method_10855()) {
            newText.method_10855().add(TextUtils.recursiveCopy(sibling));
        }
        return newText;
    }

    public static class_5250 withContent(class_2561 original, String newContent) {
        class_5250 newText = class_2561.method_43470((String)newContent).method_10862(original.method_10866());
        newText.method_10855().addAll(original.method_10855());
        return newText;
    }
}

