/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.util.dev;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.skyblock21.Skyblock21;
import com.skyblock21.events.SkyblockEvents;
import com.skyblock21.util.TextUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_156;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_310;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public class AutoUpdater {
    private static final String REPO = "sme6en/Skyblock21";
    private static final String API_URL = "https://api.github.com/repos/sme6en/Skyblock21/releases/latest";
    private static final Path MODS_FOLDER = FabricLoader.getInstance().getGameDir().resolve("mods");
    private static final Pattern SKYBLOCK21_JAR_PATTERN = Pattern.compile("skyblock21-(.+)\\.jar", 2);
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private static ScheduledFuture<?> updateCheckTask;
    public static String latestAvailableVersion;
    public static final Set<String> downloadedVersions;
    private static volatile boolean isCheckingForUpdates;
    private static File currentModFile;
    private static volatile boolean cleanupSetup;

    public static void initialize() {
        try {
            currentModFile = new File(Skyblock21.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
            Skyblock21.LOGGER.info("Current mod file: {}", (Object)currentModFile.getAbsolutePath());
        }
        catch (Exception e) {
            Skyblock21.LOGGER.error("Failed to get current mod file path", (Throwable)e);
        }
        ClientLifecycleEvents.CLIENT_STOPPING.register(client -> AutoUpdater.shutdown());
        SkyblockEvents.JOIN.register(() -> {
            if (!downloadedVersions.isEmpty()) {
                CompletableFuture.runAsync(() -> {
                    try {
                        Thread.sleep(3000L);
                        if (!"".equals(latestAvailableVersion)) {
                            AutoUpdater.showChatNotification(latestAvailableVersion);
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                });
            }
        });
        AutoUpdater.registerCommands();
        AutoUpdater.checkForUpdateAsync(true);
        AutoUpdater.startPeriodicUpdateCheck();
        AutoUpdater.cleanupOldModFilesOnStartup();
    }

    private static void registerCommands() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"restart_skyblock21").executes(context -> {
                class_310 client = class_310.method_1551();
                if (client.field_1724 != null) {
                    TextUtils.addMessage("\u00a7aRestarting game to apply update...", true, false);
                    CompletableFuture.runAsync(() -> {
                        try {
                            Thread.sleep(1500L);
                            client.execute(() -> ((class_310)client).method_1592());
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    });
                }
                return 1;
            }));
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"dismiss_skyblock21").executes(context -> {
                class_310 client = class_310.method_1551();
                if (client.field_1724 != null) {
                    TextUtils.addMessage("\u00a77Update notification dismissed. You can restart later to apply the update.", true, false);
                    Skyblock21.LOGGER.info("User dismissed update notification");
                }
                return 1;
            }));
        });
    }

    private static void startPeriodicUpdateCheck() {
        if (updateCheckTask != null && !updateCheckTask.isDone()) {
            updateCheckTask.cancel(false);
        }
        int intervalMinutes = 60;
        updateCheckTask = scheduler.scheduleWithFixedDelay(() -> AutoUpdater.checkForUpdateAsync(false), intervalMinutes, intervalMinutes, TimeUnit.MINUTES);
    }

    public static void checkForUpdateAsync(boolean isInitialCheck) {
        if (isCheckingForUpdates) {
            Skyblock21.LOGGER.debug("Update check already in progress, skipping");
            return;
        }
        CompletableFuture.runAsync(() -> {
            try {
                AutoUpdater.checkForUpdate(isInitialCheck);
            }
            catch (Exception e) {
                Skyblock21.LOGGER.error("Failed to check for updates", (Throwable)e);
            }
        });
    }

    public static void checkForUpdateAsyncAndRestart() {
        if (isCheckingForUpdates) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            try {
                AutoUpdater.checkForUpdate(false);
                if (!latestAvailableVersion.isEmpty()) {
                    class_310 client = class_310.method_1551();
                    TextUtils.addMessage("\u00a7aUpdate downloaded! Restarting game in 3s to apply the update...", true, false);
                    Thread.sleep(3000L);
                    client.execute(() -> ((class_310)client).method_1592());
                } else {
                    TextUtils.addMessage("\u00a7eYou are already on the latest version!", true, false);
                }
            }
            catch (Exception e) {
                Skyblock21.LOGGER.error("Failed to check for updates", (Throwable)e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkForUpdate(boolean isInitialCheck) {
        if (isCheckingForUpdates) {
            return;
        }
        isCheckingForUpdates = true;
        try {
            if (isInitialCheck) {
                Skyblock21.LOGGER.info("Checking for updates on client startup...");
            } else {
                Skyblock21.LOGGER.info("Performing periodic update check...");
            }
            String response = AutoUpdater.fetch(API_URL);
            JsonObject json = JsonParser.parseString((String)response).getAsJsonObject();
            String latestVersion = json.get("tag_name").getAsString().replaceFirst("^v", "");
            if (AutoUpdater.isNewerVersion(latestVersion, "1.3.1") && !AutoUpdater.isVersionDownloaded(latestVersion)) {
                Skyblock21.LOGGER.info("New version found: {} (current: {})", (Object)latestVersion, (Object)"1.3.1");
                JsonArray assets = json.getAsJsonArray("assets");
                String downloadUrl = null;
                for (JsonElement assetElem : assets) {
                    JsonObject asset = assetElem.getAsJsonObject();
                    String url = asset.get("browser_download_url").getAsString();
                    if (!url.endsWith(".jar")) continue;
                    downloadUrl = url;
                    break;
                }
                if (downloadUrl != null) {
                    latestAvailableVersion = latestVersion;
                    AutoUpdater.downloadUpdate(downloadUrl, latestVersion);
                    AutoUpdater.showUpdateNotification(latestVersion, isInitialCheck);
                } else {
                    Skyblock21.LOGGER.warn("No .jar asset found in release");
                }
            } else if (AutoUpdater.isVersionDownloaded(latestVersion)) {
                Skyblock21.LOGGER.debug("Version {} already downloaded, skipping", (Object)latestVersion);
            } else if (isInitialCheck) {
                Skyblock21.LOGGER.info("You're on the latest version: {}", (Object)"1.3.1");
            }
        }
        catch (Exception e) {
            Skyblock21.LOGGER.error("Failed to check for updates", (Throwable)e);
        }
        finally {
            isCheckingForUpdates = false;
        }
    }

    private static boolean isVersionDownloaded(String version) {
        if (downloadedVersions.contains(version)) {
            return true;
        }
        Path expectedPath = MODS_FOLDER.resolve("skyblock21-" + version + ".jar");
        boolean exists = Files.exists(expectedPath, new LinkOption[0]);
        if (exists) {
            downloadedVersions.add(version);
        }
        return exists;
    }

    private static void downloadUpdate(String urlStr, String version) throws IOException {
        Skyblock21.LOGGER.info("Downloading update version {}...", (Object)version);
        String filename = "skyblock21-" + version + ".jar";
        Path downloadPath = MODS_FOLDER.resolve(filename);
        try (InputStream in = new URL(urlStr).openStream();){
            Files.copy(in, downloadPath, StandardCopyOption.REPLACE_EXISTING);
        }
        downloadedVersions.add(version);
        AutoUpdater.setupCleanupOnShutdown();
        Skyblock21.LOGGER.info("Update downloaded successfully: {}", (Object)downloadPath);
    }

    private static void setupCleanupOnShutdown() {
        if (cleanupSetup) {
            return;
        }
        cleanupSetup = true;
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                AutoUpdater.cleanupOldModFilesOnShutdown();
            }
            catch (Exception e) {
                Skyblock21.LOGGER.error("Failed to cleanup old mod files on shutdown", (Throwable)e);
            }
        }));
    }

    private static void cleanupOldModFilesOnStartup() {
        try {
            List<Path> skyblockJars = AutoUpdater.findAllSkyblockJars();
            String currentVersion = "1.3.1";
            Skyblock21.LOGGER.info("Found {} Skyblock21 jar files in mods folder", (Object)skyblockJars.size());
            for (Path jar : skyblockJars) {
                String version = AutoUpdater.extractVersionFromFileName(jar.getFileName().toString());
                if (version == null || version.equals(currentVersion)) continue;
                try {
                    Files.deleteIfExists(jar);
                    Skyblock21.LOGGER.info("Cleaned up old mod file from previous session: {}", (Object)jar.getFileName());
                }
                catch (IOException e) {
                    Skyblock21.LOGGER.warn("Failed to delete old mod file: {}", (Object)jar, (Object)e);
                }
            }
        }
        catch (Exception e) {
            Skyblock21.LOGGER.error("Failed to cleanup old mod files on startup", (Throwable)e);
        }
    }

    private static void cleanupOldModFilesOnShutdown() {
        try {
            List<Path> skyblockJars = AutoUpdater.findAllSkyblockJars();
            if (skyblockJars.isEmpty()) {
                return;
            }
            String latestVersion = AutoUpdater.findLatestVersionFromJars(skyblockJars);
            if (latestVersion == null) {
                Skyblock21.LOGGER.warn("Could not determine latest version from jar files");
                return;
            }
            Skyblock21.LOGGER.info("Latest version found: {}, cleaning up older versions", (Object)latestVersion);
            ArrayList<Path> jarsToDelete = new ArrayList<Path>();
            for (Path jar : skyblockJars) {
                String version = AutoUpdater.extractVersionFromFileName(jar.getFileName().toString());
                if (version == null || version.equals(latestVersion)) continue;
                jarsToDelete.add(jar);
            }
            if (jarsToDelete.isEmpty()) {
                Skyblock21.LOGGER.info("No old versions to clean up");
                return;
            }
            if (class_156.method_668() != class_156.class_158.field_1133) {
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    for (Path jar : jarsToDelete) {
                        try {
                            Files.deleteIfExists(jar);
                            Skyblock21.LOGGER.info("Deleted old version: {}", (Object)jar.getFileName());
                        }
                        catch (IOException e) {
                            Skyblock21.LOGGER.warn("Failed to delete old version: {}", (Object)jar, (Object)e);
                        }
                    }
                }));
                Skyblock21.LOGGER.info("Scheduled {} old jar files for deletion on shutdown", (Object)jarsToDelete.size());
            } else {
                AutoUpdater.createWindowsCleanupScript(jarsToDelete);
            }
        }
        catch (Exception e) {
            Skyblock21.LOGGER.error("Failed to cleanup old mod files on shutdown", (Throwable)e);
        }
    }

    private static List<Path> findAllSkyblockJars() throws IOException {
        if (!Files.exists(MODS_FOLDER, new LinkOption[0])) {
            return Collections.emptyList();
        }
        return Files.list(MODS_FOLDER).filter(path -> {
            String fileName = path.getFileName().toString().toLowerCase();
            return fileName.startsWith("skyblock21") && fileName.endsWith(".jar");
        }).collect(Collectors.toList());
    }

    private static String extractVersionFromFileName(String fileName) {
        Matcher matcher = SKYBLOCK21_JAR_PATTERN.matcher(fileName);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    private static String findLatestVersionFromJars(List<Path> jarFiles) {
        String latestVersion = null;
        for (Path jar : jarFiles) {
            String version = AutoUpdater.extractVersionFromFileName(jar.getFileName().toString());
            if (version == null || latestVersion != null && !AutoUpdater.isNewerVersion(version, latestVersion)) continue;
            latestVersion = version;
        }
        return latestVersion;
    }

    private static void createWindowsCleanupScript(List<Path> filesToDelete) {
        try {
            String tempDir = System.getProperty("java.io.tmpdir");
            File deleter = new File(tempDir, "skyblock21_cleanup.bat");
            StringBuilder deleterProgram = new StringBuilder();
            deleterProgram.append("@echo off\n");
            deleterProgram.append("timeout /t 3 /nobreak >nul\n\n");
            for (Path jarFile : filesToDelete) {
                String jarPath = jarFile.toAbsolutePath().toString();
                String jarName = jarFile.getFileName().toString();
                deleterProgram.append("rem Processing: ").append(jarName).append("\n");
                deleterProgram.append(":TestFile_").append(jarName.replace(".", "_").replace("-", "_")).append("\n");
                deleterProgram.append("if not exist \"").append(jarPath).append("\" goto FileGone_").append(jarName.replace(".", "_").replace("-", "_")).append("\n");
                deleterProgram.append("REN \"").append(jarPath).append("\" \"").append(jarName).append("\" 2>nul\n");
                deleterProgram.append("IF ERRORLEVEL 1 (\n");
                deleterProgram.append("    timeout /t 1 /nobreak >nul\n");
                deleterProgram.append("    goto TestFile_").append(jarName.replace(".", "_").replace("-", "_")).append("\n");
                deleterProgram.append(")\n");
                deleterProgram.append("ECHO Deleting old version: ").append(jarName).append("\n");
                deleterProgram.append("DEL /F /Q \"").append(jarPath).append("\" >nul 2>&1\n");
                deleterProgram.append("if exist \"").append(jarPath).append("\" (\n");
                deleterProgram.append("    ECHO Failed to delete ").append(jarName).append("\n");
                deleterProgram.append(") else (\n");
                deleterProgram.append("    ECHO Successfully deleted ").append(jarName).append("\n");
                deleterProgram.append(")\n");
                deleterProgram.append(":FileGone_").append(jarName.replace(".", "_").replace("-", "_")).append("\n");
                deleterProgram.append("\n");
            }
            deleterProgram.append("ECHO Cleanup completed\n");
            deleterProgram.append("EXIT\n");
            String finalScript = deleterProgram.toString();
            Files.writeString(deleter.toPath(), (CharSequence)finalScript, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            ProcessBuilder pb = new ProcessBuilder("cmd", "/c", deleter.getAbsolutePath());
            pb.redirectOutput(ProcessBuilder.Redirect.DISCARD);
            pb.redirectError(ProcessBuilder.Redirect.DISCARD);
            pb.start();
        }
        catch (IOException e) {
            Skyblock21.LOGGER.error("Failed to create Windows cleanup script", (Throwable)e);
        }
    }

    private static void showUpdateNotification(String newVersion, boolean isInitialCheck) {
        class_310 client = class_310.method_1551();
        if (client != null && client.field_1724 != null) {
            AutoUpdater.showChatNotification(newVersion);
        } else {
            Skyblock21.LOGGER.info("Update {} available! Restart the game to apply the update.", (Object)newVersion);
        }
    }

    private static void showChatNotification(String newVersion) {
        class_310 client = class_310.method_1551();
        if (client != null && client.field_1724 != null) {
            client.execute(() -> {
                try {
                    int totalUpdates = downloadedVersions.size();
                    String updateText = totalUpdates > 1 ? String.format("\u00a73\u00a7l[Skyblock21] \u00a7r\u00a7b%d Updates Available!", totalUpdates) : "\u00a73\u00a7l[Skyblock21] \u00a7r\u00a7bUpdate Available!";
                    class_5250 updateMessage = class_2561.method_43470((String)updateText).method_27694(style -> style.method_10982(Boolean.valueOf(true)));
                    class_5250 versionMessage = class_2561.method_43470((String)String.format("\u00a77Current: \u00a7f%s \u00a78\u2192 \u00a77Latest: \u00a7a%s", "1.3.1", newVersion));
                    class_5250 restartButton = class_2561.method_43470((String)"\u00a7a\u00a7l[RESTART NOW]").method_27694(style -> style.method_10982(Boolean.valueOf(true)).method_10958((class_2558)new class_2558.class_10609("/restart_skyblock21")).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"\u00a7eClick to restart the game and apply the update"))));
                    class_5250 laterButton = class_2561.method_43470((String)"\u00a7c\u00a7l[LATER]").method_27694(style -> style.method_10982(Boolean.valueOf(true)).method_10958((class_2558)new class_2558.class_10609("/dismiss_skyblock21")).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"\u00a7eClick to dismiss this notification"))));
                    class_5250 infoButton = class_2561.method_43470((String)"\u00a7b\u00a7l[INFO]").method_27694(style -> style.method_10982(Boolean.valueOf(true)).method_10958((class_2558)new class_2558.class_10608(URI.create("https://github.com/sme6en/Skyblock21/releases/latest"))).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"\u00a7eClick to view release notes on GitHub"))));
                    class_5250 buttonRow = class_2561.method_43470((String)"").method_10852((class_2561)restartButton).method_10852((class_2561)class_2561.method_43470((String)" \u00a77| ")).method_10852((class_2561)laterButton).method_10852((class_2561)class_2561.method_43470((String)" \u00a77| ")).method_10852((class_2561)infoButton);
                    client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a77\u00a7m                                                    "), false);
                    client.field_1724.method_7353((class_2561)updateMessage, false);
                    client.field_1724.method_7353((class_2561)versionMessage, false);
                    if (totalUpdates > 1) {
                        client.field_1724.method_7353((class_2561)class_2561.method_43470((String)String.format("\u00a77%d updates downloaded! Restart to apply all updates.", totalUpdates)), false);
                    } else {
                        client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a77Update downloaded! Choose an option:"), false);
                    }
                    client.field_1724.method_7353((class_2561)buttonRow, false);
                    client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a77\u00a7m                                                    "), false);
                    Skyblock21.LOGGER.info("Update notification sent to chat");
                }
                catch (Exception e) {
                    Skyblock21.LOGGER.error("Failed to send chat notification", (Throwable)e);
                }
            });
        }
    }

    private static boolean isNewerVersion(String latest, String current) {
        try {
            String[] l = latest.split("\\.");
            String[] c = current.split("\\.");
            for (int i = 0; i < Math.max(l.length, c.length); ++i) {
                int ci;
                int li = i < l.length ? Integer.parseInt(l[i]) : 0;
                int n = ci = i < c.length ? Integer.parseInt(c[i]) : 0;
                if (li > ci) {
                    return true;
                }
                if (li >= ci) continue;
                return false;
            }
            return false;
        }
        catch (NumberFormatException e) {
            Skyblock21.LOGGER.warn("Failed to parse version numbers, falling back to string comparison");
            return !latest.equals(current);
        }
    }

    private static String findLatestDownloadedVersion() {
        if (downloadedVersions.isEmpty()) {
            return null;
        }
        String latest = null;
        for (String version : downloadedVersions) {
            if (latest != null && !AutoUpdater.isNewerVersion(version, latest)) continue;
            latest = version;
        }
        return latest;
    }

    private static String fetch(String urlStr) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)new URL(urlStr).openConnection();
        conn.setRequestProperty("User-Agent", "Skyblock21-AutoUpdater/1.0");
        conn.setConnectTimeout(10000);
        conn.setReadTimeout(10000);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
            String line;
            StringBuilder out = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                out.append(line);
            }
            String string = out.toString();
            return string;
        }
    }

    public static void shutdown() {
        if (updateCheckTask != null && !updateCheckTask.isDone()) {
            updateCheckTask.cancel(true);
        }
        scheduler.shutdown();
        try {
            if (!scheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                scheduler.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            scheduler.shutdownNow();
            Thread.currentThread().interrupt();
        }
        Skyblock21.LOGGER.info("Auto-updater shutdown complete");
    }

    static {
        latestAvailableVersion = "";
        downloadedVersions = Collections.synchronizedSet(new HashSet());
        isCheckingForUpdates = false;
        currentModFile = null;
        cleanupSetup = false;
    }
}

