/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.features.commandaliases;

import com.skyblock21.config.persistent.PersistentData;
import com.skyblock21.features.commandaliases.Alias;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4286;
import net.minecraft.class_437;

public class CommandAliasesScreen
extends class_437 {
    private final class_437 parent;
    private final List<AliasEntry> entries = new ArrayList<AliasEntry>();
    private int scrollOffset = 0;
    private final int entryHeight = 35;
    private int maxVisibleEntries;
    private final int listStartY = 100;
    private int listEndY;
    private int scrollbarX;
    private final int scrollbarWidth = 8;
    private boolean isDraggingScrollbar = false;
    private int dragStartY = 0;
    private int dragStartOffset = 0;

    public CommandAliasesScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Command Aliases"));
        this.parent = parent;
    }

    protected void method_25426() {
        int paddingX = this.field_22789 / 10;
        int paddingY = this.field_22790 / 10;
        this.listEndY = this.field_22790 - paddingY - 80;
        this.scrollbarX = this.field_22789 - paddingX - 8 - 10;
        int availableHeight = this.listEndY - 100;
        this.maxVisibleEntries = Math.max(5, availableHeight / 35);
        this.entries.clear();
        for (Alias alias : PersistentData.get().aliases) {
            this.entries.add(new AliasEntry(alias));
        }
        if (this.entries.isEmpty() || !this.entries.get(this.entries.size() - 1).isEmpty()) {
            this.entries.add(new AliasEntry(new Alias()));
        }
        this.initializeWidgets();
        int buttonY = this.field_22790 - paddingY - 25;
        int buttonWidth = 100;
        int buttonSpacing = 20;
        int totalButtonWidth = buttonWidth * 2 + buttonSpacing;
        int buttonStartX = (this.field_22789 - totalButtonWidth) / 2;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Done"), button -> this.saveAndClose()).method_46434(buttonStartX, buttonY, buttonWidth, 25).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Add New"), button -> {
            this.updateEntriesFromFields();
            this.entries.add(new AliasEntry(new Alias()));
            this.initializeWidgets();
        }).method_46434(buttonStartX + buttonWidth + buttonSpacing, buttonY, buttonWidth, 25).method_46431());
    }

    private void initializeWidgets() {
        this.method_37067();
        int paddingX = this.field_22789 / 10;
        int entryWidth = this.field_22789 - paddingX * 2 - 8 - 20;
        for (int i = 0; i < this.entries.size(); ++i) {
            if (i < this.scrollOffset || i >= this.scrollOffset + this.maxVisibleEntries) continue;
            AliasEntry entry = this.entries.get(i);
            int y = 100 + (i - this.scrollOffset) * 35;
            int checkboxX = paddingX;
            int aliasX = checkboxX + 30;
            int aliasWidth = (int)((double)entryWidth * 0.2);
            int targetX = aliasX + aliasWidth + 10;
            int targetWidth = (int)((double)entryWidth * 0.55);
            int removeX = targetX + targetWidth + 10;
            int removeWidth = 80;
            entry.enabledBox = class_4286.method_54787((class_2561)class_2561.method_43470((String)""), (class_327)this.field_22793).method_54789(checkboxX, y + 8).method_54794(entry.alias.enabled).method_54788();
            this.method_37063((class_364)entry.enabledBox);
            entry.aliasField = new class_342(this.field_22793, aliasX, y, aliasWidth, 25, (class_2561)class_2561.method_43470((String)"Alias"));
            entry.aliasField.method_1852(entry.alias.aliasCommand);
            entry.aliasField.method_1880(64);
            this.method_37063((class_364)entry.aliasField);
            entry.targetField = new class_342(this.field_22793, targetX, y, targetWidth, 25, (class_2561)class_2561.method_43470((String)"Target Command"));
            entry.targetField.method_1852(entry.alias.targetCommand);
            entry.targetField.method_1880(512);
            this.method_37063((class_364)entry.targetField);
            int index = i;
            class_4185 removeButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Remove"), button -> {
                this.updateEntriesFromFields();
                this.entries.remove(index);
                int maxOffset = Math.max(0, this.entries.size() - this.maxVisibleEntries);
                this.scrollOffset = Math.min(this.scrollOffset, maxOffset);
                this.initializeWidgets();
            }).method_46434(removeX, y, removeWidth, 25).method_46431();
            this.method_37063((class_364)removeButton);
        }
        int paddingY = this.field_22790 / 10;
        int buttonY = this.field_22790 - paddingY - 25;
        int buttonWidth = 100;
        int buttonSpacing = 20;
        int totalButtonWidth = buttonWidth * 2 + buttonSpacing;
        int buttonStartX = (this.field_22789 - totalButtonWidth) / 2;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Done"), button -> this.saveAndClose()).method_46434(buttonStartX, buttonY, buttonWidth, 25).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Add New"), button -> {
            this.updateEntriesFromFields();
            this.entries.add(new AliasEntry(new Alias()));
            this.initializeWidgets();
        }).method_46434(buttonStartX + buttonWidth + buttonSpacing, buttonY, buttonWidth, 25).method_46431());
    }

    private void updateEntriesFromFields() {
        for (AliasEntry entry : this.entries) {
            if (entry.aliasField != null) {
                entry.alias.aliasCommand = entry.aliasField.method_1882().trim();
            }
            if (entry.targetField != null) {
                entry.alias.targetCommand = entry.targetField.method_1882().trim();
            }
            if (entry.enabledBox == null) continue;
            entry.alias.enabled = entry.enabledBox.method_20372();
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        int paddingX = this.field_22789 / 10;
        int paddingY = this.field_22790 / 10;
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, paddingY / 2, 0xFFFFFF);
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"Create simple command aliases like: sb \u2192 skyblock").method_27692(class_124.field_1080), this.field_22789 / 2, paddingY / 2 + 15, 0xCCCCCC);
        int checkboxX = paddingX;
        int aliasX = checkboxX + 60;
        int targetX = aliasX + (int)((double)(this.field_22789 - paddingX * 2 - 8 - 20) * 0.2) + 10;
        context.method_25303(this.field_22793, "Enabled", checkboxX, 80, 0xFFFFFF);
        context.method_25303(this.field_22793, "Alias Command", aliasX, 80, 0xFFFFFF);
        context.method_25303(this.field_22793, "Target Command", targetX, 80, 0xFFFFFF);
        context.method_25294(paddingX - 5, 95, this.scrollbarX + 8 + 5, this.listEndY + 5, Integer.MIN_VALUE);
        if (this.entries.size() > this.maxVisibleEntries) {
            this.renderScrollbar(context, mouseX, mouseY);
        }
        String countText = String.format("Aliases: %d | Showing: %d-%d", this.entries.size(), this.entries.size() > 0 ? this.scrollOffset + 1 : 0, Math.min(this.scrollOffset + this.maxVisibleEntries, this.entries.size()));
        context.method_25303(this.field_22793, countText, paddingX, this.field_22790 - paddingY - 65, 0xCCCCCC);
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)"Examples: sb \u2192 skyblock | h \u2192 home | warp \u2192 warp hub").method_27692(class_124.field_1063), paddingX, this.field_22790 - paddingY - 50, 0x888888);
    }

    private void renderScrollbar(class_332 context, int mouseX, int mouseY) {
        boolean isHovered;
        int totalEntries = this.entries.size();
        int scrollbarHeight = this.listEndY - 100;
        context.method_25294(this.scrollbarX, 100, this.scrollbarX + 8, this.listEndY, 0x40FFFFFF);
        float thumbRatio = (float)this.maxVisibleEntries / (float)totalEntries;
        int thumbHeight = Math.max(10, (int)((float)scrollbarHeight * thumbRatio));
        float scrollRatio = (float)this.scrollOffset / (float)(totalEntries - this.maxVisibleEntries);
        int thumbY = 100 + (int)((float)(scrollbarHeight - thumbHeight) * scrollRatio);
        boolean bl = isHovered = mouseX >= this.scrollbarX && mouseX <= this.scrollbarX + 8 && mouseY >= thumbY && mouseY <= thumbY + thumbHeight;
        int thumbColor = this.isDraggingScrollbar ? -1 : (isHovered ? -1056964609 : -2130706433);
        context.method_25294(this.scrollbarX, thumbY, this.scrollbarX + 8, thumbY + thumbHeight, thumbColor);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 265) {
            this.scroll(-1);
            return true;
        }
        if (keyCode == 264) {
            this.scroll(1);
            return true;
        }
        if (keyCode == 266) {
            this.scroll(-5);
            return true;
        }
        if (keyCode == 267) {
            this.scroll(5);
            return true;
        }
        if (keyCode == 268) {
            this.scrollOffset = 0;
            this.initializeWidgets();
            return true;
        }
        if (keyCode == 269) {
            this.scrollOffset = Math.max(0, this.entries.size() - this.maxVisibleEntries);
            this.initializeWidgets();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.entries.size() > this.maxVisibleEntries) {
            this.scroll(-((int)verticalAmount) * 3);
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0 && this.entries.size() > this.maxVisibleEntries && mouseX >= (double)this.scrollbarX && mouseX <= (double)(this.scrollbarX + 8) && mouseY >= 100.0 && mouseY <= (double)this.listEndY) {
            float scrollRatio;
            int scrollbarHeight = this.listEndY - 100;
            int totalEntries = this.entries.size();
            float thumbRatio = (float)this.maxVisibleEntries / (float)totalEntries;
            int thumbHeight = Math.max(10, (int)((float)scrollbarHeight * thumbRatio));
            int thumbY = 100 + (int)((float)(scrollbarHeight - thumbHeight) * (scrollRatio = (float)this.scrollOffset / (float)(totalEntries - this.maxVisibleEntries)));
            if (mouseY >= (double)thumbY && mouseY <= (double)(thumbY + thumbHeight)) {
                this.isDraggingScrollbar = true;
                this.dragStartY = (int)mouseY;
                this.dragStartOffset = this.scrollOffset;
                return true;
            }
            this.updateEntriesFromFields();
            float clickRatio = (float)(mouseY - 100.0) / (float)scrollbarHeight;
            int newOffset = (int)(clickRatio * (float)(totalEntries - this.maxVisibleEntries));
            this.scrollOffset = class_3532.method_15340((int)newOffset, (int)0, (int)(totalEntries - this.maxVisibleEntries));
            this.initializeWidgets();
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.isDraggingScrollbar = false;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isDraggingScrollbar && this.entries.size() > this.maxVisibleEntries) {
            this.updateEntriesFromFields();
            int dragDistance = (int)mouseY - this.dragStartY;
            int scrollbarHeight = this.listEndY - 100;
            int totalEntries = this.entries.size();
            float thumbRatio = (float)this.maxVisibleEntries / (float)totalEntries;
            int thumbHeight = Math.max(10, (int)((float)scrollbarHeight * thumbRatio));
            float dragRatio = (float)dragDistance / (float)(scrollbarHeight - thumbHeight);
            int newOffset = this.dragStartOffset + (int)(dragRatio * (float)(totalEntries - this.maxVisibleEntries));
            int oldOffset = this.scrollOffset;
            this.scrollOffset = class_3532.method_15340((int)newOffset, (int)0, (int)(totalEntries - this.maxVisibleEntries));
            if (oldOffset != this.scrollOffset) {
                this.initializeWidgets();
            }
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    private void scroll(int amount) {
        if (this.entries.size() <= this.maxVisibleEntries) {
            return;
        }
        this.updateEntriesFromFields();
        int oldOffset = this.scrollOffset;
        this.scrollOffset = class_3532.method_15340((int)(this.scrollOffset + amount), (int)0, (int)(this.entries.size() - this.maxVisibleEntries));
        if (oldOffset != this.scrollOffset) {
            this.initializeWidgets();
        }
    }

    private void saveAndClose() {
        PersistentData.get().aliases.clear();
        for (AliasEntry entry : this.entries) {
            if (entry.aliasField != null) {
                entry.alias.aliasCommand = entry.aliasField.method_1882().trim();
            }
            if (entry.targetField != null) {
                entry.alias.targetCommand = entry.targetField.method_1882().trim();
            }
            if (entry.enabledBox != null) {
                entry.alias.enabled = entry.enabledBox.method_20372();
            }
            if (entry.alias.aliasCommand.trim().isEmpty() || entry.alias.targetCommand.trim().isEmpty()) continue;
            if (entry.alias.aliasCommand.startsWith("/")) {
                entry.alias.aliasCommand = entry.alias.aliasCommand.substring(1).trim();
            }
            if (entry.alias.targetCommand.startsWith("/")) {
                entry.alias.targetCommand = entry.alias.targetCommand.substring(1).trim();
            }
            PersistentData.get().aliases.add(entry.alias);
        }
        PersistentData.get().aliases.removeIf(alias -> {
            for (Alias other : PersistentData.get().aliases) {
                if (alias.equals(other) || !alias.targetCommand.equals(other.aliasCommand)) continue;
                return true;
            }
            return false;
        });
        this.field_22787.method_1507(this.parent);
    }

    public void method_25419() {
        this.saveAndClose();
    }

    private static class AliasEntry {
        public final Alias alias;
        public class_342 aliasField;
        public class_342 targetField;
        public class_4286 enabledBox;

        public AliasEntry(Alias alias) {
            this.alias = alias;
        }

        public boolean isEmpty() {
            return this.alias.aliasCommand.trim().isEmpty() && this.alias.targetCommand.trim().isEmpty();
        }
    }
}

