/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.features.foraging;

import com.skyblock21.Skyblock21;
import com.skyblock21.config.Skyblock21Config;
import com.skyblock21.config.Skyblock21ConfigManager;
import com.skyblock21.config.persistent.PersistentData;
import com.skyblock21.events.ChatEvents;
import com.skyblock21.events.SkyblockEvents;
import com.skyblock21.hud.elements.BonusGiftsTrackerElement;
import com.skyblock21.util.TextUtils;
import com.skyblock21.util.Utils;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_310;

public class GalateaTracker {
    private static long sessionStartTime = -1L;
    private static long lastActionTime = -1L;
    private static long afkStartTime = -1L;
    private static long totalAfkTime = 0L;
    private static int totalWhispers = 0;
    private static int totalForagingExp = 0;
    private static int totalForestEssence = 0;
    private static int totalHOTFExperience = 0;
    private static boolean isAfk = false;
    private static float lastYaw = 0.0f;
    private static float lastPitch = 0.0f;
    private static class_2338 lastPosition = null;
    private static double cachedWhispersPerHour = 0.0;
    private static double cachedForagingExpPerHour = 0.0;
    private static double cachedHOTFExpPerHour = 0.0;
    private static boolean insideTreeGiftMessage = false;
    private static boolean pastBonusGiftsMessage = false;

    public static void init() {
        ClientTickEvents.END_CLIENT_TICK.register(GalateaTracker::onTick);
        ChatEvents.RECEIVE_TEXT.register(GalateaTracker::onChat);
        SkyblockEvents.SKILL_GAINED.register(GalateaTracker::onSkillGained);
    }

    private static void onChat(class_2561 text) {
        if (!Utils.isOnSkyblock()) {
            return;
        }
        if (!Utils.isInGalatea()) {
            return;
        }
        Skyblock21Config config = Skyblock21ConfigManager.get();
        if (!config.foraging.bonusGiftsTracker && !config.foraging.galateaTracker) {
            return;
        }
        String message = text.getString();
        if (message.equals("\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac")) {
            if (!insideTreeGiftMessage) {
                insideTreeGiftMessage = true;
            } else {
                insideTreeGiftMessage = false;
                pastBonusGiftsMessage = false;
            }
        }
        if (!(message.contains("rewards gained") || insideTreeGiftMessage || message.contains("BONUS GIFT"))) {
            return;
        }
        if (message.contains("rewards gained")) {
            GalateaTracker.parseExp(text);
        } else {
            GalateaTracker.parseBonusGifts(text);
        }
        long currentTime = System.currentTimeMillis();
        if (sessionStartTime == -1L) {
            sessionStartTime = currentTime;
        }
        lastActionTime = currentTime;
        if (isAfk) {
            GalateaTracker.exitAfk();
        }
    }

    public static void onSkillGained(SkyblockEvents.Skill skill, double amount) {
        if (skill != SkyblockEvents.Skill.FORAGING) {
            return;
        }
        if (!Utils.isOnSkyblock()) {
            return;
        }
        if (!Utils.isInGalatea()) {
            return;
        }
        Skyblock21Config config = Skyblock21ConfigManager.get();
        if (!config.foraging.galateaTracker) {
            return;
        }
        totalForagingExp += (int)amount;
    }

    private static void parseBonusGifts(class_2561 text) {
        String message = text.getString();
        if (message.contains("BONUS GIFT") && !pastBonusGiftsMessage) {
            pastBonusGiftsMessage = true;
        }
        if (!message.endsWith("%)") || !pastBonusGiftsMessage) {
            return;
        }
        String itemName = TextUtils.toLegacy(text).replaceAll("\\s\u00a78\\(\u00a7a([\\d.]+%)\u00a78\\)", "").replaceAll("^\u00a7f\\s+", "");
        if (itemName.startsWith("Enchanted Book")) {
            Matcher matcher = Pattern.compile("\u00a7aEnchanted Book \\((.*?)\u00a7a\\)").matcher(itemName);
            if (matcher.find()) {
                itemName = matcher.group(1).trim();
            }
            if (itemName.isEmpty()) {
                Skyblock21.LOGGER.error("GalateaTracker - Error parsing Enchanted Book name from message: " + message);
                return;
            }
        }
        int newAmount = PersistentData.get().bonusDrops.compute(itemName, (key, value) -> value == null ? 1 : value + 1);
        if (BonusGiftsTrackerElement.INSTANCE != null) {
            BonusGiftsTrackerElement.INSTANCE.addOrUpdateGift(itemName, newAmount);
        }
    }

    private static void parseExp(class_2561 text) {
        boolean shouldUpdateRate = false;
        class_2583 style = text.method_10866();
        for (class_2561 sibling : text.method_10855()) {
            class_2583 siblingStyle;
            if (sibling.method_10866() == null || (siblingStyle = sibling.method_10866()).method_10969() == null) continue;
            style = siblingStyle;
            break;
        }
        if (style == null || style.method_10969() == null) {
            return;
        }
        class_2568 hover = style.method_10969();
        if (hover.method_10892() != class_2568.class_5247.field_24342) {
            return;
        }
        class_2561 hoverText = ((class_2568.class_10613)hover).comp_3510();
        if (hoverText == null || hoverText.method_10855().isEmpty()) {
            return;
        }
        if (hoverText.toString().trim().contains("Forest Essence")) {
            String nextLine = ((class_2561)hoverText.method_10855().getFirst()).getString().trim();
            if (nextLine.isEmpty()) {
                return;
            }
            totalForestEssence += GalateaTracker.parseNumber(nextLine);
            shouldUpdateRate = true;
        }
        for (class_2561 child : hoverText.method_10855()) {
            String line = child.getString().trim();
            int index = hoverText.method_10855().indexOf(child);
            if (index == -1 || index == hoverText.method_10855().size() - 1) continue;
            String nextChild = ((class_2561)hoverText.method_10855().get(index + 1)).getString();
            if (line.contains("Foraging Experience")) {
                totalForagingExp += GalateaTracker.parseNumber(nextChild);
                shouldUpdateRate = true;
                continue;
            }
            if (line.contains("HOTF Experience")) {
                totalHOTFExperience += GalateaTracker.parseNumber(nextChild);
                shouldUpdateRate = true;
                continue;
            }
            if (!line.contains("Forest Whispers")) continue;
            totalWhispers += GalateaTracker.parseNumber(nextChild);
            shouldUpdateRate = true;
        }
        if (shouldUpdateRate) {
            GalateaTracker.updateRatesPerHour();
        }
    }

    private static int parseNumber(String str) {
        str = str.replace(",", "").replace("x", "").trim();
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            Skyblock21.LOGGER.error("GalateaTracker - Error parsing number: " + str);
            return 0;
        }
    }

    private static void onTick(class_310 client) {
        if (client.field_1687 == null || client.field_1724 == null) {
            return;
        }
        if (!Utils.isOnSkyblock()) {
            return;
        }
        if (!Utils.isInGalatea()) {
            return;
        }
        if (sessionStartTime == -1L) {
            return;
        }
        float currentYaw = client.field_1724.method_36454();
        float currentPitch = client.field_1724.method_36455();
        class_2338 currentPosition = client.field_1724.method_24515();
        if (currentPitch != lastPitch || currentYaw != lastYaw || !currentPosition.equals((Object)lastPosition)) {
            lastActionTime = System.currentTimeMillis();
            lastYaw = currentYaw;
            lastPitch = currentPitch;
            lastPosition = currentPosition;
            if (isAfk) {
                GalateaTracker.exitAfk();
            }
        }
        long currentTime = System.currentTimeMillis();
        if (!isAfk && lastActionTime != -1L && currentTime - lastActionTime > (long)(Skyblock21ConfigManager.get().foraging.afkTimeout * 1000)) {
            isAfk = true;
            afkStartTime = currentTime;
        }
    }

    private static void exitAfk() {
        if (!isAfk || afkStartTime == -1L) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        totalAfkTime += currentTime - afkStartTime;
        isAfk = false;
    }

    private static void updateRatesPerHour() {
        long currentAfkTime;
        if (sessionStartTime == -1L) {
            cachedWhispersPerHour = 0.0;
            cachedForagingExpPerHour = 0.0;
            cachedHOTFExpPerHour = 0.0;
            cachedForagingExpPerHour = 0.0;
            cachedHOTFExpPerHour = 0.0;
            return;
        }
        long currentTime = System.currentTimeMillis();
        double activeHours = (double)(currentTime - sessionStartTime - (currentAfkTime = isAfk && afkStartTime != -1L ? totalAfkTime + (currentTime - afkStartTime) : totalAfkTime)) / 3600000.0;
        if (activeHours > 0.0) {
            cachedWhispersPerHour = Math.round((double)totalWhispers / activeHours);
            cachedForagingExpPerHour = Math.round((double)totalForagingExp / activeHours);
            cachedHOTFExpPerHour = Math.round((double)totalHOTFExperience / activeHours);
        } else {
            cachedWhispersPerHour = 0.0;
            cachedForagingExpPerHour = 0.0;
            cachedHOTFExpPerHour = 0.0;
        }
    }

    public static String getHudText() {
        if (sessionStartTime == -1L) {
            return "";
        }
        NumberFormat formatter = NumberFormat.getNumberInstance(Locale.US);
        return String.format("\u00a78Forest Essence: \u00a7f%d\n\u00a73Foraging Exp: \u00a7f%,d \u00a78(%s/hr)\n\u00a7aHOTF Exp: \u00a7f%d \u00a78(%s/hr)\n\u00a72Whispers: \u00a7f%d \u00a78(%s/hr)\n%s\n", totalForestEssence, totalForagingExp, formatter.format(cachedForagingExpPerHour), totalHOTFExperience, formatter.format(cachedHOTFExpPerHour), totalWhispers, formatter.format(cachedWhispersPerHour), isAfk ? "\u00a7c(Paused)" : "");
    }

    public static String getDummyHudText() {
        return "\u00a78Forest Essence: \u00a7f90 \u00a78(800/hr)\n\u00a73Foraging Exp: \u00a7f2,500 \u00a78(2,000/hr)\n\u00a7aHOTF Exp: \u00a7f2,500 \u00a78(14,203/hr)\n\u00a72Whispers: \u00a7f5,000 \u00a78(80,000/hr)\n\u00a7c(Paused)";
    }

    public static String getDummyBonusDropsText() {
        return "\u00a7d\u00a7lFirst Impression I\u00a7r\u00a7a: 3\n\u00a7aStretching Sticks\u00a7r\u00a7a: 6\n\u00a76Chameleon\u00a7r\u00a7a: 1";
    }

    public static void resetSession() {
        sessionStartTime = -1L;
        lastActionTime = -1L;
        afkStartTime = -1L;
        totalAfkTime = 0L;
        isAfk = false;
        totalWhispers = 0;
        totalForagingExp = 0;
        totalForestEssence = 0;
        totalHOTFExperience = 0;
        TextUtils.addMessage("\u00a7aGalatea session reset!", true, false);
    }

    public static void resetBonusGifts() {
        PersistentData.get().bonusDrops.clear();
        TextUtils.addMessage("\u00a7aBonus Gifts tracker reset!", true, false);
    }
}

