/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.hud.elements;

import com.skyblock21.config.Skyblock21ConfigManager;
import com.skyblock21.events.ChatEvents;
import com.skyblock21.events.SkyblockEvents;
import com.skyblock21.hud.MultiLineHudElement;
import com.skyblock21.hud.SortType;
import com.skyblock21.util.TextUtils;
import com.skyblock21.util.Utils;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class HuntingTrackerElement
extends MultiLineHudElement {
    private Map<String, Integer> trackedShards;
    private int totalHuntingXP = 0;
    private long activeTimeStart = System.currentTimeMillis();
    private static final Pattern SHARD_PATTERN = Pattern.compile("(?:a|(\\d+)) (.*?) \u00a7.Shard");
    private static final NumberFormat formatter = NumberFormat.getNumberInstance(Locale.US);

    public HuntingTrackerElement(int x, int y) {
        super(x, y);
        this.setTitle("\u00a79\u00a7lHunting", 0xFFFFFF, 1.2f, true);
        this.addLine("hunting_exp", (class_2561)class_2561.method_43470((String)"\u00a79Hunting XP: \u00a7f%d".formatted(this.totalHuntingXP)));
        this.addLine("active_time", (class_2561)class_2561.method_43470((String)"\u00a7dActive Time: \u00a7f0s"));
        this.createGroup("shards", "Shards", 1, true);
        this.setGroupSorting("shards", SortType.AMOUNT, false);
        this.addContainerClickableLine("reset_hunting", (class_2561)class_2561.method_43470((String)"\u00a7c[Reset Tracker]"), this::resetTracker).setHoverText((class_2561)class_2561.method_43470((String)"\u00a7eReset the hunting tracker"));
        this.trackedShards = new HashMap<String, Integer>();
        SkyblockEvents.SKILL_GAINED.register(this::onSkillGained);
        ChatEvents.RECEIVE_TEXT.register(this::onChat);
    }

    private void onChat(class_2561 text) {
        String message = text.getString();
        Matcher matcher = SHARD_PATTERN.matcher(message);
        if (!matcher.find()) {
            return;
        }
        String amount = matcher.group(1);
        String itemName = matcher.group(2);
        int count = amount != null ? Integer.parseInt(amount) : 1;
        this.addOrUpdateShard(itemName, count);
    }

    @Override
    protected void onTick(class_310 client) {
        if (this.activeTimeStart == -1L) {
            return;
        }
        this.updateLine("active_time", (class_2561)class_2561.method_43470((String)"\u00a7dActive Time: \u00a7f%s".formatted(Utils.formatTime(System.currentTimeMillis() - this.activeTimeStart))));
    }

    private void onSkillGained(SkyblockEvents.Skill skill, double amount) {
        if (skill != SkyblockEvents.Skill.HUNTING) {
            return;
        }
        if (this.totalHuntingXP == 0) {
            this.activeTimeStart = System.currentTimeMillis();
        }
        this.totalHuntingXP += (int)amount;
        this.updateLine("hunting_exp", (class_2561)class_2561.method_43470((String)"\u00a79Hunting XP: \u00a7f%s".formatted(formatter.format(this.totalHuntingXP))));
    }

    public void addOrUpdateShard(String shard, int amount) {
        if (this.trackedShards.containsKey(shard)) {
            this.updateAmountLine(shard, shard, this.trackedShards.get(shard) + amount);
            this.trackedShards.put(shard, this.trackedShards.get(shard) + amount);
        } else {
            this.addAmountLine(shard, shard, amount, "shards");
            this.trackedShards.put(shard, amount);
        }
    }

    public void resetTracker() {
        this.trackedShards.clear();
        this.totalHuntingXP = 0;
        this.lines.removeIf(line -> line.getGroupId() != null && line.getGroupId().equals("shards"));
        TextUtils.addMessage("\u00a7aHunting tracker reset!", true, false);
        this.updateLine("hunting_exp", (class_2561)class_2561.method_43470((String)"\u00a79Hunting XP: \u00a7f%d".formatted(this.totalHuntingXP)));
        this.updateLine("active_time", (class_2561)class_2561.method_43470((String)"\u00a7dActive Time: \u00a7f0s"));
        this.activeTimeStart = -1L;
    }

    @Override
    public boolean isEnabled() {
        return Skyblock21ConfigManager.get().hunting.huntingTracker;
    }
}

