/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.hud;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.skyblock21.Skyblock21;
import com.skyblock21.hud.EditGuiScreen;
import com.skyblock21.hud.EditHudElementScreen;
import com.skyblock21.hud.HudElement;
import com.skyblock21.util.Location;
import com.skyblock21.util.Utils;
import java.io.BufferedReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.client.rendering.v1.HudLayerRegistrationCallback;
import net.fabricmc.fabric.api.client.rendering.v1.IdentifiedLayer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_9779;

public class HudManager {
    public static final Path CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("skyblock21_hud.json");
    public static final List<HudElement> hudElements = new ArrayList<HudElement>();
    private static final int REFERENCE_WIDTH = 1920;
    private static final int REFERENCE_HEIGHT = 1080;
    private static int savedWidth = 1920;
    private static int savedHeight = 1080;

    public static void init() {
        HudManager.loadConfig();
        HudLayerRegistrationCallback.EVENT.register(layeredDrawerWrapper -> layeredDrawerWrapper.attachLayerAfter(IdentifiedLayer.OVERLAY_MESSAGE, class_2960.method_60655((String)"skyblock21", (String)"hud_overlay"), HudManager::render));
    }

    public static float getViewportScale() {
        class_310 client = class_310.method_1551();
        if (client.method_22683() == null) {
            return 1.0f;
        }
        int currentWidth = client.method_22683().method_4480();
        int currentHeight = client.method_22683().method_4507();
        float widthScale = (float)currentWidth / 1920.0f;
        float heightScale = (float)currentHeight / 1080.0f;
        return Math.min(widthScale, heightScale);
    }

    public static float getGuiScaleCompensation() {
        class_310 client = class_310.method_1551();
        if (client.method_22683() == null) {
            return 1.0f;
        }
        double guiScale = client.method_22683().method_4495();
        return (float)(1.0 / Math.max(1.0, guiScale / 2.0));
    }

    public static float getCombinedScale() {
        return HudManager.getViewportScale() * HudManager.getGuiScaleCompensation();
    }

    private static void render(class_332 drawContext, class_9779 renderTickCounter) {
        class_310 client = class_310.method_1551();
        if (client.field_1755 instanceof EditGuiScreen || client.field_1755 instanceof EditHudElementScreen) {
            return;
        }
        Location location = Utils.getLocation();
        class_4587 matrices = drawContext.method_51448();
        float combinedScale = HudManager.getCombinedScale();
        for (HudElement element : hudElements) {
            if (!element.isEnabled() || !element.isAllowedInLocation(location)) continue;
            matrices.method_22903();
            float scaledX = (float)element.getX() * combinedScale;
            float scaledY = (float)element.getY() * combinedScale;
            matrices.method_46416(scaledX, scaledY, 0.0f);
            float finalScale = element.getScale() * combinedScale;
            matrices.method_22905(finalScale, finalScale, 1.0f);
            element.render(drawContext, 0, 0);
            matrices.method_22909();
        }
    }

    public static void register(HudElement element) {
        hudElements.add(element);
    }

    public static List<HudElement> getElements() {
        return hudElements;
    }

    public static int toReferenceCoordinate(int screenCoordinate, boolean isWidth) {
        float currentScale = HudManager.getCombinedScale();
        if (currentScale == 0.0f) {
            return screenCoordinate;
        }
        return Math.round((float)screenCoordinate / currentScale);
    }

    public static int toScreenCoordinate(int referenceCoordinate, boolean isWidth) {
        float currentScale = HudManager.getCombinedScale();
        return Math.round((float)referenceCoordinate * currentScale);
    }

    public static void loadConfig() {
        if (!Files.exists(CONFIG_FILE, new LinkOption[0])) {
            HudManager.saveConfig();
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(CONFIG_FILE);){
            JsonObject positions;
            JsonObject object = (JsonObject)Skyblock21.GSON.fromJson((Reader)reader, JsonObject.class);
            if (object == null) {
                return;
            }
            if (object.has("savedWidth")) {
                savedWidth = object.get("savedWidth").getAsInt();
            }
            if (object.has("savedHeight")) {
                savedHeight = object.get("savedHeight").getAsInt();
            }
            if ((positions = object.getAsJsonObject("positions")) == null) {
                return;
            }
            for (HudElement element : hudElements) {
                if (!positions.has(element.getName())) continue;
                JsonObject obj = positions.getAsJsonObject(element.getName());
                if (obj == null) {
                    Skyblock21.LOGGER.warn("No position data found for HUD element: {}", (Object)element.getName());
                    continue;
                }
                if (obj.has("x")) {
                    element.setX(obj.get("x").getAsInt());
                }
                if (obj.has("y")) {
                    element.setY(obj.get("y").getAsInt());
                }
                if (obj.has("scale")) {
                    element.setScale(obj.get("scale").getAsFloat());
                }
                if (obj.has("enabled")) {
                    element.setEnabled(obj.get("enabled").getAsBoolean());
                } else {
                    element.setEnabled(true);
                }
                if (obj.has("backgroundEnabled")) {
                    element.setBackgroundEnabled(obj.get("backgroundEnabled").getAsBoolean());
                } else {
                    element.setBackgroundEnabled(false);
                }
                if (obj.has("backgroundOpacity")) {
                    element.setBackgroundOpacity(obj.get("backgroundOpacity").getAsInt());
                    continue;
                }
                element.setBackgroundOpacity(40);
            }
        }
        catch (Exception e) {
            Skyblock21.LOGGER.error("Failed to load HUD config", (Throwable)e);
            e.printStackTrace();
        }
    }

    public static void saveConfig() {
        JsonObject root = new JsonObject();
        JsonObject positions = new JsonObject();
        class_310 client = class_310.method_1551();
        if (client.method_22683() != null) {
            root.addProperty("savedWidth", (Number)client.method_22683().method_4480());
            root.addProperty("savedHeight", (Number)client.method_22683().method_4507());
        }
        for (HudElement element : hudElements) {
            JsonObject obj = new JsonObject();
            obj.addProperty("x", (Number)element.getX());
            obj.addProperty("y", (Number)element.getY());
            obj.addProperty("scale", (Number)Float.valueOf(element.getScale()));
            obj.addProperty("enabled", Boolean.valueOf(element.isEnabled()));
            obj.addProperty("backgroundEnabled", Boolean.valueOf(element.isBackgroundEnabled()));
            obj.addProperty("backgroundOpacity", (Number)element.getBackgroundOpacity());
            positions.add(element.getName(), (JsonElement)obj);
        }
        root.add("positions", (JsonElement)positions);
        try {
            Files.createDirectories(CONFIG_FILE.getParent(), new FileAttribute[0]);
            Files.writeString(CONFIG_FILE, (CharSequence)Skyblock21.GSON.toJson((JsonElement)root), new OpenOption[0]);
        }
        catch (Exception e) {
            Skyblock21.LOGGER.error("Failed to save HUD config", (Throwable)e);
            e.printStackTrace();
        }
    }
}

