/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.skyblock21.config.Skyblock21ConfigManager;
import com.skyblock21.config.Skyblock21Screen;
import com.skyblock21.config.persistent.PersistentData;
import com.skyblock21.events.SkyblockEvents;
import com.skyblock21.features.CookieGodPotReminder;
import com.skyblock21.features.CopyToClipboardRNG;
import com.skyblock21.features.HideAroundNPC;
import com.skyblock21.features.MouseLock;
import com.skyblock21.features.RunicMobsHighlight;
import com.skyblock21.features.Scathas;
import com.skyblock21.features.SpinHelper;
import com.skyblock21.features.commandaliases.CommandAliasesScreen;
import com.skyblock21.features.foraging.HOTFOverlay;
import com.skyblock21.features.foraging.TreeProgress;
import com.skyblock21.features.foraging.treewaypoints.TreeWaypoints;
import com.skyblock21.features.itemcustomization.ItemCustomizationScreen;
import com.skyblock21.features.items.StarredDropPrevention;
import com.skyblock21.features.keyshortcuts.KeyShortcuts;
import com.skyblock21.features.keyshortcuts.KeyShortcutsScreen;
import com.skyblock21.features.kuudra.Kuudra;
import com.skyblock21.features.waypoints.WaypointRenderer;
import com.skyblock21.gui.ThemeManager;
import com.skyblock21.hud.EditGuiScreen;
import com.skyblock21.hud.HudManager;
import com.skyblock21.hud.elements.BonusGiftsTrackerElement;
import com.skyblock21.hud.elements.GalateaTrackerElement;
import com.skyblock21.hud.elements.HuntingTrackerElement;
import com.skyblock21.hud.elements.ScathaTrackerElement;
import com.skyblock21.hud.elements.TestHudElement;
import com.skyblock21.hud.elements.TreeProgressHudElement;
import com.skyblock21.tracking.BaseTracker;
import com.skyblock21.tracking.TrackerManager;
import com.skyblock21.util.ItemUtils;
import com.skyblock21.util.TextUtils;
import com.skyblock21.util.TickScheduler;
import com.skyblock21.util.TickSchedulerHelper;
import com.skyblock21.util.Utils;
import com.skyblock21.util.dev.AutoUpdater;
import com.skyblock21.util.tab.TabUtils;
import java.net.URI;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1799;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_9322;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Skyblock21
implements ClientModInitializer {
    public static final String MOD_ID = "skyblock21";
    public static final String MOD_VERSION = "1.4.0.2";
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final class_310 client = class_310.method_1551();
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"skyblock21");

    private static void registerCommands() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registry) -> {
            dispatcher.register(Skyblock21.createSkyblockCommand(MOD_ID));
            dispatcher.register(Skyblock21.createSkyblockCommand("sb21"));
        });
    }

    private static LiteralArgumentBuilder<FabricClientCommandSource> createSkyblockCommand(String commandName) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)commandName).executes(ctx -> {
            client.method_63588(() -> client.method_1507((class_437)new Skyblock21Screen()));
            return 1;
        })).then(ClientCommandManager.literal((String)"config").executes(ctx -> {
            client.method_63588(() -> client.method_1507(Skyblock21ConfigManager.createGUI(null)));
            return 1;
        }))).then(ClientCommandManager.literal((String)"gui").executes(ctx -> {
            client.method_63588(() -> client.method_1507((class_437)new EditGuiScreen(Skyblock21.client.field_1755)));
            return 1;
        }))).then(ClientCommandManager.literal((String)"keys").executes(ctx -> {
            client.method_63588(() -> client.method_1507((class_437)new KeyShortcutsScreen(Skyblock21.client.field_1755)));
            return 1;
        }))).then(ClientCommandManager.literal((String)"aliases").executes(ctx -> {
            client.method_63588(() -> client.method_1507((class_437)new CommandAliasesScreen(Skyblock21.client.field_1755)));
            return 1;
        }))).then(ClientCommandManager.literal((String)"update").executes(ctx -> {
            AutoUpdater.checkForUpdateAsyncAndRestart();
            return 1;
        }))).then(ClientCommandManager.literal((String)"customize").executes(ctx -> {
            if (Skyblock21.client.field_1724 == null) {
                return 1;
            }
            class_1799 heldItem = Skyblock21.client.field_1724.method_6047();
            if (heldItem.method_7960()) {
                TextUtils.addMessage("\u00a7cYou must hold an item to customize it!", true, false);
                return 0;
            }
            String itemUuid = ItemUtils.getItemUUID((class_9322)heldItem);
            if (itemUuid.isEmpty()) {
                TextUtils.addMessage("\u00a7cThis item cannot be customized!", true, false);
                return 0;
            }
            client.method_63588(() -> client.method_1507((class_437)new ItemCustomizationScreen(heldItem)));
            return 1;
        }));
    }

    public void tick(class_310 client) {
        Utils.update();
    }

    public void onInitializeClient() {
        AutoUpdater.initialize();
        ClientTickEvents.END_CLIENT_TICK.register(this::tick);
        TickScheduler.getInstance();
        Skyblock21ConfigManager.load();
        PersistentData.init();
        Utils.init();
        TabUtils.init();
        CookieGodPotReminder.init();
        CopyToClipboardRNG.init();
        MouseLock.init();
        HideAroundNPC.init();
        KeyShortcuts.init();
        RunicMobsHighlight.init();
        Scathas.init();
        TreeProgress.init();
        HOTFOverlay.init();
        TreeWaypoints.init();
        SpinHelper.init();
        StarredDropPrevention.init();
        Kuudra.init();
        HudManager.register(new TestHudElement(100, 50));
        HudManager.register(new TreeProgressHudElement(100, 190));
        HudManager.register(new GalateaTrackerElement(10, 10));
        HudManager.register(new BonusGiftsTrackerElement(10, 40));
        HudManager.register(new ScathaTrackerElement(10, 60));
        HudManager.register(new HuntingTrackerElement(30, 20));
        HudManager.init();
        Skyblock21.registerCommands();
        ThemeManager.setTheme(PersistentData.get().theme);
        WorldRenderEvents.LAST.register(context -> WaypointRenderer.renderWaypoints(context, context.camera(), context.tickCounter().method_60636()));
        SkyblockEvents.JOIN.register(() -> {
            TrackerManager.getAllTrackers().forEach(BaseTracker::pauseTracker);
            TickSchedulerHelper.runAfterSeconds(() -> {
                if (Skyblock21.client.field_1724 == null || Skyblock21.client.field_1687 == null) {
                    return;
                }
                class_5250 message = class_2561.method_43470((String)"\u00a7b[SkyBlock\u00a7f21\u00a7b]\u00a77  \u00a7fThis mod is actively looking to ").method_10852((class_2561)class_2561.method_43470((String)"\n\u00a7fadd new features!  \u00a79\u00a7l[SUGGEST NEW FEATURES]").method_27694(style -> style.method_10958((class_2558)new class_2558.class_10608(URI.create("https://discord.gg/NMNSwQH6dr"))).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"\u00a7eClick to join Discord and suggest features")))));
                Skyblock21.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a77\u00a7m                                                              "), false);
                Skyblock21.client.field_1724.method_7353((class_2561)message, false);
                Skyblock21.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a77\u00a7m                                                              "), false);
            }, 2.0);
        });
        SkyblockEvents.LOCATION_CHANGE.register(location -> {
            PersistentData.save();
            TrackerManager.getAllTrackers().forEach(BaseTracker::pauseTracker);
        });
        SkyblockEvents.LEAVE.register(TrackerManager::saveAllTrackers);
        ClientLifecycleEvents.CLIENT_STOPPING.register(client -> {
            TrackerManager.shutdown();
            Skyblock21ConfigManager.save();
            PersistentData.save();
        });
    }
}

