/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.config;

import com.skyblock21.config.Skyblock21ConfigManager;
import com.skyblock21.config.persistent.PersistentData;
import com.skyblock21.features.commandaliases.CommandAliasesScreen;
import com.skyblock21.features.keyshortcuts.KeyShortcutsScreen;
import com.skyblock21.gui.Theme;
import com.skyblock21.gui.ThemeManager;
import com.skyblock21.gui.components.Button;
import com.skyblock21.gui.components.Label;
import com.skyblock21.gui.components.RoundedContainer;
import com.skyblock21.gui.screens.ConfirmLinkScreen;
import com.skyblock21.hud.EditGuiScreen;
import com.skyblock21.util.ColorUtil;
import com.skyblock21.util.TickSchedulerHelper;
import io.wispforest.owo.ui.base.BaseOwoScreen;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.TextureComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Animatable;
import io.wispforest.owo.ui.core.Animation;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Easing;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;

public class Skyblock21Screen
extends BaseOwoScreen<FlowLayout> {
    private static Animation animation;

    private void switchTheme() {
        Theme currentTheme = ThemeManager.getCurrentTheme();
        Theme[] themes = Theme.values();
        int currentIndex = 0;
        for (int i = 0; i < themes.length; ++i) {
            if (themes[i] != currentTheme) continue;
            currentIndex = i;
            break;
        }
        int nextIndex = (currentIndex + 1) % themes.length;
        ThemeManager.setTheme(themes[nextIndex]);
        PersistentData.get().theme = themes[nextIndex];
        animation.backwards();
        TickSchedulerHelper.runAfter(() -> {
            ((FlowLayout)this.uiAdapter.rootComponent).clearChildren();
            this.build((FlowLayout)this.uiAdapter.rootComponent);
            animation.forwards();
        }, 10L);
    }

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((class_437)this, Containers::verticalFlow);
    }

    public void method_25426() {
        super.method_25426();
        animation.forwards();
    }

    protected void build(FlowLayout rootComponent) {
        Theme theme = ThemeManager.getCurrentTheme();
        rootComponent.surface(Surface.blur((float)3.0f, (float)10.0f)).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER);
        FlowLayout mainContainer = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)85), (Sizing)Sizing.fill((int)90)).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER);
        TextureComponent logo = Components.texture((class_2960)class_2960.method_60655((String)"skyblock21", (String)"skyblock21_logo.png"), (int)0, (int)0, (int)300, (int)90, (int)300, (int)90);
        mainContainer.gap(10);
        rootComponent.child((Component)mainContainer);
        RoundedContainer actionsContainer = new RoundedContainer(Sizing.content(), Sizing.fixed((int)20), theme.getRounding(), theme.getBackground(), FlowLayout.Algorithm.VERTICAL);
        animation = actionsContainer.verticalSizing().animate(500, Easing.CUBIC, (Animatable)Sizing.content());
        actionsContainer.surface(Surface.VANILLA_TRANSLUCENT).padding(Insets.of((int)20));
        actionsContainer.gap(8);
        actionsContainer.child((Component)logo);
        actionsContainer.child(new Button((class_2561)class_2561.method_43470((String)"Config"), theme.getPrimary(), theme.getBackground(), button -> this.openConfig()).textShadow(false).horizontalSizing(Sizing.fixed((int)210))).child(new Button((class_2561)class_2561.method_43470((String)"Edit Gui"), theme.getPrimary(), theme.getBackground(), button -> this.openGuiEditor()).textShadow(false).horizontalSizing(Sizing.fixed((int)210))).child(new Button((class_2561)class_2561.method_43470((String)"Keybind shortcuts"), theme.getPrimary(), theme.getBackground(), button -> this.openKeybinds()).textShadow(false).horizontalSizing(Sizing.fixed((int)210))).child(new Button((class_2561)class_2561.method_43470((String)"Command aliases"), theme.getPrimary(), theme.getBackground(), button -> this.openAliases()).textShadow(false).horizontalSizing(Sizing.fixed((int)210))).child(new Button((class_2561)class_2561.method_43470((String)("Theme: " + theme.name())), theme.getSecondaryBackground(), theme.text, button -> this.switchTheme()).textShadow(false).horizontalSizing(Sizing.fixed((int)210)));
        actionsContainer.child((Component)new Label((class_2561)class_2561.method_43470((String)"Links")).color(Color.ofArgb((int)ColorUtil.getIntFromColor(theme.getPrimary()))).shadow(false)).horizontalAlignment(HorizontalAlignment.CENTER);
        FlowLayout linksContainer = Containers.verticalFlow((Sizing)Sizing.fixed((int)210), (Sizing)Sizing.content());
        linksContainer.gap(8);
        FlowLayout linksRow1 = Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
        linksRow1.gap(8);
        linksRow1.child(new Button((class_2561)class_2561.method_43470((String)"Discord server"), theme.getSecondaryBackground(), theme.text, button -> this.openLink("https://discord.gg/NMNSwQH6dr")).textShadow(false).horizontalSizing(Sizing.fixed((int)101))).child(new Button((class_2561)class_2561.method_43470((String)"Report bugs"), theme.getSecondaryBackground(), theme.text, button -> this.openLink("https://github.com/sme6en/Skyblock21/issues")).textShadow(false).horizontalSizing(Sizing.fixed((int)101)));
        FlowLayout linksRow2 = Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
        linksRow2.gap(8);
        linksRow2.child(new Button((class_2561)class_2561.method_43470((String)"Modrinth"), theme.getSecondaryBackground(), theme.text, button -> this.openLink("https://modrinth.com/mod/skyblock21")).textShadow(false).horizontalSizing(Sizing.fixed((int)101))).child(new Button((class_2561)class_2561.method_43470((String)"Source code"), theme.getSecondaryBackground(), theme.text, button -> this.openLink("https://github.com/sme6en/Skyblock21")).textShadow(false).horizontalSizing(Sizing.fixed((int)101)));
        linksContainer.child((Component)linksRow1).child((Component)linksRow2);
        actionsContainer.child((Component)linksContainer);
        actionsContainer.child(Components.spacer().sizing(Sizing.fixed((int)10)));
        actionsContainer.child(new Button((class_2561)class_2561.method_43470((String)"Done"), theme.getPrimary(), theme.getBackground(), button -> this.method_25419()).textShadow(false).horizontalSizing(Sizing.fixed((int)210)));
        mainContainer.child((Component)actionsContainer);
    }

    private void openConfig() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(Skyblock21ConfigManager.createGUI((class_437)this));
        }
    }

    private void openGuiEditor() {
        animation.backwards();
        TickSchedulerHelper.runAfter(() -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507((class_437)new EditGuiScreen((class_437)this));
            }
        }, 10L);
    }

    private void openKeybinds() {
        animation.backwards();
        TickSchedulerHelper.runAfter(() -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507((class_437)new KeyShortcutsScreen((class_437)this));
            }
        }, 10L);
    }

    private void openAliases() {
        animation.backwards();
        TickSchedulerHelper.runAfter(() -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507((class_437)new CommandAliasesScreen((class_437)this));
            }
        }, 10L);
    }

    private void openLink(String url) {
        if (this.field_22787 != null) {
            this.field_22787.method_1507((class_437)new ConfirmLinkScreen(confirmed -> {
                if (confirmed.booleanValue()) {
                    class_156.method_668().method_670(url);
                }
                this.field_22787.method_1507((class_437)this);
            }, url, true));
        }
    }

    public void method_25419() {
        animation.backwards();
        TickSchedulerHelper.runAfter(() -> super.method_25419(), 10L);
    }
}

