/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.features;

import com.skyblock21.config.Skyblock21ConfigManager;
import com.skyblock21.events.SkyblockEvents;
import com.skyblock21.mixin.accessors.PlayerListHudAccessor;
import com.skyblock21.util.TextUtils;
import com.skyblock21.util.Utils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_310;

public class CookieGodPotReminder {
    private static final Pattern COOKIE_DURATION_REGEX = Pattern.compile("^(\\d+)\\s+(hours|seconds)");
    private static boolean shouldCheck = false;
    private static boolean checked = false;

    public static void init() {
        SkyblockEvents.JOIN.register(() -> {
            shouldCheck = true;
            checked = false;
        });
        ClientTickEvents.END_CLIENT_TICK.register(CookieGodPotReminder::onTick);
    }

    public static void checkCookieAndGodPotion() {
        if (!Utils.isOnSkyblock()) {
            return;
        }
        String footerText = ((PlayerListHudAccessor)class_310.method_1551().field_1705.method_1750()).getFooter().getString();
        if (footerText == null || footerText.isEmpty() || !footerText.contains("Cookie Buff")) {
            return;
        }
        String[] footerLines = footerText.split("\n");
        if (footerLines.length < 7) {
            return;
        }
        String durationText = footerLines[6];
        checked = true;
        Matcher matcher = COOKIE_DURATION_REGEX.matcher(durationText);
        if (footerText.contains("Not active! Obtain booster cookies from the community") && Skyblock21ConfigManager.get().general.boosterCookieReminder) {
            TextUtils.addMessageWithCommandButton("\u00a7cYou don't have an active Booster Cookie!", true, "\u00a7aClick here to go to lobby", "/warp hub");
        } else if (matcher.find() && Skyblock21ConfigManager.get().general.boosterCookieReminder) {
            int value = Integer.parseInt(matcher.group(1));
            String unit = matcher.group(2);
            if (unit.equals("seconds") || value < Skyblock21ConfigManager.get().general.boosterCookieReminderHours) {
                TextUtils.addMessageWithCommandButton("\u00a7cBooster Cookie expires soon! ", true, "\u00a7\u0430Click here to buy", "/bz booster");
            }
        }
        if (footerText.contains("No effects active. Drink Potions") && Skyblock21ConfigManager.get().general.godPotReminder) {
            TextUtils.addMessage("\u00a76You don't have a God potion!", true, false);
        }
    }

    public static void onTick(class_310 client) {
        if (!shouldCheck) {
            return;
        }
        if (checked) {
            return;
        }
        if (!Utils.isOnSkyblock()) {
            return;
        }
        if (class_310.method_1551().field_1705 == null) {
            return;
        }
        if (((PlayerListHudAccessor)class_310.method_1551().field_1705.method_1750()).getFooter() == null) {
            return;
        }
        String footerText = ((PlayerListHudAccessor)class_310.method_1551().field_1705.method_1750()).getFooter().getString();
        if (footerText.contains("Cookie Buff")) {
            CookieGodPotReminder.checkCookieAndGodPotion();
        }
    }
}

