/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.features;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.skyblock21.Skyblock21;
import com.skyblock21.features.waypoints.Waypoint;
import com.skyblock21.features.waypoints.WaypointManager;
import com.skyblock21.mixin.accessors.ChatHudAccessor;
import com.skyblock21.util.TextUtils;
import java.util.HashMap;
import java.util.SequencedCollection;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenKeyboardEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1304;
import net.minecraft.class_1531;
import net.minecraft.class_1570;
import net.minecraft.class_1707;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_303;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_476;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7887;
import net.minecraft.class_7923;
import net.minecraft.class_8113;
import net.minecraft.class_9326;

public class Debug {
    private static final Codec<class_6880<class_1792>> EMPTY_ALLOWING_ITEM_CODEC = class_7923.field_41178.method_40294();
    public static final Codec<class_1799> EMPTY_ALLOWING_ITEMSTACK_CODEC = Codec.lazyInitialized(() -> RecordCodecBuilder.create(instance -> instance.group((App)EMPTY_ALLOWING_ITEM_CODEC.fieldOf("id").forGetter(class_1799::method_41409), (App)Codec.INT.orElse((Object)1).fieldOf("count").forGetter(class_1799::method_7947), (App)class_9326.field_49589.optionalFieldOf("components", (Object)class_9326.field_49588).forGetter(class_1799::method_57380)).apply((Applicative)instance, class_1799::new)));
    private static final class_7225.class_7874 LOOKUP = class_7887.method_46817();
    public static class_304 dumpGui = new class_304("Dump GUI", 74, "SkyBlock 21");
    public static class_304 g_key = new class_304("G key", 71, "SkyBlock 21");

    public static void init() {
        ClientTickEvents.END_CLIENT_TICK.register(Debug::onTick);
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            if (!(screen instanceof class_465)) {
                return;
            }
            class_465 handledScreen = (class_465)screen;
            ScreenKeyboardEvents.afterKeyPress((class_437)class_310.method_1551().field_1755).register((screen2, keyCode, scanCode, modifiers) -> {
                if (dumpGui.method_1417(keyCode, scanCode)) {
                    Debug.copyGui(screen2);
                }
            });
        });
        ClientCommandRegistrationCallback.EVENT.register((commandDispatcher, commandRegistryAccess) -> commandDispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"debugarmorstands").executes(Debug::copyArmorStands)));
        ClientCommandRegistrationCallback.EVENT.register((commandDispatcher, commandRegistryAccess) -> commandDispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"debugchat").executes(Debug::copyChat)));
        ClientCommandRegistrationCallback.EVENT.register((commandDispatcher, commandRegistryAccess) -> commandDispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"debugentities").executes(Debug::copyEntities)));
        ClientCommandRegistrationCallback.EVENT.register((commandDispatcher, commandRegistryAccess) -> commandDispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"debughovered").executes(Debug::copyEntityHovered)));
    }

    private static void onTick(class_310 minecraftClient) {
        while (g_key.method_1436()) {
            class_239 res;
            if (minecraftClient.field_1755 != null || (res = minecraftClient.field_1724.method_5745(5.0, 0.0f, false)) == null || res.method_17783() != class_239.class_240.field_1332) continue;
            class_2338 pos = ((class_3965)res).method_17777();
            Waypoint w = WaypointManager.addWaypoint("Dumb ass", pos, false);
            w.setBeaconBeam(true);
            class_2818 chunk = minecraftClient.field_1687.method_8500(pos);
            class_2680 newState = chunk.method_12010(pos, class_2246.field_10124.method_9564(), 0);
            if (newState != null) continue;
            System.out.println("failed");
        }
    }

    public static int copyChat(CommandContext<FabricClientCommandSource> ctx) {
        int startIndex;
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null) {
            TextUtils.addMessage("No world loaded!", true, false);
            return 1;
        }
        SequencedCollection messages = ((ChatHudAccessor)client.field_1705.method_1743()).getMessages().reversed();
        JsonArray jsonArray = new JsonArray();
        for (int i = startIndex = Math.max(0, messages.size() - 30); i < messages.size(); ++i) {
            class_303 line = (class_303)messages.get(i);
            class_2561 message = line.comp_893();
            String jsonText = class_2561.class_2562.method_10867((class_2561)message, (class_7225.class_7874)client.method_1562().method_29091());
            jsonArray.add((JsonElement)new JsonPrimitive(jsonText));
        }
        client.field_1774.method_1455(Skyblock21.GSON.toJson((JsonElement)jsonArray));
        TextUtils.addMessage("Copied chat data to clipboard!", true, true);
        return 1;
    }

    public static int copyArmorStands(CommandContext<FabricClientCommandSource> ctx) {
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null) {
            TextUtils.addMessage("No world loaded!", true, false);
            return 1;
        }
        JsonObject rootObject = new JsonObject();
        JsonArray armorStandsArray = new JsonArray();
        client.field_1687.method_8390(class_1531.class, class_310.method_1551().field_1724.method_5829().method_1014(40.0), class_1301.field_6153).forEach(armorStand -> {
            class_1799 offHandItem;
            class_1799 mainHandItem;
            JsonObject armorStandObject = new JsonObject();
            armorStandObject.addProperty("id", armorStand.method_5667().toString());
            armorStandObject.addProperty("name", armorStand.method_16914() ? armorStand.method_5797().getString() : "");
            JsonObject equipmentObject = new JsonObject();
            class_1799 headItem = armorStand.method_6118(class_1304.field_6169);
            if (!headItem.method_7960()) {
                equipmentObject.addProperty("head", Debug.formatStack(headItem).getString());
            }
            if (!(mainHandItem = armorStand.method_6118(class_1304.field_6173)).method_7960()) {
                equipmentObject.addProperty("main_hand", Debug.formatStack(mainHandItem).getString());
            }
            if (!(offHandItem = armorStand.method_6118(class_1304.field_6171)).method_7960()) {
                equipmentObject.addProperty("off_hand", Debug.formatStack(offHandItem).getString());
            }
            armorStandObject.add("equipment", (JsonElement)equipmentObject);
            armorStandsArray.add((JsonElement)armorStandObject);
        });
        rootObject.add("armor_stands", (JsonElement)armorStandsArray);
        Gson gson = Skyblock21.GSON;
        client.field_1774.method_1455(gson.toJson((JsonElement)rootObject));
        TextUtils.addMessage("Copied armor stands data to clipboard!", true, true);
        return 1;
    }

    public static int copyEntityHovered(CommandContext<FabricClientCommandSource> context) {
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null) {
            TextUtils.addMessage("No world loaded!", true, false);
            return 1;
        }
        class_1570 targetEntity = Debug.getTargetOtherPlayerEntity(client);
        if (targetEntity == null) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u00a7cNo OtherClientPlayerEntity found! Look at a player entity."));
            return 0;
        }
        try {
            JsonObject entityData = Debug.extractEntityData(targetEntity);
            String jsonString = new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)entityData);
            client.field_1774.method_1455(jsonString);
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u00a7aEntity data copied to clipboard!"));
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a77Entity: " + targetEntity.method_5477().getString())));
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a77UUID: " + String.valueOf(targetEntity.method_5667()))));
            return 1;
        }
        catch (Exception e) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7cError copying entity data: " + e.getMessage())));
            return 0;
        }
    }

    private static class_1570 getTargetOtherPlayerEntity(class_310 mc) {
        class_3966 entityHitResult;
        class_1297 entity;
        class_239 hitResult = mc.field_1765;
        if (hitResult instanceof class_3966 && (entity = (entityHitResult = (class_3966)hitResult).method_17782()) instanceof class_1570) {
            return (class_1570)entity;
        }
        class_243 playerPos = mc.field_1724.method_19538();
        double maxDistance = 10.0;
        class_1570 closest = null;
        double closestDistance = Double.MAX_VALUE;
        for (class_1297 entity2 : mc.field_1687.method_18112()) {
            if (!(entity2 instanceof class_1570)) continue;
            class_1570 giant = (class_1570)entity2;
            double distance = entity2.method_5707(playerPos);
            if (!(distance < maxDistance * maxDistance) || !(distance < closestDistance)) continue;
            closest = giant;
            closestDistance = distance;
        }
        return closest;
    }

    private static JsonObject extractEntityData(class_1570 entity) {
        JsonObject data = new JsonObject();
        data.addProperty("entityType", "OtherClientPlayerEntity");
        data.addProperty("uuid", entity.method_5667().toString());
        data.addProperty("name", entity.method_5477().getString());
        data.addProperty("displayName", entity.method_5476().getString());
        data.addProperty("customName", entity.method_16914() ? entity.method_5797().getString() : null);
        data.addProperty("idVersion", (Number)entity.method_5667().version());
        JsonObject position = new JsonObject();
        position.addProperty("x", (Number)entity.method_23317());
        position.addProperty("y", (Number)entity.method_23318());
        position.addProperty("z", (Number)entity.method_23321());
        data.add("position", (JsonElement)position);
        JsonObject blockPos = new JsonObject();
        blockPos.addProperty("x", (Number)entity.method_31477());
        blockPos.addProperty("y", (Number)entity.method_31478());
        blockPos.addProperty("z", (Number)entity.method_31479());
        data.add("blockPosition", (JsonElement)blockPos);
        JsonObject velocity = new JsonObject();
        velocity.addProperty("x", (Number)entity.method_18798().field_1352);
        velocity.addProperty("y", (Number)entity.method_18798().field_1351);
        velocity.addProperty("z", (Number)entity.method_18798().field_1350);
        data.add("velocity", (JsonElement)velocity);
        data.addProperty("yaw", (Number)Float.valueOf(entity.method_36454()));
        data.addProperty("pitch", (Number)Float.valueOf(entity.method_36455()));
        data.addProperty("headYaw", (Number)Float.valueOf(entity.method_5791()));
        data.addProperty("bodyYaw", (Number)Float.valueOf(entity.method_43078()));
        data.addProperty("health", (Number)Float.valueOf(entity.method_6032()));
        data.addProperty("maxHealth", (Number)Float.valueOf(entity.method_6063()));
        data.addProperty("absorptionAmount", (Number)Float.valueOf(entity.method_6067()));
        data.addProperty("air", (Number)entity.method_5669());
        data.addProperty("maxAir", (Number)entity.method_5748());
        data.addProperty("age", (Number)entity.field_6012);
        data.addProperty("isOnGround", Boolean.valueOf(entity.method_24828()));
        data.addProperty("isSneaking", Boolean.valueOf(entity.method_5715()));
        data.addProperty("isSprinting", Boolean.valueOf(entity.method_5624()));
        data.addProperty("isSwimming", Boolean.valueOf(entity.method_5681()));
        data.addProperty("isInvisible", Boolean.valueOf(entity.method_5767()));
        data.addProperty("isGlowing", Boolean.valueOf(entity.method_5851()));
        data.addProperty("isSleeping", Boolean.valueOf(entity.method_6113()));
        data.addProperty("isAlive", Boolean.valueOf(entity.method_5805()));
        data.addProperty("isRemoved", Boolean.valueOf(entity.method_31481()));
        JsonObject equipment = new JsonObject();
        equipment.addProperty("mainHand", Debug.getItemStackInfo(entity.method_6047()));
        equipment.addProperty("offHand", Debug.getItemStackInfo(entity.method_6079()));
        data.add("equipment", (JsonElement)equipment);
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 != null) {
            data.addProperty("distanceFromPlayer", (Number)Float.valueOf(entity.method_5739((class_1297)mc.field_1724)));
        }
        HashMap metadata = new HashMap();
        return data;
    }

    private static String getItemStackInfo(class_1799 stack) {
        if (stack.method_7960()) {
            return "empty";
        }
        StringBuilder info = new StringBuilder();
        info.append(stack.method_7909().method_7876());
        if (stack.method_7947() > 1) {
            info.append(" x").append(stack.method_7947());
        }
        if (stack.method_65130() != null) {
            info.append(" (").append(stack.method_7964().getString()).append(")");
        }
        return info.toString();
    }

    public static int copyEntities(CommandContext<FabricClientCommandSource> ctx) {
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null) {
            TextUtils.addMessage("No world loaded!", true, false);
            return 1;
        }
        StringBuilder json = new StringBuilder("{\n");
        json.append("  \"entities\": [\n");
        client.field_1687.method_18112().forEach(entity -> {
            json.append("    {\n");
            json.append("      \"id\": \"").append(entity.method_5667()).append("\",\n");
            json.append("      \"class_name\": \"").append(entity.getClass().getSimpleName()).append("\",\n");
            json.append("      \"uuid\": \"").append(entity.method_5845()).append("\",\n");
            json.append("      \"type\": \"").append(class_7923.field_41177.method_10221((Object)entity.method_5864())).append("\",\n");
            json.append("      \"name\": \"").append(entity.method_16914() ? entity.method_5797().getString() : "").append("\",\n");
            json.append("      \"position\": {\n");
            json.append("        \"x\": ").append(entity.method_23317()).append(",\n");
            json.append("        \"y\": ").append(entity.method_23318()).append(",\n");
            json.append("        \"z\": ").append(entity.method_23321()).append("\n");
            json.append("      },\n");
            if (entity instanceof class_1570) {
                json.append("      \"heldItem\": {\n");
                class_1799 mainHandStack = ((class_1570)entity).method_6047();
                json.append("        \"item\": ").append(Debug.formatStack(mainHandStack)).append("\n");
                json.append("      }\n");
            }
            if (entity instanceof class_8113.class_8115) {
                json.append("      \"blockState\": {\n");
                class_2680 blockState = ((class_8113.class_8115)entity).method_48884();
                json.append("        \"block\": \"").append(class_7923.field_41175.method_10221((Object)blockState.method_26204())).append("\",\n");
                json.append("        \"properties\": {\n");
                blockState.method_11656().forEach((property, value) -> {
                    json.append("          \"").append(property.method_11899()).append("\": ");
                    if (value instanceof String) {
                        json.append("\"").append(value).append("\"");
                    } else {
                        json.append(value);
                    }
                    json.append(",\n");
                });
            }
            json.append("    },\n");
        });
        if (json.charAt(json.length() - 2) == ',') {
            json.deleteCharAt(json.length() - 2);
        }
        json.append("  ]\n");
        json.append("}");
        client.field_1774.method_1455(json.toString());
        TextUtils.addMessage("Copied entities data to clipboard!", true, true);
        return 1;
    }

    public static void copyGui(class_437 screen) {
        if (!(screen instanceof class_476)) {
            return;
        }
        class_476 gui = (class_476)screen;
        StringBuilder json = new StringBuilder("{\n");
        json.append("  \"title\": \"").append(gui.method_25440().getString()).append("\",\n");
        json.append("  \"width\": ").append(gui.field_22789).append(",\n");
        json.append("  \"height\": ").append(gui.field_22790).append(",\n");
        json.append("  \"items\": [\n");
        ((class_1707)gui.method_17577()).field_7761.forEach(slot -> {
            class_1799 stack = slot.method_7677();
            if (stack.method_7960()) {
                return;
            }
            json.append("    {\n");
            json.append("      \"slot\": ").append(slot.field_7874).append(",\n");
            json.append("      \"customName\": \"").append(slot.method_7677().method_65130() != null ? TextUtils.toLegacy(slot.method_7677().method_65130()) : "").append("\",\n");
            json.append("      \"item\": ").append((Object)(stack.method_7960() ? "null" : Debug.formatStack(stack))).append("\n");
            json.append("    },\n");
        });
        if (json.charAt(json.length() - 2) == ',') {
            json.deleteCharAt(json.length() - 2);
        }
        json.append("  ]\n");
        json.append("}");
        class_310.method_1551().field_1774.method_1455(json.toString());
        TextUtils.addMessage("Copied GUI data to clipboard!", true, false);
    }

    public static class_2561 formatStack(class_1799 stack) {
        return class_2561.method_43470((String)Skyblock21.GSON.toJson((JsonElement)EMPTY_ALLOWING_ITEMSTACK_CODEC.encodeStart((DynamicOps)Debug.getRegistryWrapperLookup().method_57093((DynamicOps)JsonOps.INSTANCE), (Object)stack).getOrThrow()));
    }

    public static class_7225.class_7874 getRegistryWrapperLookup() {
        class_310 client = class_310.method_1551();
        return client != null && client.method_1562() != null && client.method_1562().method_29091() != null ? client.method_1562().method_29091() : LOOKUP;
    }
}

